/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.DockerImagePushFailedException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerProgressDetail;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IDockerProgressMessage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerMessages;
import org.eclipse.linuxtools.internal.docker.core.ProgressJob;

public class DefaultImagePushProgressHandler
implements IDockerProgressHandler {
    private static final String IMAGE_UPLOAD_COMPLETE = "ImageUploadComplete.msg";
    private static final String IMAGE_UPLOAD_ALREADY_COMPLETE = "ImageUploadAlreadyComplete.msg";
    private static final String IMAGE_UPLOADING_JOBNAME = "ImageUploadingJobName.msg";
    private static final String IMAGE_UPLOADING_IMAGE = "ImageUploadingImage.msg";
    private static final String IMAGE_UPLOADING = "ImageUploading.msg";
    private String image;
    private DockerConnection connection;
    private Map<String, ProgressJob> progressJobs = new HashMap<String, ProgressJob>();

    public DefaultImagePushProgressHandler(IDockerConnection connection, String image) {
        this.image = image;
        this.connection = (DockerConnection)connection;
    }

    @Override
    public void processMessage(IDockerProgressMessage message) throws DockerException {
        if (message.error() != null) {
            this.stopAllJobs();
            throw new DockerImagePushFailedException(this.image, message.error());
        }
        String id = message.id();
        if (id != null) {
            ProgressJob p = this.progressJobs.get(id);
            if (p == null) {
                String status = message.status();
                if (status.equals(DockerMessages.getString(IMAGE_UPLOAD_COMPLETE)) || status.contains(DockerMessages.getString(IMAGE_UPLOAD_ALREADY_COMPLETE))) {
                    this.connection.getImages(true);
                } else {
                    ProgressJob newJob = new ProgressJob(DockerMessages.getFormattedString(IMAGE_UPLOADING_JOBNAME, this.image), DockerMessages.getFormattedString(IMAGE_UPLOADING_IMAGE, id));
                    newJob.setUser(false);
                    newJob.setPriority(30);
                    newJob.schedule();
                    this.progressJobs.put(id, newJob);
                }
            } else {
                IDockerProgressDetail detail;
                String status = message.status();
                if (status.equals(DockerMessages.getString(IMAGE_UPLOAD_COMPLETE)) || status.contains(DockerMessages.getString(IMAGE_UPLOAD_ALREADY_COMPLETE))) {
                    p.setPercentageDone(100);
                    this.connection.getImages(true);
                } else if (status.startsWith(DockerMessages.getString(IMAGE_UPLOADING)) && (detail = message.progressDetail()) != null && detail.current() > 0L && detail.total() > 0L) {
                    long percentage = detail.current() * 100L / detail.total();
                    p.setPercentageDone((int)percentage);
                }
            }
        }
    }

    private void stopAllJobs() {
        for (ProgressJob j : this.progressJobs.values()) {
            j.cancel();
        }
    }
}

