/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import java.awt.AWTError;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class Deck
extends JPanel {
    private int cardNum;

    public Deck() {
        this("deck");
    }

    public Deck(String name) {
        super(new CardLayout());
        this.setName(name);
    }

    public Deck(String name, Component ... comps) {
        this(name);
        for (Component comp : comps) {
            this.add(comp);
        }
    }

    @Override
    public void setLayout(LayoutManager lm) {
        if (!(lm instanceof CardLayout)) {
            throw new AWTError("Can't set layout for " + this.getClass().getName());
        }
        super.setLayout(lm);
    }

    @Override
    public Component add(Component comp) {
        if (comp.getName() == null) {
            comp.setName("card" + this.cardNum++);
        }
        super.add(comp, comp.getName());
        return comp;
    }

    @Override
    public void add(Component comp, Object x) {
        this.add(comp);
    }

    public Component getCurrentCard() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!c.isVisible()) continue;
            return c;
        }
        return null;
    }

    public void show(Component comp) {
        ((CardLayout)this.getLayout()).show(this, comp.getName());
    }
}

