/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.bind.util.enumeration_1_result;

import jakarta.xml.bind.util.JAXBResult;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.Marshaller;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class CtorGetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        CtorGetCTTests test = new CtorGetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status CtorGet001( ) {
        JAXBContext jc = null;
         try {
             jc = getJAXBContext();
         } catch (JAXBException je){
             return Status.failed("Unable to create a valid context");
         }
         try {
             new JAXBResult(jc);
         } catch (JAXBException je){
             return Status.failed("JAXBResult(context) with valid JAXBContext throws JAXBException");
         }
         return Status.passed("OKAY");
    }

    public Status CtorGet002( ) {
        JAXBContext jc = null;
         JAXBResult res = null;
     
         try {
             jc = getJAXBContext();
             res = new JAXBResult(jc);
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             res.getResult();
         } catch (JAXBException je){
             return Status.failed("new JAXBResult(JAXBContext).getResult() throws JAXBException");
         } catch (IllegalStateException ise){
             return Status.passed("OKAY, IllegalStateException is thrown");
         }
         return Status.failed("new JAXBResult(JAXBContext).getResult() does not throw IllegalStateException");
    }

    public Status CtorGet003( ) {
        try {
             new JAXBResult((JAXBContext)null);
         } catch (JAXBException je){
             return Status.passed("OKAY");
         }
         return Status.failed("JAXBResult((JAXBContext)null) throws no exceptions");
    }

    public Status CtorGet004( ) {
        JAXBContext jc = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
             new JAXBResult(um);
             return Status.passed("OKAY");
         } catch (JAXBException je){
             return Status.failed("JAXBException: unable to create valid context or unmarshaller");
         }
    }

    public Status CtorGet005( ) {
        try {
             new JAXBResult((Unmarshaller)null);
         } catch (JAXBException je){
             return Status.passed("OKAY");
         }
         return Status.failed("JAXBResult((Unmarshaller)null) throws no exceptions");
    }

    public Status CtorGet006( ) {
        JAXBContext jc = null;
         Unmarshaller um = null;
         JAXBResult res = null;
     
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
             res = new JAXBResult(um);
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             res.getResult();
         } catch (JAXBException je){
             return Status.failed("new JAXBResult(Unmarshaller).getResult() throws JAXBException");
         } catch (IllegalStateException ise){
             return Status.passed("OKAY, IllegalStateException is thrown");
         }
         return Status.failed("new JAXBResult(Unmarshaller).getResult() does not throw IllegalStateException");
    }

    public Status CtorGet007( ) {
        JAXBContext jc = null;
         Unmarshaller um = null;
         Marshaller m = null;
         JAXBResult res = null;
         Object obj = null;
         Object objRes = null;
         
         obj = unmarshal("enumeration-1-result.xml");
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
              m = jc.createMarshaller();
             res = new JAXBResult(um);
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or marshaller or unmarshaller object");
         }

         try {
             m.marshal(obj, res);
         } catch (JAXBException je){
             return Status.failed("JAXBException: unable to marshal valid object into JAXBResult");
         }
         try {
             if ((objRes = res.getResult()) == null){
                 return Status.failed("after marshalling of valid object into JAXBResult, getResult() returns null");
             }
         } catch (JAXBException je){
             return Status.failed("after successfull unmarshalling JAXBResult.getResult() throws JAXBException");
         }
         if (!((JAXBElement<Long>)obj).getValue().equals(((JAXBElement<Long>)objRes).getValue())){
             return Status.failed("transformation result object is not equivalent to the original");
         }
         try {
             if ((objRes = res.getResult()) == null){
                 return Status.failed("after marshalling of valid object into JAXBResult, second call to getResult() returns null");
             }
         } catch (JAXBException je){
             return Status.failed("after successfull unmarshalling second call to JAXBResult.getResult() throws JAXBException");
         }
         return Status.passed("OKAY");
    }


}

