/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.negdep.onmessage.srv.binaryduplicate;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.negdep.NegativeDeploymentClient;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends NegativeDeploymentClient {
    private static final long serialVersionUID = 111L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_negdep_onmessage_srv_binaryinputstreamboolean_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSCClientIT.class}), new String[]{"com.sun.ts.tests.websocket.negdep.onmessage.srv.binaryduplicate"});
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{NegativeDeploymentClient.class}), new String[]{"com.sun.ts.tests.websocket.negdep"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_negdep_onmessage_srv_binaryduplicate_web");
    }

    @Test
    public void duplicateOnMessageUndeployOtherEndpointTest() throws Exception {
        this.setProperty(WebSocketCommonClient.Property.CONTENT, "anything");
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("echo"));
        this.setProperty(WebSocketCommonClient.Property.STATUS_CODE, "-1");
        try {
            this.invoke(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String response = this.getResponseAsString();
        if ("anything".equals(response)) {
            this.throwValidEndpointMustBeRemoved();
        }
    }

    @Test
    public void duplicateOnMessageTest() throws Exception {
        this.setEntity(ByteBuffer.wrap("anything".getBytes()));
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest("invalid"));
        this.setProperty(WebSocketCommonClient.Property.STATUS_CODE, "-1");
        try {
            this.invoke(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String response = this.getResponseAsString();
        if (response != null && response.contains("anything")) {
            this.throwValidEndpointMustBeRemoved();
        }
    }
}

