/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async;

import com.sun.ts.tests.websocket.common.client.SendMessageCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.WSCServerSideServer;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.IOException;

public class PokingEndpointCallback
extends SendMessageCallback {
    private Session session;
    int pokeCnt = 0;
    int pokeMax = 1;

    public PokingEndpointCallback(WebSocketCommonClient.Entity entity) {
        super(entity);
    }

    @Override
    public void onOpen(Session session, EndpointConfig config) {
        super.onOpen(session, config);
        this.session = session;
    }

    public void onMessage(String msg, Session session) throws IOException {
        if (msg.equals(WSCServerSideServer.RESPONSE[0]) || msg.equals(WSCServerSideServer.RESPONSE[1])) {
            return;
        }
        if (msg.startsWith("-100")) {
            msg = OPS.SENDOBJECT_BYTE.name();
        } else if (msg.startsWith("-101")) {
            msg = OPS.SENDOBJECT_SHORT.name();
        } else if (msg.startsWith("-102")) {
            msg = OPS.SENDOBJECT_INT.name();
        } else if (msg.startsWith("-103")) {
            msg = OPS.SENDOBJECT_LONG.name();
        } else if (msg.startsWith("-104")) {
            msg = OPS.SENDOBJECT_FLOAT.name();
        } else if (msg.startsWith("-105")) {
            msg = OPS.SENDOBJECT_DOUBLE.name();
        } else if (msg.startsWith(String.valueOf('j'))) {
            msg = OPS.SENDOBJECT_CHAR.name();
        } else if (msg.startsWith("false")) {
            msg = OPS.SENDOBJECT_BOOL.name();
        }
        OPS ops = OPS.valueOf(msg);
        switch (ops) {
            case SENDBINARY: 
            case SENDBINARYHANDLER: 
            case SENDOBJECT: 
            case SENDOBJECT_BOOL: 
            case SENDOBJECT_BYTE: 
            case SENDOBJECT_CHAR: 
            case SENDOBJECT_DOUBLE: 
            case SENDOBJECT_FLOAT: 
            case SENDOBJECT_INT: 
            case SENDOBJECT_LONG: 
            case SENDOBJECT_SHORT: 
            case SENDOBJECTHANDLER: 
            case SENDTEXT: 
            case SENDTEXTHANDLER: 
            case BATCHING_ALLOWED: 
            case SEND_PONG: {
                if (this.pokeCnt++ > this.pokeMax) break;
                session.getBasicRemote().sendText(OPS.POKE.name());
                break;
            }
            case SENDBINARYTHROWS: 
            case SENDBINARYEXECUTIONEXCEPTION: 
            case SENDBINARYHANDLERTHROWSONDATA: 
            case SENDBINARYHANDLERTHROWSONHANDLER: 
            case SENDOBJECTHANDLEREXECUTIONEXCEPTION: 
            case SENDOBJECTHANDLERTHROWSONDATA: 
            case SENDOBJECTHANDLERTHROWSONHANDLER: 
            case SENDOBJECTEXECUTIONEXCEPTION: 
            case SENDOBJECTTHROWS: 
            case SENDTEXTTHROWS: 
            case SENDTEXTHANDLERTHROWSONDATA: 
            case SENDTEXTHANDLERTHROWSONHANDLER: 
            case POKE: 
            case TIMEOUT: 
            case SEND_PING: 
            case SEND_PING_THROWS: 
            case SEND_PONG_THROWS: {
                break;
            }
        }
    }

    @Override
    public void onMessage(Object o) {
        super.onMessage(o);
        try {
            String msg = o.toString();
            this.onMessage(msg, this.session);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

