/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.viewengine.algorithm;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import jakarta.mvc.tck.tests.viewengine.algorithm.CustomFaceletsViewEngine;
import jakarta.mvc.tck.tests.viewengine.algorithm.CustomHighPrioViewEngine;
import jakarta.mvc.tck.tests.viewengine.algorithm.CustomLowPrioViewEngine;
import jakarta.mvc.tck.tests.viewengine.algorithm.NoMatchViewEngine;
import jakarta.mvc.tck.tests.viewengine.algorithm.ViewEngineAlgorithmController;
import jakarta.mvc.tck.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class ViewEngineAlgorithmTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(ViewEngineAlgorithmController.class).addClass(CustomHighPrioViewEngine.class).addClass(CustomLowPrioViewEngine.class).addClass(CustomFaceletsViewEngine.class).addClass(NoMatchViewEngine.class).addView("viewengine/algo/view.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="selection_algorithm", id="selection-algo")})
    public void priorityOrderingCustomEngines() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/viewengine/algorithm/custom-ordering").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.equalTo((Object)"CustomHighPrioViewEngine"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="selection_algorithm", id="selection-algo")})
    public void overwriteBuiltinEngine() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/viewengine/algorithm/overwrite-builtin").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.equalTo((Object)"CustomFaceletsViewEngine"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="selection_algorithm", id="path-relative")})
    public void relativeViewPath() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/viewengine/algorithm/relative-path").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"1 + 2 = 3"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="selection_algorithm", id="path-absolute")})
    public void absoluteViewPath() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/viewengine/algorithm/absolute-path").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"1 + 2 = 3"));
    }
}

