/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;

public class DefaultCredentialsProvider
implements CredentialsProvider,
Serializable {
    private final Map<AuthScopeProxy, Credentials> credentialsMap_ = new HashMap<AuthScopeProxy, Credentials>();

    public void addCredentials(String username, String password) {
        this.addCredentials(username, password, AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
    }

    public void addCredentials(String username, String password, String host, int port, String realm) {
        AuthScope authscope = new AuthScope(host, port, realm, AuthScope.ANY_SCHEME);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        this.setCredentials(authscope, (Credentials)credentials);
    }

    public void addNTLMCredentials(String username, String password, String host, int port, String workstation, String domain) {
        AuthScope authscope = new AuthScope(host, port, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        NTCredentials credentials = new NTCredentials(username, password, workstation, domain);
        this.setCredentials(authscope, (Credentials)credentials);
    }

    public synchronized void setCredentials(AuthScope authscope, Credentials credentials) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        if (credentials instanceof UsernamePasswordCredentials || credentials instanceof NTCredentials) {
            this.credentialsMap_.put(new AuthScopeProxy(authscope), credentials);
            return;
        }
        throw new IllegalArgumentException("Unsupported Credential type: " + credentials.getClass().getName());
    }

    private static Credentials matchCredentials(Map<AuthScopeProxy, Credentials> map, AuthScope authscope) {
        Credentials creds = map.get(new AuthScopeProxy(authscope));
        if (creds == null) {
            int bestMatchFactor = -1;
            AuthScopeProxy bestMatch = null;
            for (AuthScopeProxy proxy : map.keySet()) {
                AuthScope current = proxy.getAuthScope();
                int factor = authscope.match(current);
                if (factor <= bestMatchFactor) continue;
                bestMatchFactor = factor;
                bestMatch = proxy;
            }
            if (bestMatch != null) {
                creds = map.get(bestMatch);
            }
        }
        return creds;
    }

    public synchronized Credentials getCredentials(AuthScope authscope) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        return DefaultCredentialsProvider.matchCredentials(this.credentialsMap_, authscope);
    }

    public synchronized boolean removeCredentials(AuthScope authscope) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        int bestMatchFactor = -1;
        AuthScopeProxy bestMatch = null;
        for (AuthScopeProxy proxy : this.credentialsMap_.keySet()) {
            AuthScope current = proxy.getAuthScope();
            int factor = authscope.match(current);
            if (factor <= bestMatchFactor) continue;
            bestMatchFactor = factor;
            bestMatch = proxy;
        }
        return this.credentialsMap_.remove(bestMatch) != null;
    }

    public String toString() {
        return this.credentialsMap_.toString();
    }

    public synchronized void clear() {
        this.credentialsMap_.clear();
    }

    private static class AuthScopeProxy
    implements Serializable {
        private AuthScope authScope_;

        AuthScopeProxy(AuthScope authScope) {
            this.authScope_ = authScope;
        }

        public AuthScope getAuthScope() {
            return this.authScope_;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.writeObject(this.authScope_.getHost());
            stream.writeInt(this.authScope_.getPort());
            stream.writeObject(this.authScope_.getRealm());
            stream.writeObject(this.authScope_.getScheme());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            String host = (String)stream.readObject();
            int port = stream.readInt();
            String realm = (String)stream.readObject();
            String scheme = (String)stream.readObject();
            this.authScope_ = new AuthScope(host, port, realm, scheme);
        }

        public int hashCode() {
            return this.authScope_.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof AuthScopeProxy && this.authScope_.equals((Object)((AuthScopeProxy)obj).getAuthScope());
        }
    }
}

