/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.tests.i18n.algorithm;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mvcspec.tck.tests.i18n.algorithm.FirstLocaleResolver;
import org.mvcspec.tck.tests.i18n.algorithm.I18nAlgorithmController;
import org.mvcspec.tck.tests.i18n.algorithm.ResolverChainLogger;
import org.mvcspec.tck.tests.i18n.algorithm.SecondLocaleResolver;
import org.mvcspec.tck.tests.i18n.algorithm.ThirdLocaleResolver;
import org.mvcspec.tck.util.Archives;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class I18nAlgorithmTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(I18nAlgorithmController.class).addClass(FirstLocaleResolver.class).addClass(SecondLocaleResolver.class).addClass(ThirdLocaleResolver.class).addClass(ResolverChainLogger.class).addView("i18n/algorithm/view.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="i18n_resolving_algorithm", id="resolver-discovery"), @SpecAssertion(section="i18n_resolving_algorithm", id="resolve-algorithm")})
    public void highestPrioExecutedFirst() throws IOException {
        HtmlPage page = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/i18n/algorithm");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)this.getInvocationLogString(page), (Matcher)CoreMatchers.startsWith((String)"FirstLocaleResolver"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="i18n_resolving_algorithm", id="resolver-discovery"), @SpecAssertion(section="i18n_resolving_algorithm", id="resolve-algorithm")})
    public void continueChainForNullResult() throws IOException {
        HtmlPage page = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/i18n/algorithm");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)this.getInvocationLogString(page), (Matcher)CoreMatchers.containsString((String)",SecondLocaleResolver"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="i18n_resolving_algorithm", id="resolver-discovery"), @SpecAssertion(section="i18n_resolving_algorithm", id="resolve-algorithm")})
    public void chainStopsForNonNullResult() throws IOException {
        HtmlPage page = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/i18n/algorithm");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Language = [de]"));
        Assert.assertThat((Object)this.getInvocationLogString(page), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"ThirdLocaleResolver")));
    }

    private String getInvocationLogString(HtmlPage page) {
        DomElement element = page.getElementById("log");
        return element != null && element.getTextContent() != null ? element.getTextContent().trim() : null;
    }
}

