/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl.loadable;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.impl.loadable.JavaSPIExtensionLoader;
import org.jboss.arquillian.core.impl.loadable.SecurityActions;
import org.jboss.arquillian.core.impl.loadable.ServiceRegistry;
import org.jboss.arquillian.core.spi.ExtensionLoader;
import org.jboss.arquillian.core.spi.LoadableExtension;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.context.Context;
import org.jboss.arquillian.core.spi.event.ManagerProcessing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadableExtensionLoader {
    private static Logger log = Logger.getLogger(LoadableExtensionLoader.class.getName());
    private static Level level = Level.FINER;
    @Inject
    private Instance<Injector> injector;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ServiceLoader> serviceLoaderProducer;
    private JavaSPIExtensionLoader serviceLoader;

    public LoadableExtensionLoader() {
        this(new JavaSPIExtensionLoader());
    }

    LoadableExtensionLoader(JavaSPIExtensionLoader serviceLoader) {
        this.serviceLoader = serviceLoader;
    }

    public void load(final @Observes ManagerProcessing event) {
        ExtensionLoader extensionLoader = this.locateExtensionLoader();
        final ServiceRegistry registry = new ServiceRegistry((Injector)this.injector.get(), extensionLoader.loadVetoed());
        Collection extensions = extensionLoader.load();
        for (LoadableExtension extension : extensions) {
            log.log(level, "extension: {0}", new Object[]{extension.getClass().getSimpleName()});
            extension.register(new LoadableExtension.ExtensionBuilder(){

                public <T> LoadableExtension.ExtensionBuilder service(Class<T> service, Class<? extends T> impl) {
                    log.log(level, "\tservice: {0} - {1}", new Object[]{service, impl});
                    registry.addService(service, impl);
                    return this;
                }

                public <T> LoadableExtension.ExtensionBuilder override(Class<T> service, Class<? extends T> oldServiceImpl, Class<? extends T> newServiceImpl) {
                    log.log(level, "\toverride: {0} overrides {1} for {2}", new Object[]{newServiceImpl, oldServiceImpl, service});
                    registry.overrideService(service, oldServiceImpl, newServiceImpl);
                    return this;
                }

                public LoadableExtension.ExtensionBuilder observer(Class<?> handler) {
                    log.log(level, "\tobserver: {0}", new Object[]{handler});
                    event.observer(handler);
                    return this;
                }

                public LoadableExtension.ExtensionBuilder context(Class<? extends Context> context) {
                    log.log(level, "\tcontext: {0}", new Object[]{context});
                    event.context(context);
                    return this;
                }
            });
        }
        this.serviceLoaderProducer.set((Object)registry.getServiceLoader());
    }

    private ExtensionLoader locateExtensionLoader() {
        Collection<Object> loaders = Collections.emptyList();
        if (SecurityActions.getThreadContextClassLoader() != null) {
            loaders = this.serviceLoader.all(SecurityActions.getThreadContextClassLoader(), ExtensionLoader.class);
        }
        if (loaders.size() == 0) {
            loaders = this.serviceLoader.all(LoadableExtensionLoader.class.getClassLoader(), ExtensionLoader.class);
        }
        if (loaders.size() > 1) {
            throw new RuntimeException("Multiple ExtensionLoader's found on classpath: " + this.toString(loaders));
        }
        if (loaders.size() == 1) {
            return (ExtensionLoader)loaders.iterator().next();
        }
        return this.serviceLoader;
    }

    private String toString(Collection<ExtensionLoader> loaders) {
        StringBuilder sb = new StringBuilder();
        for (ExtensionLoader loader : loaders) {
            sb.append(loader.getClass().getName()).append(", ");
        }
        return sb.toString();
    }
}

