/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.ManagerBuilder;
import org.jboss.arquillian.core.spi.NonManagedObserver;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.test.impl.TestExecutionDeciderComparator;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.TestRunnerAdaptor;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.test.spi.event.suite.Test;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;
import org.jboss.arquillian.test.spi.execution.SkippedTestExecutionException;
import org.jboss.arquillian.test.spi.execution.TestExecutionDecider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTestRunnerAdaptor
implements TestRunnerAdaptor {
    private Manager manager;

    public EventTestRunnerAdaptor(ManagerBuilder builder) {
        Validate.notNull((Object)builder, (String)"ManagerBuilder must be specified");
        this.manager = builder.create();
        this.manager.start();
    }

    public EventTestRunnerAdaptor(Manager manager) {
        Validate.notNull((Object)manager, (String)"Manager must be specified");
        this.manager = manager;
    }

    public void beforeSuite() throws Exception {
        this.manager.fire((Object)new BeforeSuite());
    }

    public void afterSuite() throws Exception {
        this.manager.fire((Object)new AfterSuite());
    }

    public void beforeClass(Class<?> testClass, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull(testClass, (String)"TestClass must be specified");
        this.manager.fire((Object)new BeforeClass(testClass, executor));
    }

    public void afterClass(Class<?> testClass, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull(testClass, (String)"TestClass must be specified");
        this.manager.fire((Object)new AfterClass(testClass, executor));
    }

    public void before(Object testInstance, Method testMethod, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull((Object)testInstance, (String)"TestInstance must be specified");
        Validate.notNull((Object)testMethod, (String)"TestMethod must be specified");
        ExecutionDecision executionDecision = this.resolveExecutionDecision(this.manager, testMethod);
        if (executionDecision.getDecision() == ExecutionDecision.Decision.DONT_EXECUTE) {
            return;
        }
        this.manager.fire((Object)new Before(testInstance, testMethod, executor));
    }

    public void after(Object testInstance, Method testMethod, LifecycleMethodExecutor executor) throws Exception {
        Validate.notNull((Object)testInstance, (String)"TestInstance must be specified");
        Validate.notNull((Object)testMethod, (String)"TestMethod must be specified");
        ExecutionDecision executionDecision = this.resolveExecutionDecision(this.manager, testMethod);
        if (executionDecision.getDecision() == ExecutionDecision.Decision.DONT_EXECUTE) {
            return;
        }
        this.manager.fire((Object)new After(testInstance, testMethod, executor));
    }

    public TestResult test(TestMethodExecutor testMethodExecutor) throws Exception {
        Validate.notNull((Object)testMethodExecutor, (String)"TestMethodExecutor must be specified");
        ExecutionDecision executionDecision = this.resolveExecutionDecision(this.manager, testMethodExecutor.getMethod());
        if (executionDecision.getDecision() == ExecutionDecision.Decision.DONT_EXECUTE) {
            return TestResult.skipped((Throwable)new SkippedTestExecutionException(executionDecision.getReason()));
        }
        final ArrayList results = new ArrayList();
        this.manager.fire((Object)new Test(testMethodExecutor), (NonManagedObserver)new NonManagedObserver<Test>(){
            @Inject
            private Instance<TestResult> testResult;

            public void fired(Test event) {
                results.add(this.testResult.get());
            }
        });
        return TestResult.flatten(results);
    }

    public <T extends TestLifecycleEvent> void fireCustomLifecycle(T event) throws Exception {
        Validate.notNull(event, (String)"Event must be specified");
        ExecutionDecision executionDecision = this.resolveExecutionDecision(this.manager, event.getTestMethod());
        if (executionDecision.getDecision() == ExecutionDecision.Decision.DONT_EXECUTE) {
            return;
        }
        this.manager.fire(event);
    }

    public void shutdown() {
        this.manager.shutdown();
    }

    private ExecutionDecision resolveExecutionDecision(Manager manager, Method testMethod) {
        ExecutionDecision executionDecision;
        block1: {
            TestExecutionDecider decider;
            ExecutionDecision tempExecutionDecision;
            ArrayList deciders;
            Validate.notNull((Object)manager, (String)"Manager must be specified.");
            ServiceLoader serviceLoader = (ServiceLoader)manager.resolve(ServiceLoader.class);
            executionDecision = TestExecutionDecider.EXECUTE.decide(testMethod);
            if (serviceLoader == null || (deciders = new ArrayList(serviceLoader.all(TestExecutionDecider.class))).size() == 0) break block1;
            Collections.sort(deciders, new TestExecutionDeciderComparator());
            Collections.reverse(deciders);
            Iterator i$ = deciders.iterator();
            while (i$.hasNext() && ((tempExecutionDecision = (decider = (TestExecutionDecider)i$.next()).decide(testMethod)) == null || (executionDecision = tempExecutionDecision).getDecision() != ExecutionDecision.Decision.DONT_EXECUTE)) {
            }
        }
        return executionDecision;
    }
}

