/**
 * Jakarta Bean Validation TCK
 *
 * License: Apache License, Version 2.0
 * See the license.txt file in the root directory or <http://www.apache.org/licenses/LICENSE-2.0>.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.nestedconstraintcomposition;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import jakarta.validation.ReportAsSingleViolation;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;

/**
 * @author Hardy Ferentschik
 */
@Pattern(regexp = "...", message = "Pattern must match {regexp}")
@Size(min = 3, max = 3, message = "Size must be {min}")
@Target({ METHOD, FIELD, TYPE })
@Retention(RUNTIME)
@Constraint(validatedBy = { })
@ReportAsSingleViolation
public @interface NestedConstraintSingleViolation {
	public abstract String message() default "NestedConstraintSingleViolation failed.";

	public abstract Class<?>[] groups() default { };

	public abstract Class<? extends Payload>[] payload() default { };
}
