/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.LongArrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractLongArrayAssert<SELF extends AbstractLongArrayAssert<SELF>>
extends AbstractArrayAssert<SELF, long[], Long> {
    @VisibleForTesting
    protected LongArrays arrays = LongArrays.instance();

    public AbstractLongArrayAssert(long[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (long[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (long[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (long[])this.actual);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (long[])this.actual, expected);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (long[])this.actual, other);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF contains(long ... values) {
        this.arrays.assertContains(this.info, (long[])this.actual, values);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF containsOnly(long ... values) {
        this.arrays.assertContainsOnly(this.info, (long[])this.actual, values);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(long ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (long[])this.actual, values);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF containsSequence(long ... sequence) {
        this.arrays.assertContainsSequence(this.info, (long[])this.actual, sequence);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF containsSubsequence(long ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (long[])this.actual, subsequence);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF contains(long value, Index index) {
        this.arrays.assertContains(this.info, (long[])this.actual, value, index);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF doesNotContain(long ... values) {
        this.arrays.assertDoesNotContain(this.info, (long[])this.actual, values);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF doesNotContain(long value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (long[])this.actual, value, index);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (long[])this.actual);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF startsWith(long ... sequence) {
        this.arrays.assertStartsWith(this.info, (long[])this.actual, sequence);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF endsWith(long ... sequence) {
        this.arrays.assertEndsWith(this.info, (long[])this.actual, sequence);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (long[])this.actual);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super Long> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (long[])this.actual, comparator);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super Long> customComparator) {
        this.arrays = new LongArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.arrays = LongArrays.instance();
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF containsExactly(long ... values) {
        this.arrays.assertContainsExactly(this.info, (long[])this.actual, values);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(long ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (long[])this.actual, values);
        return (SELF)((AbstractLongArrayAssert)this.myself);
    }
}

