/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.application;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.hibernate.beanvalidation.tck.tests.constraints.application.Citizen;
import org.hibernate.beanvalidation.tck.tests.constraints.application.Person;

@Documented
@Constraint(validatedBy={SecurityCheckValidator.class})
@Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface SecurityCheck {
    public String message() default "Security check failed.";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class SecurityCheckValidator
    implements ConstraintValidator<SecurityCheck, Object> {
        public boolean isValid(Object object, ConstraintValidatorContext constraintValidatorContext) {
            if (object == null) {
                return true;
            }
            if (!(object instanceof Person) && !(object instanceof Citizen)) {
                return false;
            }
            Citizen citizen = (Citizen)object;
            return !"000000-0000".equals(citizen.getPersonalNumber());
        }
    }
}

