/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.draw2d.ui.text.TextUtilitiesEx;
import org.eclipse.swt.graphics.Image;

public class LabelEx
extends Label {
    private static int FLAG_SELECTED = Figure.MAX_FLAG << 1;
    private static int FLAG_HASFOCUS = Figure.MAX_FLAG << 2;
    private static int FLAG_UNDERLINED = Figure.MAX_FLAG << 3;
    private static int FLAG_STRIKEDTHROUGH;
    protected static final int MAX_FLAG;
    private IMapMode mapmode;
    private TextUtilities textUtilities;

    static {
        MAX_FLAG = FLAG_STRIKEDTHROUGH = Figure.MAX_FLAG << 4;
    }

    public LabelEx() {
    }

    public LabelEx(String s) {
        super(s);
    }

    public LabelEx(Image i) {
        super(i);
    }

    public LabelEx(String s, Image i) {
        super(s, i);
    }

    public void setTextStrikeThrough(boolean strikeThrough) {
        if (this.isTextStrikedThrough() == strikeThrough) {
            return;
        }
        this.setFlag(FLAG_STRIKEDTHROUGH, strikeThrough);
        this.repaint();
    }

    public boolean isTextStrikedThrough() {
        return (this.flags & FLAG_STRIKEDTHROUGH) != 0;
    }

    public void setTextUnderline(boolean underline) {
        if (this.isTextUnderlined() == underline) {
            return;
        }
        this.setFlag(FLAG_UNDERLINED, underline);
        this.repaint();
    }

    public boolean isTextUnderlined() {
        return (this.flags & FLAG_UNDERLINED) != 0;
    }

    public void setSelected(boolean b) {
        if (this.isSelected() == b) {
            return;
        }
        this.setFlag(FLAG_SELECTED, b);
        this.repaint();
    }

    public boolean isSelected() {
        return (this.flags & FLAG_SELECTED) != 0;
    }

    public void setFocus(boolean b) {
        if (this.hasFocus() == b) {
            return;
        }
        this.setFlag(FLAG_HASFOCUS, b);
        this.repaint();
    }

    public boolean hasFocus() {
        return (this.flags & FLAG_HASFOCUS) != 0;
    }

    protected void paintFigure(Graphics graphics) {
        int y;
        this.paintSelectionRectangle(graphics);
        this.paintFocusRectangle(graphics);
        super.paintFigure(graphics);
        Rectangle textBounds = this.getTextBounds();
        if (this.isTextUnderlined()) {
            y = textBounds.getBottom().y + this.getMapMode().DPtoLP(1);
            graphics.drawLine(textBounds.x, y, textBounds.getRight().x, y);
        }
        if (this.isTextStrikedThrough()) {
            y = textBounds.getCenter().y;
            graphics.drawLine(textBounds.x, y, textBounds.getRight().x, y);
        }
    }

    private void paintSelectionRectangle(Graphics g) {
        if (this.isSelected()) {
            g.pushState();
            g.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            g.fillRectangle(this.getSelectionRectangle());
            g.popState();
            g.setForegroundColor(ColorConstants.white);
        }
    }

    private void paintFocusRectangle(Graphics g) {
        if (this.hasFocus()) {
            g.pushState();
            g.setXORMode(true);
            g.setForegroundColor(ColorConstants.menuBackgroundSelected);
            g.setBackgroundColor(ColorConstants.white);
            g.drawFocus(this.getSelectionRectangle().resize(-1, -1));
            g.popState();
        }
    }

    private Rectangle getSelectionRectangle() {
        Rectangle figBounds = this.getTextBounds();
        int expansion = this.getMapMode().DPtoLP(2);
        figBounds.resize(expansion, expansion);
        this.translateToParent((Translatable)figBounds);
        figBounds.intersect(this.getBounds());
        return figBounds;
    }

    protected Dimension getIconSize() {
        Dimension iconSize = super.getIconSize();
        return new Dimension(this.getMapMode().DPtoLP(iconSize.width), this.getMapMode().DPtoLP(iconSize.height));
    }

    public int getIconTextGap() {
        int gap = super.getIconTextGap();
        return this.getMapMode().DPtoLP(gap);
    }

    private IMapMode getMapMode() {
        if (this.mapmode == null) {
            this.mapmode = MapModeUtil.getMapMode((IFigure)this);
        }
        return this.mapmode;
    }

    public TextUtilities getTextUtilities() {
        if (this.textUtilities == null) {
            this.textUtilities = new TextUtilitiesEx(this.getMapMode());
        }
        return this.textUtilities;
    }
}

