/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.theme;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ui.services.theme.MultiURLStylesheet;
import org.eclipse.fx.ui.services.theme.Stylesheet;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

public abstract class AbstractTheme
implements Theme {
    private final @NonNull String id;
    private final @NonNull String name;
    private final @NonNull ObservableList<@NonNull URL> stylesheetUrlList = FXCollections.observableArrayList();
    private final @NonNull ObservableList<@NonNull URL> unmodifiableStylesheetUrlList = FXCollections.unmodifiableObservableList(this.stylesheetUrlList);
    private static @Nullable Logger LOGGER;
    private Map<@NonNull MultiURLStylesheet, @NonNull ObservableList<@NonNull URL>> urlMap = new HashMap<MultiURLStylesheet, ObservableList<URL>>();

    public AbstractTheme(@NonNull String id, @NonNull String name, @NonNull URL baseStylesheetUrl) {
        this.id = id;
        this.name = name;
        this.stylesheetUrlList.add((Object)baseStylesheetUrl);
    }

    public @NonNull String getId() {
        return this.id;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull ObservableList<@NonNull URL> getStylesheetURL() {
        return this.unmodifiableStylesheetUrlList;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void registerStylesheet(Stylesheet stylesheet) {
        if (stylesheet.appliesToTheme((Theme)this)) {
            URL url = stylesheet.getURL((Theme)this);
            if (url != null) {
                this.stylesheetUrlList.add((Object)url);
            } else {
                AbstractTheme.getLogger().error("Stylesheet '" + stylesheet + "' tried to restrict null as a stylesheet URI");
            }
        }
    }

    private static Logger getLogger() {
        if (LOGGER == null) {
            LOGGER = LoggerCreator.createLogger(AbstractTheme.class);
        }
        return LOGGER;
    }

    public void unregisterStylesheet(Stylesheet stylesheet) {
        if (stylesheet.appliesToTheme((Theme)this)) {
            this.stylesheetUrlList.remove((Object)stylesheet.getURL((Theme)this));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void registerMultiURLStylesheet(MultiURLStylesheet stylesheet) {
        if (stylesheet.appliesToTheme((Theme)this)) {
            @NonNull ObservableList url = stylesheet.getURL((Theme)this);
            url.addListener(this::handleChange);
            this.urlMap.put(stylesheet, (ObservableList<URL>)url);
            this.stylesheetUrlList.addAll((Collection)url);
        }
    }

    public void unregisterMultiURLStylesheet(MultiURLStylesheet stylesheet) {
        if (stylesheet.appliesToTheme((Theme)this) && this.urlMap.containsKey(stylesheet)) {
            ObservableList<@NonNull URL> remove = this.urlMap.remove(stylesheet);
            remove.removeListener(this::handleChange);
            this.stylesheetUrlList.remove(remove);
        }
    }

    private void handleChange(// Could not load outer class - annotation placement on inner may be incorrect
    ListChangeListener.Change<@NonNull ? extends URL> change) {
        while (change.next()) {
            this.stylesheetUrlList.removeAll((Collection)change.getRemoved());
            this.stylesheetUrlList.addAll((Collection)change.getAddedSubList());
        }
    }
}

