/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.corejs.javascript.engine;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.engine.RhinoScriptEngine;

public class RhinoScriptEngineFactory
implements ScriptEngineFactory {
    public static final String NAME = "rhino";
    private static final String LANGUAGE = "javascript";
    private static final List<String> NAMES = Arrays.asList("rhino", "Rhino", "javascript", "JavaScript");
    private static final List<String> EXTENSIONS = Collections.singletonList("js");
    private static final List<String> MIME_TYPES = Arrays.asList("application/javascript", "application/ecmascript", "text/javascript", "text/ecmascript");
    private static final String LANGUAGE_VERSION = String.valueOf(200);

    @Override
    public String getEngineName() {
        return NAME;
    }

    @Override
    public String getEngineVersion() {
        try (Context cx = Context.enter();){
            String v = cx.getImplementationVersion();
            String string = v == null ? "unknown" : v;
            return string;
        }
    }

    @Override
    public List<String> getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public List<String> getMimeTypes() {
        return MIME_TYPES;
    }

    @Override
    public List<String> getNames() {
        return NAMES;
    }

    @Override
    public String getLanguageName() {
        return LANGUAGE;
    }

    @Override
    public String getLanguageVersion() {
        return LANGUAGE_VERSION;
    }

    @Override
    public Object getParameter(String key) {
        switch (key) {
            case "javax.script.engine": {
                return this.getEngineName();
            }
            case "javax.script.engine_version": {
                return this.getEngineVersion();
            }
            case "javax.script.language": {
                return this.getLanguageName();
            }
            case "javax.script.language_version": {
                return this.getLanguageVersion();
            }
            case "javax.script.name": {
                return NAME;
            }
            case "THREADING": {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj).append('.').append(m).append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(args[i]);
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "print('" + toDisplay + "');";
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder sb = new StringBuilder();
        for (String stmt : statements) {
            sb.append(stmt).append(";\n");
        }
        return sb.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new RhinoScriptEngine(this);
    }
}

