/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.mvc.models;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import ee.jakarta.tck.mvc.tests.mvc.models.BuiltinEngineModelController;
import ee.jakarta.tck.mvc.tests.mvc.models.CdiModelBean;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class BuiltinEngineModelTest {
    @ArquillianResource
    private URL baseUrl;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(BuiltinEngineModelController.class).addClass(CdiModelBean.class).addView("<html><p>CDI-Model = [${cdiModelBean.value}]</p>\n<p>MVC-Model = [${modelsValue}]</p>\n</html>", "view.jsp").build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="models", id="builtin-both-models"), @SpecAssertion(section="models", id="cdi-model-inject"), @SpecAssertion(section="models", id="cdi-model-el"), @SpecAssertion(section="views", id="jsp-el")})
    public void cdiModelJsp() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/builtin/jsp").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"CDI-Model = [jsp-foo]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="models", id="builtin-both-models"), @SpecAssertion(section="models", id="models-inject"), @SpecAssertion(section="views", id="jsp-el")})
    public void mvcModelsJsp() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/builtin/jsp").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"MVC-Model = [jsp-bar]"));
    }
}

