/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.util.Map;
import java.util.Properties;
import org.jboss.arquillian.config.impl.extension.ClasspathPropertyResolver;
import org.jboss.arquillian.config.impl.extension.PropertiesPropertyResolver;
import org.jboss.arquillian.config.impl.extension.PropertyResolver;

public final class StringPropertyReplacer {
    private static final String ENV_VAR_BASE_PROPERTY_KEY = "env.";
    private static final int NORMAL = 0;
    private static final int SEEN_DOLLAR = 1;
    private static final int IN_BRACKET = 2;

    public static String replaceClasspath(String string) {
        return StringPropertyReplacer.replaceProperties(string, new ClasspathPropertyResolver());
    }

    public static String replaceProperties(String string) {
        Properties props = System.getProperties();
        for (Map.Entry<String, String> var : System.getenv().entrySet()) {
            String propKey = ENV_VAR_BASE_PROPERTY_KEY + var.getKey();
            if (props.containsKey(propKey)) continue;
            props.setProperty(propKey, var.getValue());
        }
        return StringPropertyReplacer.replaceProperties(string, new PropertiesPropertyResolver(props));
    }

    private static String replaceProperties(String string, PropertyResolver propertyResolver) {
        char[] chars = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        boolean properties = false;
        int state = 0;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '$' && state != 2) {
                state = 1;
                continue;
            }
            if (c == '{' && state == 1) {
                buffer.append(string.substring(start, i - 1));
                state = 2;
                start = i - 1;
                continue;
            }
            if (state == 1) {
                state = 0;
                continue;
            }
            if (c != '}' || state != 2) continue;
            if (start + 2 == i) {
                buffer.append("${}");
            } else {
                String key = string.substring(start + 2, i);
                String value = propertyResolver.getValue(key);
                if (value != null) {
                    properties = true;
                    buffer.append(value);
                } else {
                    buffer.append("${");
                    buffer.append(key);
                    buffer.append('}');
                }
            }
            start = i + 1;
            state = 0;
        }
        if (!properties) {
            return string;
        }
        if (start != chars.length) {
            buffer.append(string.substring(start, chars.length));
        }
        return buffer.toString();
    }
}

