/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.binding.numeric;

import com.gargoylesoftware.htmlunit.Page;
import ee.jakarta.tck.mvc.tests.binding.numeric.AbstractNumericTest;
import ee.jakarta.tck.mvc.tests.binding.numeric.BindingIntegerController;
import ee.jakarta.tck.mvc.tests.binding.numeric.BindingIntegerForm;
import ee.jakarta.tck.mvc.tests.binding.numeric.ForceGermanLocaleResolver;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class BindingIntegerTest
extends AbstractNumericTest {
    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(ForceGermanLocaleResolver.class).addClass(BindingIntegerController.class).addClass(BindingIntegerForm.class).addView("binding/numeric/form.jsp").addView("binding/numeric/result.jsp").build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="numeric_types", id="convert-numeric")})
    public void submitValidInteger() throws IOException {
        Page resultPage = this.submitForm("binding/numeric", "1.234");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Primitive: [1234]"), (Matcher)CoreMatchers.containsString((String)"Object: [1234]")));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="numeric_types", id="convert-empty-numeric")})
    public void submitEmptyInteger() throws IOException {
        Page resultPage = this.submitForm("binding/numeric", "");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Primitive: [0]"), (Matcher)CoreMatchers.containsString((String)"Object: [null]")));
    }
}

