/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.CSSStyleDeclarationImpl;
import com.gargoylesoftware.css.dom.CSSValueImpl;
import com.gargoylesoftware.css.parser.CSSErrorHandler;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.CSSParser;
import com.gargoylesoftware.css.parser.javacc.CSS3Parser;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.css.StyleElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSPrimitiveValue;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSValue;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedFont;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHtmlElement;
import java.awt.Color;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class CSSStyleDeclaration
extends SimpleScriptable {
    private static final Pattern TO_INT_PATTERN = Pattern.compile("(\\d+).*");
    private static final Pattern URL_PATTERN = Pattern.compile("url\\(\\s*[\"']?(.*?)[\"']?\\s*\\)");
    private static final Pattern POSITION_PATTERN = Pattern.compile("(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex))\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|top|bottom|center)");
    private static final Pattern POSITION_PATTERN2 = Pattern.compile("(left|right|center)\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|top|bottom|center)");
    private static final Pattern POSITION_PATTERN3 = Pattern.compile("(top|bottom|center)\\s*(\\d+\\s*(%|px|cm|mm|in|pt|pc|em|ex)|left|right|center)");
    private static final Set<String> LENGTH_PROPERTIES_FFFF = new HashSet<String>(Arrays.asList(StyleAttributes.Definition.BORDER_TOP_WIDTH.getAttributeName(), StyleAttributes.Definition.BORDER_LEFT_WIDTH.getAttributeName(), StyleAttributes.Definition.BORDER_BOTTOM_WIDTH.getAttributeName(), StyleAttributes.Definition.BORDER_RIGHT_WIDTH.getAttributeName(), StyleAttributes.Definition.LETTER_SPACING.getAttributeName()));
    private static final Set<String> LENGTH_PROPERTIES_TTFF = new HashSet<String>(Arrays.asList(StyleAttributes.Definition.HEIGHT.getAttributeName(), StyleAttributes.Definition.WIDTH.getAttributeName(), StyleAttributes.Definition.TOP.getAttributeName(), StyleAttributes.Definition.LEFT.getAttributeName(), StyleAttributes.Definition.BOTTOM.getAttributeName(), StyleAttributes.Definition.RIGHT.getAttributeName(), StyleAttributes.Definition.MARGIN_TOP.getAttributeName(), StyleAttributes.Definition.MARGIN_LEFT.getAttributeName(), StyleAttributes.Definition.MARGIN_BOTTOM.getAttributeName(), StyleAttributes.Definition.MARGIN_RIGHT.getAttributeName(), StyleAttributes.Definition.MIN_HEIGHT.getAttributeName(), StyleAttributes.Definition.MIN_WIDTH.getAttributeName()));
    private static final Set<String> LENGTH_PROPERTIES_FTFF = new HashSet<String>(Arrays.asList(StyleAttributes.Definition.FONT_SIZE.getAttributeName(), StyleAttributes.Definition.TEXT_INDENT.getAttributeName(), StyleAttributes.Definition.PADDING_TOP.getAttributeName(), StyleAttributes.Definition.PADDING_LEFT.getAttributeName(), StyleAttributes.Definition.PADDING_BOTTOM.getAttributeName(), StyleAttributes.Definition.PADDING_RIGHT.getAttributeName(), StyleAttributes.Definition.MAX_HEIGHT.getAttributeName(), StyleAttributes.Definition.MAX_WIDTH.getAttributeName()));
    static final String NONE = "none";
    static final String AUTO = "auto";
    static final String STATIC = "static";
    static final String INHERIT = "inherit";
    private static final String INITIAL = "initial";
    static final String RELATIVE = "relative";
    static final String FIXED = "fixed";
    static final String ABSOLUTE = "absolute";
    private static final String REPEAT = "repeat";
    static final String BLOCK = "block";
    static final String INLINE = "inline";
    private static final Log LOG = LogFactory.getLog(CSSStyleDeclaration.class);
    private static final Map<String, String> CSSColors_ = new HashMap<String, String>();
    private static final Map<String, String> CamelizeCache_ = Collections.synchronizedMap(new HashMap());
    private static final MessageFormat URL_FORMAT = new MessageFormat("url({0})");
    private Element jsElement_;
    private CSSStyleDeclarationImpl styleDeclaration_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public CSSStyleDeclaration() {
    }

    public CSSStyleDeclaration(Element element) {
        this.setParentScope(element.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.initialize(element);
    }

    CSSStyleDeclaration(Scriptable parentScope, CSSStyleDeclarationImpl styleDeclaration) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
        this.styleDeclaration_ = styleDeclaration;
    }

    private void initialize(Element element) {
        block5: {
            WebAssert.notNull("htmlElement", element);
            this.jsElement_ = element;
            this.setDomNode(element.getDomNodeOrNull(), false);
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_SUPPORTS_BEHAVIOR_PROPERTY) && element instanceof HTMLElement) {
                HTMLElement htmlElement = (HTMLElement)element;
                String behavior = this.getStyleAttribute(StyleAttributes.Definition.BEHAVIOR);
                if (StringUtils.isNotBlank((CharSequence)behavior)) {
                    try {
                        Object[] url = URL_FORMAT.parse(behavior);
                        if (url.length > 0) {
                            htmlElement.addBehavior((String)url[0]);
                        }
                    }
                    catch (ParseException e) {
                        if (!LOG.isWarnEnabled()) break block5;
                        LOG.warn((Object)("Invalid behavior: '" + behavior + "'."));
                    }
                }
            }
        }
    }

    @Override
    protected Object getWithPreemption(String name) {
        StyleElement element;
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_UNSUPPORTED_PROPERTY_GETTER) && null != this.jsElement_ && (element = this.getStyleElement(name)) != null && element.getValue() != null) {
            return element.getValue();
        }
        return NOT_FOUND;
    }

    protected Element getElement() {
        return this.jsElement_;
    }

    protected String getStylePriority(String name) {
        if (this.styleDeclaration_ != null) {
            return this.styleDeclaration_.getPropertyPriority(name);
        }
        StyleElement element = this.getStyleElement(name);
        if (element != null && element.getValue() != null) {
            return element.getPriority();
        }
        return "";
    }

    protected StyleElement getStyleElement(String name) {
        if (this.jsElement_ == null) {
            return null;
        }
        return this.jsElement_.getDomNodeOrDie().getStyleElement(name);
    }

    private StyleElement getStyleElementCaseInSensitive(String name) {
        if (this.jsElement_ == null) {
            return null;
        }
        return this.jsElement_.getDomNodeOrDie().getStyleElementCaseInSensitive(name);
    }

    private String getStyleAttribute(StyleAttributes.Definition name1, StyleAttributes.Definition name2) {
        String value;
        if (this.styleDeclaration_ == null) {
            StyleElement element1 = this.getStyleElement(name1.getAttributeName());
            StyleElement element2 = this.getStyleElement(name2.getAttributeName());
            if (element2 == null) {
                if (element1 == null) {
                    return "";
                }
                return element1.getValue();
            }
            if (element1 == null) {
                value = element2.getValue();
            } else {
                if (element1.compareTo(element2) > 0) {
                    return element1.getValue();
                }
                value = element2.getValue();
            }
        } else {
            String value1 = this.styleDeclaration_.getPropertyValue(name1.getAttributeName());
            String value2 = this.styleDeclaration_.getPropertyValue(name2.getAttributeName());
            if ("".equals(value1) && "".equals(value2)) {
                return "";
            }
            if (!"".equals(value1) && "".equals(value2)) {
                return value1;
            }
            value = value2;
        }
        String[] values = StringUtils.split((String)value);
        if (name1.name().contains("TOP")) {
            return values[0];
        }
        if (name1.name().contains("RIGHT")) {
            if (values.length > 1) {
                return values[1];
            }
            return values[0];
        }
        if (name1.name().contains("BOTTOM")) {
            if (values.length > 2) {
                return values[2];
            }
            return values[0];
        }
        if (name1.name().contains("LEFT")) {
            if (values.length > 3) {
                return values[3];
            }
            if (values.length > 1) {
                return values[1];
            }
            return values[0];
        }
        throw new IllegalStateException("Unsupported definitino: " + (Object)((Object)name1));
    }

    protected void setStyleAttribute(String name, String newValue) {
        this.setStyleAttribute(name, newValue, "");
    }

    protected void setStyleAttribute(String name, String newValue, String important) {
        if (null == newValue || "null".equals(newValue)) {
            newValue = "";
        }
        if (this.styleDeclaration_ != null) {
            this.styleDeclaration_.setProperty(name, newValue, important);
            return;
        }
        this.jsElement_.getDomNodeOrDie().replaceStyleAttribute(name, newValue, important);
    }

    private String removeStyleAttribute(String name) {
        if (null != this.styleDeclaration_) {
            return this.styleDeclaration_.removeProperty(name);
        }
        return this.jsElement_.getDomNodeOrDie().removeStyleAttribute(name);
    }

    private Map<String, StyleElement> getStyleMap() {
        if (this.jsElement_ == null) {
            return Collections.emptyMap();
        }
        return this.jsElement_.getDomNodeOrDie().getStyleMap();
    }

    protected static final String camelize(String string) {
        if (string == null) {
            return null;
        }
        String result = CamelizeCache_.get(string);
        if (null != result) {
            return result;
        }
        int pos = string.indexOf(45);
        if (pos == -1 || pos == string.length() - 1) {
            CamelizeCache_.put(string, string);
            return string;
        }
        StringBuilder builder = new StringBuilder(string);
        builder.deleteCharAt(pos);
        builder.setCharAt(pos, Character.toUpperCase(builder.charAt(pos)));
        for (int i = pos + 1; i < builder.length() - 1; ++i) {
            if (builder.charAt(i) != '-') continue;
            builder.deleteCharAt(i);
            builder.setCharAt(i, Character.toUpperCase(builder.charAt(i)));
        }
        result = builder.toString();
        CamelizeCache_.put(string, result);
        return result;
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getAccelerator() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.getStyleAttribute(StyleAttributes.Definition.ACCELERATOR), (CharSequence)"false");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setAccelerator(String accelerator) {
        this.setStyleAttribute(StyleAttributes.Definition.ACCELERATOR.getAttributeName(), accelerator);
    }

    @JsxGetter
    public String getBackgroundAttachment() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND_ATTACHMENT, false);
        if (StringUtils.isBlank((CharSequence)value)) {
            String bg = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND);
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                value = CSSStyleDeclaration.findAttachment(bg);
                if (value == null) {
                    if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL) && this.getClass() == CSSStyleDeclaration.class) {
                        return INITIAL;
                    }
                    return "scroll";
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundAttachment(String backgroundAttachment) {
        this.setStyleAttribute(StyleAttributes.Definition.BACKGROUND_ATTACHMENT.getAttributeName(), backgroundAttachment);
    }

    @JsxGetter
    public String getBackgroundColor() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND_COLOR, false);
        if (StringUtils.isBlank((CharSequence)value)) {
            String bg = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND, false);
            if (StringUtils.isBlank((CharSequence)bg)) {
                return "";
            }
            value = CSSStyleDeclaration.findColor(bg);
            if (value == null) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL)) {
                    if (this.getClass() == CSSStyleDeclaration.class) {
                        return INITIAL;
                    }
                    return "rgba(0, 0, 0, 0)";
                }
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_RGBA)) {
                    return "rgba(0, 0, 0, 0)";
                }
                return "transparent";
            }
            return value;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundColor(String backgroundColor) {
        this.setStyleAttribute(StyleAttributes.Definition.BACKGROUND_COLOR.getAttributeName(), backgroundColor);
    }

    @JsxGetter
    public String getBackgroundImage() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND_IMAGE, false);
        if (StringUtils.isBlank((CharSequence)value)) {
            String bg = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND, false);
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                value = CSSStyleDeclaration.findImageUrl(bg);
                boolean isComputed = this.getClass() != CSSStyleDeclaration.class;
                boolean backgroundInitial = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL);
                if (value == null) {
                    return backgroundInitial && !isComputed ? INITIAL : NONE;
                }
                if (isComputed) {
                    try {
                        value = value.substring(5, value.length() - 2);
                        return "url(\"" + ((HtmlElement)this.jsElement_.getDomNodeOrDie()).getHtmlPageOrNull().getFullyQualifiedUrl(value) + "\")";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundImage(String backgroundImage) {
        this.setStyleAttribute(StyleAttributes.Definition.BACKGROUND_IMAGE.getAttributeName(), backgroundImage);
    }

    @JsxGetter
    public String getBackgroundPosition() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND_POSITION, false);
        if (value == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            String bg = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND, false);
            if (bg == null) {
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                String[] values;
                boolean isComputed;
                value = CSSStyleDeclaration.findPosition(bg);
                boolean isInitial = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL);
                boolean bl = isComputed = this.getClass() != CSSStyleDeclaration.class;
                if (value == null) {
                    if (isInitial) {
                        return isComputed ? "" : INITIAL;
                    }
                    return "0% 0%";
                }
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_ZINDEX_TYPE_INTEGER)) {
                    values = value.split(" ");
                    if ("center".equals(values[0])) {
                        values[0] = "";
                    }
                    if ("center".equals(values[1])) {
                        values[1] = "";
                    }
                    if (!isComputed || value.contains("top")) {
                        return (values[0] + ' ' + values[1]).trim();
                    }
                }
                if (isComputed) {
                    values = value.split(" ");
                    switch (values[0]) {
                        case "left": {
                            values[0] = "0%";
                            break;
                        }
                        case "center": {
                            values[0] = "50%";
                            break;
                        }
                        case "right": {
                            values[0] = "100%";
                            break;
                        }
                    }
                    switch (values[1]) {
                        case "top": {
                            values[1] = "0%";
                            break;
                        }
                        case "center": {
                            values[1] = "50%";
                            break;
                        }
                        case "bottom": {
                            values[1] = "100%";
                            break;
                        }
                    }
                    value = values[0] + ' ' + values[1];
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundPosition(String backgroundPosition) {
        this.setStyleAttribute(StyleAttributes.Definition.BACKGROUND_POSITION.getAttributeName(), backgroundPosition);
    }

    @JsxGetter
    public String getBackgroundRepeat() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND_REPEAT, false);
        if (StringUtils.isBlank((CharSequence)value)) {
            String bg = this.getStyleAttribute(StyleAttributes.Definition.BACKGROUND, false);
            if (StringUtils.isNotBlank((CharSequence)bg)) {
                value = CSSStyleDeclaration.findRepeat(bg);
                if (value == null) {
                    if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL) && this.getClass() == CSSStyleDeclaration.class) {
                        return INITIAL;
                    }
                    return REPEAT;
                }
                return value;
            }
            return "";
        }
        return value;
    }

    @JsxSetter
    public void setBackgroundRepeat(String backgroundRepeat) {
        this.setStyleAttribute(StyleAttributes.Definition.BACKGROUND_REPEAT.getAttributeName(), backgroundRepeat);
    }

    @JsxGetter
    public String getBorderBottomColor() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM_COLOR, false);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM, false));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderBottomColor(String borderBottomColor) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM_COLOR.getAttributeName(), borderBottomColor);
    }

    @JsxGetter
    public String getBorderBottomStyle() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM_STYLE, false);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM, false));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderBottomStyle(String borderBottomStyle) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_BOTTOM_STYLE.getAttributeName(), borderBottomStyle);
    }

    @JsxGetter
    public String getBorderBottomWidth() {
        return this.getBorderWidth(StyleAttributes.Definition.BORDER_BOTTOM_WIDTH, StyleAttributes.Definition.BORDER_BOTTOM);
    }

    @JsxSetter
    public void setBorderBottomWidth(Object borderBottomWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.BORDER_BOTTOM_WIDTH.getAttributeName(), borderBottomWidth, "", false, false, false, false);
    }

    @JsxGetter
    public String getBorderLeftColor() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_LEFT_COLOR, false);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER_LEFT, false));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderLeftColor(String borderLeftColor) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_LEFT_COLOR.getAttributeName(), borderLeftColor);
    }

    @JsxGetter
    public String getBorderLeftStyle() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_LEFT_STYLE, false);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER_LEFT, false));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderLeftStyle(String borderLeftStyle) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_LEFT_STYLE.getAttributeName(), borderLeftStyle);
    }

    @JsxGetter
    public String getBorderLeftWidth() {
        return this.getBorderWidth(StyleAttributes.Definition.BORDER_LEFT_WIDTH, StyleAttributes.Definition.BORDER_LEFT);
    }

    private String getBorderWidth(StyleAttributes.Definition borderSideWidth, StyleAttributes.Definition borderSide) {
        String value = this.getStyleAttribute(borderSideWidth, false);
        if (value.isEmpty()) {
            String borderWidth;
            value = CSSStyleDeclaration.findBorderWidth(this.getStyleAttribute(borderSide, false));
            if (value == null && !StringUtils.isEmpty((CharSequence)(borderWidth = this.getStyleAttribute(StyleAttributes.Definition.BORDER_WIDTH, false)))) {
                String[] values = StringUtils.split((String)borderWidth);
                int index = values.length;
                if (borderSideWidth.name().contains("TOP")) {
                    index = 0;
                } else if (borderSideWidth.name().contains("RIGHT")) {
                    index = 1;
                } else if (borderSideWidth.name().contains("BOTTOM")) {
                    index = 2;
                } else if (borderSideWidth.name().contains("LEFT")) {
                    index = 3;
                }
                if (index < values.length) {
                    value = values[index];
                }
            }
            if (value == null) {
                value = CSSStyleDeclaration.findBorderWidth(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderLeftWidth(Object borderLeftWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.BORDER_LEFT_WIDTH.getAttributeName(), borderLeftWidth, "", false, false, false, false);
    }

    @JsxGetter
    public String getBorderRightColor() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT_COLOR, false);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT, false));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderRightColor(String borderRightColor) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT_COLOR.getAttributeName(), borderRightColor);
    }

    @JsxGetter
    public String getBorderRightStyle() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT_STYLE, false);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT, false));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderRightStyle(String borderRightStyle) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_RIGHT_STYLE.getAttributeName(), borderRightStyle);
    }

    @JsxGetter
    public String getBorderRightWidth() {
        return this.getBorderWidth(StyleAttributes.Definition.BORDER_RIGHT_WIDTH, StyleAttributes.Definition.BORDER_RIGHT);
    }

    @JsxSetter
    public void setBorderRightWidth(Object borderRightWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.BORDER_RIGHT_WIDTH.getAttributeName(), borderRightWidth, "", false, false, false, false);
    }

    @JsxSetter
    public void setBorderTop(String borderTop) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_TOP.getAttributeName(), borderTop);
    }

    @JsxGetter
    public String getBorderTopColor() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_TOP_COLOR, false);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER_TOP, false));
            if (value == null) {
                value = CSSStyleDeclaration.findColor(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderTopColor(String borderTopColor) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_TOP_COLOR.getAttributeName(), borderTopColor);
    }

    @JsxGetter
    public String getBorderTopStyle() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.BORDER_TOP_STYLE, false);
        if (value.isEmpty()) {
            value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER_TOP, false));
            if (value == null) {
                value = CSSStyleDeclaration.findBorderStyle(this.getStyleAttribute(StyleAttributes.Definition.BORDER, false));
            }
            if (value == null) {
                value = "";
            }
        }
        return value;
    }

    @JsxSetter
    public void setBorderTopStyle(String borderTopStyle) {
        this.setStyleAttribute(StyleAttributes.Definition.BORDER_TOP_STYLE.getAttributeName(), borderTopStyle);
    }

    @JsxGetter
    public String getBorderTopWidth() {
        return this.getBorderWidth(StyleAttributes.Definition.BORDER_TOP_WIDTH, StyleAttributes.Definition.BORDER_TOP);
    }

    @JsxSetter
    public void setBorderTopWidth(Object borderTopWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.BORDER_TOP_WIDTH.getAttributeName(), borderTopWidth, "", false, false, false, false);
    }

    @JsxGetter
    public String getBottom() {
        return this.getStyleAttribute(StyleAttributes.Definition.BOTTOM);
    }

    @JsxSetter
    public void setBottom(Object bottom) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.BOTTOM.getAttributeName(), bottom, "", true, true, false, false);
    }

    @JsxGetter
    public String getColor() {
        return this.getStyleAttribute(StyleAttributes.Definition.COLOR);
    }

    @JsxSetter
    public void setColor(String color) {
        this.setStyleAttribute(StyleAttributes.Definition.COLOR.getAttributeName(), color);
    }

    @JsxGetter
    public String getCssFloat() {
        return this.getStyleAttribute(StyleAttributes.Definition.FLOAT);
    }

    @JsxSetter
    public void setCssFloat(String value) {
        this.setStyleAttribute(StyleAttributes.Definition.FLOAT.getAttributeName(), value);
    }

    @JsxGetter
    public String getCssText() {
        if (this.styleDeclaration_ != null) {
            String text = this.styleDeclaration_.getCssText();
            if (this.styleDeclaration_.getLength() > 0) {
                return text + ";";
            }
            return text;
        }
        return this.jsElement_.getDomNodeOrDie().getAttributeDirect("style");
    }

    @JsxSetter
    public void setCssText(String value) {
        if (this.styleDeclaration_ != null) {
            this.styleDeclaration_.setCssText(value);
            return;
        }
        this.jsElement_.getDomNodeOrDie().setAttribute("style", value);
    }

    @JsxGetter
    public String getDisplay() {
        return this.getStyleAttribute(StyleAttributes.Definition.DISPLAY);
    }

    @JsxSetter
    public void setDisplay(String display) {
        this.setStyleAttribute(StyleAttributes.Definition.DISPLAY.getAttributeName(), display);
    }

    @JsxGetter
    public String getFontSize() {
        return this.getStyleAttribute(StyleAttributes.Definition.FONT_SIZE);
    }

    @JsxSetter
    public void setFontSize(Object fontSize) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.FONT_SIZE.getAttributeName(), fontSize, "", false, true, false, false);
        this.updateFont(this.getFont(), false);
    }

    @JsxGetter
    public String getLineHeight() {
        return this.getStyleAttribute(StyleAttributes.Definition.LINE_HEIGHT);
    }

    @JsxSetter
    public void setLineHeight(String lineHeight) {
        this.setStyleAttribute(StyleAttributes.Definition.LINE_HEIGHT.getAttributeName(), lineHeight);
        this.updateFont(this.getFont(), false);
    }

    @JsxGetter
    public String getFontFamily() {
        return this.getStyleAttribute(StyleAttributes.Definition.FONT_FAMILY);
    }

    @JsxSetter
    public void setFontFamily(String fontFamily) {
        this.setStyleAttribute(StyleAttributes.Definition.FONT_FAMILY.getAttributeName(), fontFamily);
        this.updateFont(this.getFont(), false);
    }

    private void updateFont(String font, boolean force) {
        BrowserVersion browserVersion = this.getBrowserVersion();
        String[] details = ComputedFont.getDetails(font, !browserVersion.hasFeature(BrowserVersionFeatures.CSS_SET_NULL_THROWS));
        if (details != null || force) {
            StringBuilder newFont = new StringBuilder();
            newFont.append(this.getFontSize());
            String lineHeight = this.getLineHeight();
            String defaultLineHeight = StyleAttributes.Definition.LINE_HEIGHT.getDefaultComputedValue(browserVersion);
            if (lineHeight.isEmpty()) {
                lineHeight = defaultLineHeight;
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.CSS_ZINDEX_TYPE_INTEGER) || !lineHeight.equals(defaultLineHeight)) {
                newFont.append('/');
                if (lineHeight.equals(defaultLineHeight)) {
                    newFont.append(StyleAttributes.Definition.LINE_HEIGHT.getDefaultComputedValue(browserVersion));
                } else {
                    newFont.append(lineHeight);
                }
            }
            newFont.append(' ').append(this.getFontFamily());
            this.setStyleAttribute(StyleAttributes.Definition.FONT.getAttributeName(), newFont.toString());
        }
    }

    @JsxGetter
    public String getFont() {
        return this.getStyleAttribute(StyleAttributes.Definition.FONT);
    }

    @JsxSetter
    public void setFont(String font) {
        String[] details = ComputedFont.getDetails(font, !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_SET_NULL_THROWS));
        if (details != null) {
            this.setStyleAttribute(StyleAttributes.Definition.FONT_FAMILY.getAttributeName(), details[5]);
            String fontSize = details[3];
            if (details[4] != null) {
                this.setStyleAttribute(StyleAttributes.Definition.LINE_HEIGHT.getAttributeName(), details[4]);
            }
            this.setStyleAttribute(StyleAttributes.Definition.FONT_SIZE.getAttributeName(), fontSize);
            this.updateFont(font, true);
        }
    }

    @JsxGetter
    public String getHeight() {
        return this.getStyleAttribute(StyleAttributes.Definition.HEIGHT);
    }

    @JsxSetter
    public void setHeight(Object height) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.HEIGHT.getAttributeName(), height, "", true, true, false, false);
    }

    @JsxGetter
    public String getLeft() {
        return this.getStyleAttribute(StyleAttributes.Definition.LEFT);
    }

    @JsxSetter
    public void setLeft(Object left) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.LEFT.getAttributeName(), left, "", true, true, false, false);
    }

    @JsxGetter
    public int getLength() {
        return this.getStyleMap().size();
    }

    @JsxGetter
    public String getLetterSpacing() {
        return this.getStyleAttribute(StyleAttributes.Definition.LETTER_SPACING);
    }

    @JsxSetter
    public void setLetterSpacing(Object letterSpacing) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.LETTER_SPACING.getAttributeName(), letterSpacing, "", false, false, false, false);
    }

    @JsxGetter
    public String getMargin() {
        return this.getStyleAttribute(StyleAttributes.Definition.MARGIN);
    }

    @JsxSetter
    public void setMargin(String margin) {
        this.setStyleAttribute(StyleAttributes.Definition.MARGIN.getAttributeName(), margin);
    }

    @JsxGetter
    public String getMarginBottom() {
        return this.getStyleAttribute(StyleAttributes.Definition.MARGIN_BOTTOM, StyleAttributes.Definition.MARGIN);
    }

    @JsxSetter
    public void setMarginBottom(Object marginBottom) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MARGIN_BOTTOM.getAttributeName(), marginBottom, "", true, true, false, false);
    }

    @JsxGetter
    public String getMarginLeft() {
        return this.getStyleAttribute(StyleAttributes.Definition.MARGIN_LEFT, StyleAttributes.Definition.MARGIN);
    }

    @JsxSetter
    public void setMarginLeft(Object marginLeft) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MARGIN_LEFT.getAttributeName(), marginLeft, "", true, true, false, false);
    }

    @JsxGetter
    public String getMarginRight() {
        return this.getStyleAttribute(StyleAttributes.Definition.MARGIN_RIGHT, StyleAttributes.Definition.MARGIN);
    }

    @JsxSetter
    public void setMarginRight(Object marginRight) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MARGIN_RIGHT.getAttributeName(), marginRight, "", true, true, false, false);
    }

    @JsxGetter
    public String getMarginTop() {
        return this.getStyleAttribute(StyleAttributes.Definition.MARGIN_TOP, StyleAttributes.Definition.MARGIN);
    }

    @JsxSetter
    public void setMarginTop(Object marginTop) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MARGIN_TOP.getAttributeName(), marginTop, "", true, true, false, false);
    }

    @JsxGetter
    public String getMaxHeight() {
        return this.getStyleAttribute(StyleAttributes.Definition.MAX_HEIGHT);
    }

    @JsxSetter
    public void setMaxHeight(Object maxHeight) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MAX_HEIGHT.getAttributeName(), maxHeight, "", false, true, false, false);
    }

    @JsxGetter
    public String getMaxWidth() {
        return this.getStyleAttribute(StyleAttributes.Definition.MAX_WIDTH);
    }

    @JsxSetter
    public void setMaxWidth(Object maxWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MAX_WIDTH.getAttributeName(), maxWidth, "", false, true, false, false);
    }

    @JsxGetter
    public String getMinHeight() {
        return this.getStyleAttribute(StyleAttributes.Definition.MIN_HEIGHT);
    }

    @JsxSetter
    public void setMinHeight(Object minHeight) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MIN_HEIGHT.getAttributeName(), minHeight, "", true, true, false, false);
    }

    @JsxGetter
    public String getMinWidth() {
        return this.getStyleAttribute(StyleAttributes.Definition.MIN_WIDTH);
    }

    @JsxSetter
    public void setMinWidth(Object minWidth) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.MIN_WIDTH.getAttributeName(), minWidth, "", true, true, false, false);
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (this != start) {
            return super.get(name, start);
        }
        for (Scriptable prototype = this.getPrototype(); prototype != null; prototype = prototype.getPrototype()) {
            Object value = prototype.get(name, start);
            if (value == Scriptable.NOT_FOUND) continue;
            return value;
        }
        StyleAttributes.Definition style = StyleAttributes.getDefinition(name, this.getBrowserVersion());
        if (style != null) {
            return this.getStyleAttribute(style);
        }
        return super.get(name, start);
    }

    public Object get(int index, Scriptable start) {
        if (index < 0) {
            return Undefined.instance;
        }
        Map<String, StyleElement> style = this.getStyleMap();
        int size = style.size();
        if (index >= size) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_WRONG_INDEX_RETURNS_UNDEFINED)) {
                return Undefined.instance;
            }
            return "";
        }
        return style.keySet().toArray(new String[size])[index];
    }

    public final String getStyleAttribute(StyleAttributes.Definition definition) {
        return this.getStyleAttribute(definition, true);
    }

    public String getStyleAttribute(StyleAttributes.Definition definition, boolean getDefaultValueIfEmpty) {
        return this.getStyleAttributeImpl(definition.getAttributeName());
    }

    private String getStyleAttributeImpl(String string) {
        if (this.styleDeclaration_ != null) {
            return this.styleDeclaration_.getPropertyValue(string);
        }
        StyleElement element = this.getStyleElement(string);
        if (element != null && element.getValue() != null) {
            String value = element.getValue();
            if (!value.contains("url")) {
                return value.toLowerCase(Locale.ROOT);
            }
            return value;
        }
        return "";
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        StyleAttributes.Definition style;
        if (this != start) {
            super.put(name, start, value);
            return;
        }
        Scriptable prototype = this.getPrototype();
        if (prototype != null && !"constructor".equals(name) && prototype.get(name, start) != Scriptable.NOT_FOUND) {
            prototype.put(name, start, value);
            return;
        }
        if (this.getDomNodeOrNull() != null && (style = StyleAttributes.getDefinition(name, this.getBrowserVersion())) != null) {
            String stringValue = Context.toString((Object)value);
            this.setStyleAttribute(style.getAttributeName(), stringValue);
            return;
        }
        super.put(name, start, value);
    }

    public boolean has(String name, Scriptable start) {
        if (this != start) {
            return super.has(name, start);
        }
        StyleAttributes.Definition style = StyleAttributes.getDefinition(name, this.getBrowserVersion());
        if (style != null) {
            return true;
        }
        return super.has(name, start);
    }

    public Object[] getIds() {
        Object[] normalIds;
        ArrayList<Object> ids = new ArrayList<Object>();
        for (StyleAttributes.Definition styleAttribute : StyleAttributes.getDefinitions(this.getBrowserVersion())) {
            ids.add(styleAttribute.getPropertyName());
        }
        for (Object o : normalIds = super.getIds()) {
            if (ids.contains(o)) continue;
            ids.add(o);
        }
        return ids.toArray();
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setMsImeAlign(String msImeAlign) {
        this.setStyleAttribute(StyleAttributes.Definition.MS_IME_ALIGN.getAttributeName(), msImeAlign);
    }

    @JsxGetter
    public String getOpacity() {
        String opacity = this.getStyleAttribute(StyleAttributes.Definition.OPACITY, false);
        if (opacity == null || opacity.isEmpty()) {
            return "";
        }
        String trimedOpacity = opacity.trim();
        try {
            double value = Double.parseDouble(trimedOpacity);
            if (value % 1.0 == 0.0) {
                return Integer.toString((int)value);
            }
            return Double.toString(value);
        }
        catch (NumberFormatException numberFormatException) {
            return "";
        }
    }

    @JsxSetter
    public void setOpacity(Object opacity) {
        double doubleValue;
        if (ScriptRuntime.isNaN((Object)opacity)) {
            return;
        }
        if (opacity instanceof Number) {
            doubleValue = ((Number)opacity).doubleValue();
        } else {
            String valueString = Context.toString((Object)opacity);
            if (valueString.isEmpty()) {
                this.setStyleAttribute(StyleAttributes.Definition.OPACITY.getAttributeName(), valueString);
                return;
            }
            valueString = valueString.trim();
            try {
                doubleValue = Double.parseDouble(valueString);
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
            return;
        }
        this.setStyleAttribute(StyleAttributes.Definition.OPACITY.getAttributeName(), Double.toString(doubleValue));
    }

    @JsxGetter
    public String getOutline() {
        return this.getStyleAttribute(StyleAttributes.Definition.OUTLINE);
    }

    @JsxSetter
    public void setOutline(String outline) {
        this.setStyleAttribute(StyleAttributes.Definition.OUTLINE.getAttributeName(), outline);
    }

    @JsxGetter
    public String getOutlineWidth() {
        return this.getStyleAttribute(StyleAttributes.Definition.OUTLINE_WIDTH);
    }

    @JsxSetter
    public void setOutlineWidth(Object outlineWidth) {
        boolean requiresUnit = !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_OUTLINE_WIDTH_UNIT_NOT_REQUIRED);
        this.setStyleLengthAttribute(StyleAttributes.Definition.OUTLINE_WIDTH.getAttributeName(), outlineWidth, "", false, false, true, requiresUnit);
    }

    @JsxGetter
    public String getPadding() {
        return this.getStyleAttribute(StyleAttributes.Definition.PADDING);
    }

    @JsxSetter
    public void setPadding(String padding) {
        this.setStyleAttribute(StyleAttributes.Definition.PADDING.getAttributeName(), padding);
    }

    @JsxGetter
    public String getPaddingBottom() {
        return this.getStyleAttribute(StyleAttributes.Definition.PADDING_BOTTOM, StyleAttributes.Definition.PADDING);
    }

    @JsxSetter
    public void setPaddingBottom(Object paddingBottom) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.PADDING_BOTTOM.getAttributeName(), paddingBottom, "", false, true, false, false);
    }

    @JsxGetter
    public String getPaddingLeft() {
        return this.getStyleAttribute(StyleAttributes.Definition.PADDING_LEFT, StyleAttributes.Definition.PADDING);
    }

    @JsxSetter
    public void setPaddingLeft(Object paddingLeft) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.PADDING_LEFT.getAttributeName(), paddingLeft, "", false, true, false, false);
    }

    @JsxGetter
    public String getPaddingRight() {
        return this.getStyleAttribute(StyleAttributes.Definition.PADDING_RIGHT, StyleAttributes.Definition.PADDING);
    }

    @JsxSetter
    public void setPaddingRight(Object paddingRight) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.PADDING_RIGHT.getAttributeName(), paddingRight, "", false, true, false, false);
    }

    @JsxGetter
    public String getPaddingTop() {
        return this.getStyleAttribute(StyleAttributes.Definition.PADDING_TOP, StyleAttributes.Definition.PADDING);
    }

    @JsxSetter
    public void setPaddingTop(Object paddingTop) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.PADDING_TOP.getAttributeName(), paddingTop, "", false, true, false, false);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public String getPage() {
        return this.getStyleAttribute(StyleAttributes.Definition.PAGE);
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setPage(String page) {
        this.setStyleAttribute(StyleAttributes.Definition.PAGE.getAttributeName(), page);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPixelBottom() {
        return CSSStyleDeclaration.pixelValue(this.getBottom());
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPixelBottom(int pixelBottom) {
        this.setBottom(pixelBottom + "px");
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPixelHeight() {
        return CSSStyleDeclaration.pixelValue(this.getHeight());
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPixelHeight(int pixelHeight) {
        this.setHeight(pixelHeight + "px");
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPixelLeft() {
        return CSSStyleDeclaration.pixelValue(this.getLeft());
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPixelLeft(int pixelLeft) {
        this.setLeft(pixelLeft + "px");
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPixelRight() {
        return CSSStyleDeclaration.pixelValue(this.getRight());
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPixelRight(int pixelRight) {
        this.setRight(pixelRight + "px");
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPixelTop() {
        return CSSStyleDeclaration.pixelValue(this.getTop());
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPixelTop(int pixelTop) {
        this.setTop(pixelTop + "px");
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPixelWidth() {
        return CSSStyleDeclaration.pixelValue(this.getWidth());
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPixelWidth(int pixelWidth) {
        this.setWidth(pixelWidth + "px");
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPosBottom() {
        return 0;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPosBottom(int posBottom) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPosHeight() {
        return 0;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPosHeight(int posHeight) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPosLeft() {
        return 0;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPosLeft(int posLeft) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPosRight() {
        return 0;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPosRight(int posRight) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPosTop() {
        return 0;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPosTop(int posTop) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public int getPosWidth() {
        return 0;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setPosWidth(int posWidth) {
    }

    @JsxGetter
    public String getRight() {
        return this.getStyleAttribute(StyleAttributes.Definition.RIGHT);
    }

    @JsxSetter
    public void setRight(Object right) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.RIGHT.getAttributeName(), right, "", true, true, false, false);
    }

    @JsxGetter(value={SupportedBrowser.IE, SupportedBrowser.FF})
    public String getRubyAlign() {
        return this.getStyleAttribute(StyleAttributes.Definition.RUBY_ALIGN);
    }

    @JsxSetter(value={SupportedBrowser.IE, SupportedBrowser.FF})
    public void setRubyAlign(String rubyAlign) {
        this.setStyleAttribute(StyleAttributes.Definition.RUBY_ALIGN.getAttributeName(), rubyAlign);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public String getSize() {
        return this.getStyleAttribute(StyleAttributes.Definition.SIZE);
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setSize(String size) {
        this.setStyleAttribute(StyleAttributes.Definition.SIZE.getAttributeName(), size);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public boolean isTextDecorationBlink() {
        return false;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setTextDecorationBlink(boolean textDecorationBlink) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public boolean isTextDecorationLineThrough() {
        return false;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setTextDecorationLineThrough(boolean textDecorationLineThrough) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public boolean isTextDecorationNone() {
        return false;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setTextDecorationNone(boolean textDecorationNone) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public boolean isTextDecorationOverline() {
        return false;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setTextDecorationOverline(boolean textDecorationOverline) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public boolean getTextDecorationUnderline() {
        return false;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setTextDecorationUnderline(boolean textDecorationUnderline) {
    }

    @JsxGetter
    public String getTextIndent() {
        return this.getStyleAttribute(StyleAttributes.Definition.TEXT_INDENT);
    }

    @JsxSetter
    public void setTextIndent(Object textIndent) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.TEXT_INDENT.getAttributeName(), textIndent, "", false, true, false, false);
    }

    @JsxGetter
    public String getTop() {
        return this.getStyleAttribute(StyleAttributes.Definition.TOP);
    }

    @JsxSetter
    public void setTop(Object top) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.TOP.getAttributeName(), top, "", true, true, false, false);
    }

    @JsxGetter
    public String getVerticalAlign() {
        return this.getStyleAttribute(StyleAttributes.Definition.VERTICAL_ALIGN);
    }

    @JsxSetter
    public void setVerticalAlign(Object verticalAlign) {
        boolean auto = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_VERTICAL_ALIGN_SUPPORTS_AUTO);
        this.setStyleLengthAttribute(StyleAttributes.Definition.VERTICAL_ALIGN.getAttributeName(), verticalAlign, "", auto, true, false, false);
    }

    @JsxGetter
    public String getWidth() {
        return this.getStyleAttribute(StyleAttributes.Definition.WIDTH);
    }

    @JsxSetter
    public void setWidth(Object width) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.WIDTH.getAttributeName(), width, "", true, true, false, false);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public String getWidows() {
        return this.getStyleAttribute(StyleAttributes.Definition.WIDOWS);
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public void setWidows(String widows) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL)) {
            try {
                if (Integer.parseInt(widows) <= 0) {
                    return;
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        this.setStyleAttribute(StyleAttributes.Definition.WIDOWS.getAttributeName(), widows);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public String getOrphans() {
        return this.getStyleAttribute(StyleAttributes.Definition.ORPHANS);
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public void setOrphans(String orphans) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_BACKGROUND_INITIAL)) {
            try {
                if (Integer.parseInt(orphans) <= 0) {
                    return;
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        this.setStyleAttribute(StyleAttributes.Definition.ORPHANS.getAttributeName(), orphans);
    }

    @JsxGetter
    public String getPosition() {
        return this.getStyleAttribute(StyleAttributes.Definition.POSITION);
    }

    @JsxSetter
    public void setPosition(String position) {
        if (position.isEmpty() || STATIC.equalsIgnoreCase(position) || ABSOLUTE.equalsIgnoreCase(position) || FIXED.equalsIgnoreCase(position) || RELATIVE.equalsIgnoreCase(position) || INITIAL.equalsIgnoreCase(position) || INHERIT.equalsIgnoreCase(position)) {
            this.setStyleAttribute(StyleAttributes.Definition.POSITION.getAttributeName(), position.toLowerCase(Locale.ROOT));
        }
    }

    @JsxGetter
    public String getWordSpacing() {
        return this.getStyleAttribute(StyleAttributes.Definition.WORD_SPACING);
    }

    @JsxSetter
    public void setWordSpacing(Object wordSpacing) {
        this.setStyleLengthAttribute(StyleAttributes.Definition.WORD_SPACING.getAttributeName(), wordSpacing, "", false, this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_WORD_SPACING_ACCEPTS_PERCENT), false, false);
    }

    @JsxGetter
    public Object getZIndex() {
        String value = this.getStyleAttribute(StyleAttributes.Definition.Z_INDEX_);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_ZINDEX_TYPE_INTEGER)) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return "";
            }
        }
        try {
            Integer.parseInt(value);
            return value;
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    @JsxSetter
    public void setZIndex(Object zIndex) {
        if (zIndex == null || StringUtils.isEmpty((CharSequence)zIndex.toString())) {
            this.setStyleAttribute(StyleAttributes.Definition.Z_INDEX_.getAttributeName(), "");
            return;
        }
        if (Undefined.isUndefined((Object)zIndex)) {
            return;
        }
        if (zIndex instanceof Number) {
            Number number = (Number)zIndex;
            if (number.doubleValue() % 1.0 == 0.0) {
                this.setStyleAttribute(StyleAttributes.Definition.Z_INDEX_.getAttributeName(), Integer.toString(number.intValue()));
            }
            return;
        }
        try {
            int i = Integer.parseInt(zIndex.toString());
            this.setStyleAttribute(StyleAttributes.Definition.Z_INDEX_.getAttributeName(), Integer.toString(i));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @JsxFunction
    public String getPropertyValue(String name) {
        Object value;
        if (name != null && name.contains("-") && (value = CSSStyleDeclaration.getProperty((Scriptable)this, (String)CSSStyleDeclaration.camelize(name))) instanceof String) {
            return (String)value;
        }
        return this.getStyleAttributeImpl(name);
    }

    @JsxFunction(value={SupportedBrowser.FF60})
    public CSSValue getPropertyCSSValue(String name) {
        String cssText;
        CSSValueImpl cssValue;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("getPropertyCSSValue(" + name + "): getPropertyCSSValue support is experimental"));
        }
        if (this.styleDeclaration_ == null) {
            String styleAttribute = this.jsElement_.getDomNodeOrDie().getAttributeDirect("style");
            CSSErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser((CSSParser)new CSS3Parser());
            parser.setErrorHandler(errorHandler);
            try {
                this.styleDeclaration_ = parser.parseStyleDeclaration(styleAttribute);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((cssValue = this.styleDeclaration_.getPropertyCSSValue(name)) == null) {
            CSSValueImpl newValue = new CSSValueImpl(null, false);
            newValue.setDoubleValue(0.0);
            cssValue = newValue;
        }
        if ((cssText = cssValue.getCssText()).startsWith("rgb(")) {
            String formatedCssText = StringUtils.replace((String)cssText, (String)",", (String)", ");
            cssValue.setCssText(formatedCssText);
        }
        return new CSSPrimitiveValue(this.jsElement_, cssValue);
    }

    @JsxFunction
    public String getPropertyPriority(String name) {
        return this.getStylePriority(name);
    }

    @JsxFunction
    public void setProperty(String name, Object value, String important) {
        String imp = "";
        if (!StringUtils.isEmpty((CharSequence)important) && !"null".equals(important)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_SET_PROPERTY_IMPORTANT_IGNORES_CASE) ? !"important".equalsIgnoreCase(important) : !"important".equals(important)) {
                return;
            }
            imp = "important";
        }
        if (LENGTH_PROPERTIES_FFFF.contains(name)) {
            this.setStyleLengthAttribute(name, value, imp, false, false, false, false);
        } else if (LENGTH_PROPERTIES_TTFF.contains(name)) {
            this.setStyleLengthAttribute(name, value, imp, true, true, false, false);
        } else if (LENGTH_PROPERTIES_FTFF.contains(name)) {
            this.setStyleLengthAttribute(name, value, imp, false, true, false, false);
        } else if (StyleAttributes.Definition.OUTLINE_WIDTH.getAttributeName().equals(name)) {
            boolean requiresUnit = !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_OUTLINE_WIDTH_UNIT_NOT_REQUIRED);
            this.setStyleLengthAttribute(StyleAttributes.Definition.OUTLINE_WIDTH.getAttributeName(), value, imp, false, false, true, requiresUnit);
        } else if (StyleAttributes.Definition.WORD_SPACING.getAttributeName().equals(name)) {
            this.setStyleLengthAttribute(StyleAttributes.Definition.WORD_SPACING.getAttributeName(), value, imp, false, this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLE_WORD_SPACING_ACCEPTS_PERCENT), false, false);
        } else if (StyleAttributes.Definition.VERTICAL_ALIGN.getAttributeName().equals(name)) {
            boolean auto = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_VERTICAL_ALIGN_SUPPORTS_AUTO);
            this.setStyleLengthAttribute(StyleAttributes.Definition.VERTICAL_ALIGN.getAttributeName(), value, imp, auto, true, false, false);
        } else {
            this.setStyleAttribute(name, Context.toString((Object)value), imp);
        }
    }

    @JsxFunction
    public String removeProperty(Object name) {
        return this.removeStyleAttribute(Context.toString((Object)name));
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public Object getAttribute(String name, int flag) {
        StyleElement style = this.getStyleElementCaseInSensitive(name);
        if (null == style) {
            return "";
        }
        return style.getValue();
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void setAttribute(String name, String value, Object flag) {
        StyleElement style = this.getStyleElementCaseInSensitive(name);
        if (null != style) {
            this.setStyleAttribute(style.getName(), value);
        }
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public boolean removeAttribute(String name, Object flag) {
        StyleElement style = this.getStyleElementCaseInSensitive(name);
        if (style != null) {
            this.removeStyleAttribute(style.getName());
            return true;
        }
        return false;
    }

    private static String findColor(String text) {
        String[] tokens;
        Color tmpColor = com.gargoylesoftware.htmlunit.util.StringUtils.findColorRGB(text);
        if (tmpColor != null) {
            return com.gargoylesoftware.htmlunit.util.StringUtils.formatColor(tmpColor);
        }
        for (String token : tokens = StringUtils.split((String)text, (char)' ')) {
            if (CSSStyleDeclaration.isColorKeyword(token)) {
                return token;
            }
            tmpColor = com.gargoylesoftware.htmlunit.util.StringUtils.asColorHexadecimal(token);
            if (tmpColor == null) continue;
            return com.gargoylesoftware.htmlunit.util.StringUtils.formatColor(tmpColor);
        }
        return null;
    }

    private static String findImageUrl(String text) {
        Matcher m = URL_PATTERN.matcher(text);
        if (m.find()) {
            return "url(\"" + m.group(1) + "\")";
        }
        return null;
    }

    private static String findPosition(String text) {
        Matcher m = POSITION_PATTERN.matcher(text);
        if (m.find()) {
            return m.group(1) + " " + m.group(3);
        }
        m = POSITION_PATTERN2.matcher(text);
        if (m.find()) {
            return m.group(1) + " " + m.group(2);
        }
        m = POSITION_PATTERN3.matcher(text);
        if (m.find()) {
            return m.group(2) + " " + m.group(1);
        }
        return null;
    }

    private static String findRepeat(String text) {
        if (text.contains("repeat-x")) {
            return "repeat-x";
        }
        if (text.contains("repeat-y")) {
            return "repeat-y";
        }
        if (text.contains("no-repeat")) {
            return "no-repeat";
        }
        if (text.contains(REPEAT)) {
            return REPEAT;
        }
        return null;
    }

    private static String findAttachment(String text) {
        if (text.contains("scroll")) {
            return "scroll";
        }
        if (text.contains(FIXED)) {
            return FIXED;
        }
        return null;
    }

    private static String findBorderStyle(String text) {
        for (String token : StringUtils.split((String)text, (char)' ')) {
            if (!CSSStyleDeclaration.isBorderStyle(token)) continue;
            return token;
        }
        return null;
    }

    private static String findBorderWidth(String text) {
        for (String token : StringUtils.split((String)text, (char)' ')) {
            if (!CSSStyleDeclaration.isBorderWidth(token)) continue;
            return token;
        }
        return null;
    }

    private static boolean isColorKeyword(String token) {
        return CSSColors_.containsKey(token.toLowerCase(Locale.ROOT));
    }

    public static String toRGBColor(String color) {
        String rgbValue = CSSColors_.get(color.toLowerCase(Locale.ROOT));
        if (rgbValue != null) {
            return rgbValue;
        }
        return color;
    }

    private static boolean isBorderStyle(String token) {
        return NONE.equalsIgnoreCase(token) || "hidden".equalsIgnoreCase(token) || "dotted".equalsIgnoreCase(token) || "dashed".equalsIgnoreCase(token) || "solid".equalsIgnoreCase(token) || "double".equalsIgnoreCase(token) || "groove".equalsIgnoreCase(token) || "ridge".equalsIgnoreCase(token) || "inset".equalsIgnoreCase(token) || "outset".equalsIgnoreCase(token);
    }

    private static boolean isBorderWidth(String token) {
        return "thin".equalsIgnoreCase(token) || "medium".equalsIgnoreCase(token) || "thick".equalsIgnoreCase(token) || CSSStyleDeclaration.isLength(token);
    }

    static boolean isLength(String token) {
        if (token.endsWith("em") || token.endsWith("ex") || token.endsWith("px") || token.endsWith("in") || token.endsWith("cm") || token.endsWith("mm") || token.endsWith("pt") || token.endsWith("pc") || token.endsWith("%")) {
            token = token.endsWith("%") ? token.substring(0, token.length() - 1) : token.substring(0, token.length() - 2);
            try {
                Double.parseDouble(token);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static int pixelValue(Element element, CssValue value) {
        return CSSStyleDeclaration.pixelValue(element, value, false);
    }

    private static int pixelValue(Element element, CssValue value, boolean percentMode) {
        String s = value.get(element);
        if (s.endsWith("%") || s.isEmpty() && element instanceof HTMLHtmlElement) {
            int i = NumberUtils.toInt((String)TO_INT_PATTERN.matcher(s).replaceAll("$1"), (int)100);
            Element parent = element.getParentElement();
            int absoluteValue = parent == null ? value.getWindowDefaultValue() : CSSStyleDeclaration.pixelValue(parent, value, true);
            return (int)((double)i / 100.0 * (double)absoluteValue);
        }
        if (AUTO.equals(s)) {
            return value.getDefaultValue();
        }
        if (s.isEmpty()) {
            if (element instanceof HTMLCanvasElement) {
                return value.getWindowDefaultValue();
            }
            if (percentMode) {
                Element parent = element.getParentElement();
                if (parent == null || parent instanceof HTMLHtmlElement) {
                    return value.getWindowDefaultValue();
                }
                return CSSStyleDeclaration.pixelValue(parent, value, true);
            }
            return 0;
        }
        return CSSStyleDeclaration.pixelValue(s);
    }

    protected static int pixelValue(String value) {
        int i = NumberUtils.toInt((String)TO_INT_PATTERN.matcher(value).replaceAll("$1"), (int)0);
        if (value.length() < 2) {
            return i;
        }
        if (value.endsWith("px")) {
            return i;
        }
        if (value.endsWith("em")) {
            i *= 16;
        } else if (value.endsWith("%")) {
            i = i * 16 / 100;
        } else if (value.endsWith("ex")) {
            i *= 10;
        } else if (value.endsWith("in")) {
            i *= 150;
        } else if (value.endsWith("cm")) {
            i *= 50;
        } else if (value.endsWith("mm")) {
            i *= 5;
        } else if (value.endsWith("pt")) {
            i *= 2;
        } else if (value.endsWith("pc")) {
            i *= 24;
        }
        return i;
    }

    protected boolean isReadOnlySettable(String name, Object value) {
        if ("length".equals(name)) {
            return false;
        }
        return super.isReadOnlySettable(name, value);
    }

    public String toString() {
        if (this.jsElement_ == null) {
            return "CSSStyleDeclaration for 'null'";
        }
        String style = this.jsElement_.getDomNodeOrDie().getAttributeDirect("style");
        return "CSSStyleDeclaration for '" + style + "'";
    }

    private void setStyleLengthAttribute(String name, Object value, String important, boolean auto, boolean percent, boolean thinMedThick, boolean unitRequired) {
        String valueString;
        double doubleValue;
        if (ScriptRuntime.isNaN((Object)value)) {
            return;
        }
        String unit = "px";
        if (value instanceof Number) {
            if (unitRequired) {
                return;
            }
            doubleValue = ((Number)value).doubleValue();
        } else {
            valueString = Context.toString((Object)value);
            if (null == value) {
                valueString = "";
            }
            if (StringUtils.isEmpty((CharSequence)valueString)) {
                this.setStyleAttribute(name, valueString, important);
                return;
            }
            if (auto && AUTO.equals(valueString) || INITIAL.equals(valueString) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_LENGTH_INITIAL) || INHERIT.equals(valueString)) {
                this.setStyleAttribute(name, valueString, important);
                return;
            }
            if (thinMedThick && "thin".equals(valueString) || "medium".equals(valueString) || "thick".equals(valueString)) {
                this.setStyleAttribute(name, valueString, important);
                return;
            }
            if (percent && valueString.endsWith("%")) {
                unit = valueString.substring(valueString.length() - 1);
                valueString = valueString.substring(0, valueString.length() - 1);
            } else if (valueString.endsWith("px") || valueString.endsWith("em") || valueString.endsWith("ex") || valueString.endsWith("pt") || valueString.endsWith("cm") || valueString.endsWith("mm") || valueString.endsWith("in") || valueString.endsWith("pc") || valueString.endsWith("ch") || valueString.endsWith("vh") || valueString.endsWith("vw")) {
                unit = valueString.substring(valueString.length() - 2);
                valueString = valueString.substring(0, valueString.length() - 2);
            } else if (valueString.endsWith("rem") || valueString.endsWith("vmin") || valueString.endsWith("vmax")) {
                unit = valueString.substring(valueString.length() - 3);
                valueString = valueString.substring(0, valueString.length() - 3);
            } else if (unitRequired) {
                return;
            }
            doubleValue = Context.toNumber((Object)valueString);
        }
        try {
            if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
                return;
            }
            valueString = doubleValue % 1.0 == 0.0 ? Integer.toString((int)doubleValue) + unit : Double.toString(doubleValue) + unit;
            this.setStyleAttribute(name, valueString, important);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        CSSColors_.put("aqua", "rgb(0, 255, 255)");
        CSSColors_.put("black", "rgb(0, 0, 0)");
        CSSColors_.put("blue", "rgb(0, 0, 255)");
        CSSColors_.put("fuchsia", "rgb(255, 0, 255)");
        CSSColors_.put("gray", "rgb(128, 128, 128)");
        CSSColors_.put("green", "rgb(0, 128, 0)");
        CSSColors_.put("lime", "rgb(0, 255, 0)");
        CSSColors_.put("maroon", "rgb(128, 0, 0)");
        CSSColors_.put("navy", "rgb(0, 0, 128)");
        CSSColors_.put("olive", "rgb(128, 128, 0)");
        CSSColors_.put("purple", "rgb(128, 0, 128)");
        CSSColors_.put("red", "rgb(255, 0, 0)");
        CSSColors_.put("silver", "rgb(192, 192, 192)");
        CSSColors_.put("teal", "rgb(0, 128, 128)");
        CSSColors_.put("white", "rgb(255, 255, 255)");
        CSSColors_.put("yellow", "rgb(255, 255, 0)");
    }

    protected static abstract class CssValue {
        private final int defaultValue_;
        private final int windowDefaultValue_;

        public CssValue(int defaultValue, int windowDefaultValue) {
            this.defaultValue_ = defaultValue;
            this.windowDefaultValue_ = windowDefaultValue;
        }

        public int getDefaultValue() {
            return this.defaultValue_;
        }

        public int getWindowDefaultValue() {
            return this.windowDefaultValue_;
        }

        public final String get(Element element) {
            CSS2Properties style = element.getWindow().getComputedStyle(element, null);
            return this.get(style);
        }

        public abstract String get(ComputedCSSStyleDeclaration var1);
    }
}

