/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.events;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import jakarta.mvc.tck.tests.events.MvcEventObserver;
import jakarta.mvc.tck.tests.events.MvcEventsController;
import jakarta.mvc.tck.tests.events.TraceManager;
import jakarta.mvc.tck.tests.events.TraceServlet;
import jakarta.mvc.tck.util.Archives;
import jakarta.mvc.tck.util.MvcMatchers;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class MvcEventsTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(MvcEventObserver.class).addClass(MvcEventsController.class).addClass(TraceManager.class).addClass(TraceServlet.class).addView("${viewRendered.run()}\nSome rendered view", "view-success.jsp").addView("${viewRendered.run()}\n${failRender.run()}", "view-error.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertion(section="observers", id="before-after-controller")
    public void aroundControllerEvents() throws IOException {
        String tid = UUID.randomUUID().toString();
        HtmlPage mvcPage = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/events/success?tid=" + tid);
        Assert.assertThat((Object)mvcPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)mvcPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Some rendered view"));
        TextPage tracePage = (TextPage)this.webClient.getPage(this.baseUrl.toString() + "trace?tid=" + tid);
        Assert.assertThat((Object)tracePage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)tracePage.getContent().trim(), (Matcher)CoreMatchers.startsWith((String)"BeforeControllerEvent,ControllerExecuted,AfterControllerEvent"));
    }

    @Test
    @SpecAssertion(section="observers", id="after-controller-exception")
    public void afterControllerWithError() throws IOException {
        String tid = UUID.randomUUID().toString();
        HtmlPage mvcPage = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/events/controller-error?tid=" + tid);
        Assert.assertThat((Object)mvcPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)500));
        TextPage tracePage = (TextPage)this.webClient.getPage(this.baseUrl.toString() + "trace?tid=" + tid);
        Assert.assertThat((Object)tracePage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)tracePage.getContent().trim(), (Matcher)CoreMatchers.startsWith((String)"BeforeControllerEvent,ControllerExecuted,AfterControllerEvent"));
    }

    @Test
    @SpecAssertion(section="observers", id="before-after-view")
    public void aroundRenderView() throws IOException {
        String tid = UUID.randomUUID().toString();
        HtmlPage mvcPage = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/events/success?tid=" + tid);
        Assert.assertThat((Object)mvcPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)mvcPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Some rendered view"));
        TextPage tracePage = (TextPage)this.webClient.getPage(this.baseUrl.toString() + "trace?tid=" + tid);
        Assert.assertThat((Object)tracePage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)tracePage.getContent().trim(), (Matcher)CoreMatchers.endsWith((String)"BeforeProcessViewEvent,ViewRendered,AfterProcessViewEvent"));
    }

    @Test
    @SpecAssertion(section="observers", id="after-view-exception")
    public void afterViewWithError() throws IOException {
        String tid = UUID.randomUUID().toString();
        HtmlPage mvcPage = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/events/view-error?tid=" + tid);
        Assert.assertThat((Object)mvcPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)500));
        TextPage tracePage = (TextPage)this.webClient.getPage(this.baseUrl.toString() + "trace?tid=" + tid);
        Assert.assertThat((Object)tracePage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)tracePage.getContent().trim(), (Matcher)CoreMatchers.endsWith((String)"BeforeProcessViewEvent,ViewRendered,AfterProcessViewEvent"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observers", id="redirect-event"), @SpecAssertion(section="observers", id="redirect-after-controller-event")})
    public void redirectEvent() throws IOException {
        String tid = UUID.randomUUID().toString();
        HtmlPage mvcPage = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/events/redirect?tid=" + tid);
        Assert.assertThat((Object)mvcPage.getWebResponse().getStatusCode(), MvcMatchers.isRedirectStatus());
        TextPage tracePage = (TextPage)this.webClient.getPage(this.baseUrl.toString() + "trace?tid=" + tid);
        Assert.assertThat((Object)tracePage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)tracePage.getContent().trim(), (Matcher)CoreMatchers.endsWith((String)"ControllerExecuted,AfterControllerEvent,ControllerRedirectEvent"));
    }
}

