/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.events;

import jakarta.inject.Inject;
import jakarta.mvc.Controller;
import jakarta.mvc.Models;
import jakarta.mvc.tck.tests.events.TraceManager;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;

@Controller
@Path(value="events")
public class MvcEventsController {
    @Inject
    private TraceManager traceManager;
    @Inject
    private Models models;

    @GET
    @Path(value="success")
    public String success() {
        this.traceManager.controllerExecuted();
        this.models.put("viewRendered", () -> this.traceManager.viewRendered());
        return "view-success.jsp";
    }

    @GET
    @Path(value="controller-error")
    public String controllerError() {
        this.traceManager.controllerExecuted();
        throw new IllegalStateException();
    }

    @GET
    @Path(value="view-error")
    public String viewError() {
        this.traceManager.controllerExecuted();
        this.models.put("viewRendered", () -> this.traceManager.viewRendered());
        this.models.put("failRender", () -> {
            throw new IllegalStateException();
        });
        return "view-error.jsp";
    }

    @GET
    @Path(value="redirect")
    public String redirect() {
        this.traceManager.controllerExecuted();
        return "redirect:events/success";
    }
}

