/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSStyleDeclarationImpl;
import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.css.dom.DOMExceptionImpl;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.util.LangUtils;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class CSSFontFaceRuleImpl
extends AbstractCSSRuleImpl {
    private CSSStyleDeclarationImpl style_;

    public CSSFontFaceRuleImpl(CSSStyleSheetImpl parentStyleSheet, AbstractCSSRuleImpl parentRule) {
        super(parentStyleSheet, parentRule);
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder();
        sb.append("@font-face {");
        CSSStyleDeclarationImpl style = this.getStyle();
        if (null != style) {
            sb.append(style.getCssText());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            AbstractCSSRuleImpl r = parser.parseRule(cssText);
            if (!(r instanceof CSSFontFaceRuleImpl)) {
                throw new DOMExceptionImpl(13, 7);
            }
            this.style_ = ((CSSFontFaceRuleImpl)r).style_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleDeclarationImpl getStyle() {
        return this.style_;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this.style_ = style;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSFontFaceRuleImpl)) {
            return false;
        }
        CSSFontFaceRuleImpl cffr = (CSSFontFaceRuleImpl)obj;
        return super.equals(obj) && LangUtils.equals(this.getStyle(), cffr.getStyle());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.style_);
        return hash;
    }

    public String toString() {
        return this.getCssText();
    }
}

