/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.testng.IInvokedMethod;
import org.testng.IMethodInstance;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.Graph;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodInheritance;
import org.testng.internal.MethodInstance;
import org.testng.internal.RunInfo;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.Pair;

public class MethodHelper {
    private static final Map<ITestNGMethod[], Graph<ITestNGMethod>> GRAPH_CACHE = new ConcurrentHashMap<ITestNGMethod[], Graph<ITestNGMethod>>();
    private static final Map<Method, String> CANONICAL_NAME_CACHE = new ConcurrentHashMap<Method, String>();
    private static final Map<Pair<String, String>, Boolean> MATCH_CACHE = new ConcurrentHashMap<Pair<String, String>, Boolean>();

    public static ITestNGMethod[] collectAndOrderMethods(List<ITestNGMethod> list, boolean bl, RunInfo runInfo, IAnnotationFinder iAnnotationFinder, boolean bl2, List<ITestNGMethod> list2, Comparator<ITestNGMethod> comparator) {
        List<ITestNGMethod> list3 = Lists.newArrayList();
        MethodGroupsHelper.collectMethodsByGroup(list.toArray(new ITestNGMethod[list.size()]), bl, list3, list2, runInfo, iAnnotationFinder, bl2);
        return MethodHelper.sortMethods(bl, list3, comparator).toArray(new ITestNGMethod[0]);
    }

    protected static ITestNGMethod[] findDependedUponMethods(ITestNGMethod iTestNGMethod, List<ITestNGMethod> list) {
        ITestNGMethod[] iTestNGMethodArray = list.toArray(new ITestNGMethod[list.size()]);
        return MethodHelper.findDependedUponMethods(iTestNGMethod, iTestNGMethodArray);
    }

    protected static ITestNGMethod[] findDependedUponMethods(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray) {
        String string = MethodHelper.calculateMethodCanonicalName(iTestNGMethod);
        List list = Lists.newArrayList();
        String string2 = null;
        for (String string3 : iTestNGMethod.getMethodsDependedUpon()) {
            Object object;
            boolean bl = false;
            if (null != string3) {
                int n;
                string2 = string3.replace("$", "\\$");
                object = MethodHelper.matchMethod(iTestNGMethodArray, string2);
                bl = ((MatchResults)object).foundAtLeastAMethod;
                list.addAll(((MatchResults)object).matchedMethods);
                if (!bl && (n = string2.lastIndexOf(46)) != -1) {
                    String string4 = iTestNGMethod.getTestClass().getRealClass().getName() + string2.substring(n);
                    object = MethodHelper.matchMethod(iTestNGMethodArray, string4);
                    bl = ((MatchResults)object).foundAtLeastAMethod;
                    list.addAll(((MatchResults)object).matchedMethods);
                }
            }
            if (bl || iTestNGMethod.ignoreMissingDependencies() || iTestNGMethod.isAlwaysRun()) continue;
            object = MethodHelper.findMethodByName(iTestNGMethod, string2);
            if (object != null) {
                throw new TestNGException(string + "() is depending on method " + object + ", which is not annotated with @Test or not included.");
            }
            throw new TestNGException(string + "() depends on nonexistent method " + string2);
        }
        return list.toArray(new ITestNGMethod[list.size()]);
    }

    private static Method findMethodByName(ITestNGMethod iTestNGMethod, String string) {
        String string2;
        String string3;
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            string3 = iTestNGMethod.getConstructorOrMethod().getDeclaringClass().getCanonicalName();
            string2 = string;
        } else {
            string2 = string.substring(n + 1);
            string3 = string.substring(0, n);
        }
        try {
            Class<?> clazz = Class.forName(string3);
            for (Method method : clazz.getDeclaredMethods()) {
                if (!string2.equals(method.getName())) continue;
                return method;
            }
        }
        catch (Exception exception) {
            Utils.log("MethodHelper", 3, "Caught exception while searching for methods using regex");
        }
        return null;
    }

    protected static boolean isEnabled(Class<?> clazz, IAnnotationFinder iAnnotationFinder) {
        ITestAnnotation iTestAnnotation = AnnotationHelper.findTest(iAnnotationFinder, clazz);
        return MethodHelper.isEnabled(iTestAnnotation);
    }

    protected static boolean isEnabled(Method method, IAnnotationFinder iAnnotationFinder) {
        ITestAnnotation iTestAnnotation = AnnotationHelper.findTest(iAnnotationFinder, method);
        if (null == iTestAnnotation) {
            iTestAnnotation = AnnotationHelper.findTest(iAnnotationFinder, method.getDeclaringClass());
        }
        return MethodHelper.isEnabled(iTestAnnotation);
    }

    protected static boolean isEnabled(ITestOrConfiguration iTestOrConfiguration) {
        return null == iTestOrConfiguration || iTestOrConfiguration.getEnabled();
    }

    static boolean isDisabled(ITestOrConfiguration iTestOrConfiguration) {
        return !MethodHelper.isEnabled(iTestOrConfiguration);
    }

    static boolean isAlwaysRun(IConfigurationAnnotation iConfigurationAnnotation) {
        if (null == iConfigurationAnnotation) {
            return false;
        }
        boolean bl = false;
        if ((iConfigurationAnnotation.getAfterSuite() || iConfigurationAnnotation.getAfterTest() || iConfigurationAnnotation.getAfterTestClass() || iConfigurationAnnotation.getAfterTestMethod() || iConfigurationAnnotation.getBeforeTestMethod() || iConfigurationAnnotation.getBeforeTestClass() || iConfigurationAnnotation.getBeforeTest() || iConfigurationAnnotation.getBeforeSuite()) && iConfigurationAnnotation.getAlwaysRun()) {
            bl = true;
        }
        return bl;
    }

    public static List<ITestNGMethod> uniqueMethodList(Collection<List<ITestNGMethod>> collection) {
        Set set = Sets.newHashSet();
        for (List<ITestNGMethod> list : collection) {
            set.addAll(list);
        }
        return Lists.newArrayList(set);
    }

    private static Graph<ITestNGMethod> topologicalSort(ITestNGMethod[] iTestNGMethodArray, List<ITestNGMethod> list, List<ITestNGMethod> list2, final Comparator<ITestNGMethod> comparator) {
        Graph<ITestNGMethod> graph = new Graph<ITestNGMethod>(new Comparator<Graph.Node<ITestNGMethod>>(){

            @Override
            public int compare(Graph.Node<ITestNGMethod> node, Graph.Node<ITestNGMethod> node2) {
                return comparator.compare(node.getObject(), node2.getObject());
            }
        });
        if (iTestNGMethodArray.length == 0) {
            return graph;
        }
        Map<Object, List<ITestNGMethod>> map = MethodHelper.sortMethodsByInstance(iTestNGMethodArray);
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            Object object;
            graph.addNode(iTestNGMethod);
            List<ITestNGMethod> list3 = Lists.newArrayList();
            String[] stringArray = iTestNGMethod.getMethodsDependedUpon();
            String[] stringArray2 = iTestNGMethod.getGroupsDependedUpon();
            if (stringArray.length > 0) {
                Object object2;
                Object object3 = null;
                if (iTestNGMethod.getInstance() != null) {
                    object2 = map.get(iTestNGMethod.getInstance());
                    try {
                        object3 = MethodHelper.findDependedUponMethods(iTestNGMethod, (List<ITestNGMethod>)object2);
                    }
                    catch (TestNGException testNGException) {
                        object3 = MethodHelper.findDependedUponMethods(iTestNGMethod, iTestNGMethodArray);
                    }
                } else {
                    object3 = MethodHelper.findDependedUponMethods(iTestNGMethod, iTestNGMethodArray);
                }
                object2 = object3;
                int n = ((Object)object2).length;
                for (int i = 0; i < n; ++i) {
                    object = object2[i];
                    list3.add((ITestNGMethod)object);
                }
            }
            if (stringArray2.length > 0) {
                for (String string : stringArray2) {
                    for (ITestNGMethod iTestNGMethod2 : object = MethodGroupsHelper.findMethodsThatBelongToGroup(iTestNGMethod, iTestNGMethodArray, string)) {
                        list3.add(iTestNGMethod2);
                    }
                }
            }
            for (ITestNGMethod iTestNGMethod3 : list3) {
                graph.addPredecessor(iTestNGMethod, iTestNGMethod3);
            }
        }
        graph.topologicalSort();
        list.addAll(graph.getStrictlySortedNodes());
        list2.addAll(graph.getIndependentNodes());
        return graph;
    }

    private static Map<Object, List<ITestNGMethod>> sortMethodsByInstance(ITestNGMethod[] iTestNGMethodArray) {
        LinkedHashMap<Object, List<ITestNGMethod>> linkedHashMap = new LinkedHashMap<Object, List<ITestNGMethod>>();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            Object object = iTestNGMethod.getInstance();
            if (object == null) continue;
            List<ITestNGMethod> list = linkedHashMap.get(object);
            if (list == null) {
                list = new ArrayList<ITestNGMethod>();
            }
            list.add(iTestNGMethod);
            linkedHashMap.put(object, list);
        }
        return linkedHashMap;
    }

    protected static String calculateMethodCanonicalName(ITestNGMethod iTestNGMethod) {
        return MethodHelper.calculateMethodCanonicalName(iTestNGMethod.getConstructorOrMethod().getMethod());
    }

    private static String calculateMethodCanonicalName(Method method) {
        String string = CANONICAL_NAME_CACHE.get(method);
        if (string != null) {
            return string;
        }
        String string2 = method.getDeclaringClass().getName() + "." + method.getName();
        for (Class<?> clazz = method.getDeclaringClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                if (clazz.getDeclaredMethod(method.getName(), method.getParameterTypes()) == null) continue;
                string2 = clazz.getName();
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = string2 + "." + method.getName();
        CANONICAL_NAME_CACHE.put(method, string);
        return string;
    }

    private static List<ITestNGMethod> sortMethods(boolean bl, List<ITestNGMethod> list, Comparator<ITestNGMethod> comparator) {
        Object object;
        List<ITestNGMethod> list2 = Lists.newArrayList();
        List<ITestNGMethod> list3 = Lists.newArrayList();
        ITestNGMethod[] iTestNGMethodArray = list.toArray(new ITestNGMethod[list.size()]);
        if (!bl && iTestNGMethodArray.length > 0) {
            object = iTestNGMethodArray[0];
            boolean bl2 = object.isBeforeClassConfiguration() || object.isBeforeMethodConfiguration() || object.isBeforeSuiteConfiguration() || object.isBeforeTestConfiguration();
            MethodInheritance.fixMethodInheritance(iTestNGMethodArray, bl2);
        }
        MethodHelper.topologicalSort(iTestNGMethodArray, list2, list3, comparator);
        object = Lists.newArrayList();
        object.addAll(list2);
        object.addAll(list3);
        return object;
    }

    public static List<ITestNGMethod> getMethodsDependedUpon(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray, Comparator<ITestNGMethod> comparator) {
        List<ITestNGMethod> list;
        Graph<ITestNGMethod> graph = GRAPH_CACHE.get(iTestNGMethodArray);
        if (graph == null) {
            list = Lists.newArrayList();
            List<ITestNGMethod> list2 = Lists.newArrayList();
            graph = MethodHelper.topologicalSort(iTestNGMethodArray, list2, list, comparator);
            GRAPH_CACHE.put(iTestNGMethodArray, graph);
        }
        list = graph.findPredecessors(iTestNGMethod);
        return list;
    }

    public static void fixMethodsWithClass(ITestNGMethod[] iTestNGMethodArray, ITestClass iTestClass, List<ITestNGMethod> list) {
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            iTestNGMethod.setTestClass(iTestClass);
            if (list == null) continue;
            list.add(iTestNGMethod);
        }
    }

    public static List<ITestNGMethod> invokedMethodsToMethods(Collection<IInvokedMethod> collection) {
        List<ITestNGMethod> list = Lists.newArrayList();
        for (IInvokedMethod iInvokedMethod : collection) {
            ITestNGMethod iTestNGMethod = iInvokedMethod.getTestMethod();
            iTestNGMethod.setDate(iInvokedMethod.getDate());
            list.add(iTestNGMethod);
        }
        return list;
    }

    public static List<IMethodInstance> methodsToMethodInstances(List<ITestNGMethod> list) {
        ArrayList<IMethodInstance> arrayList = new ArrayList<IMethodInstance>();
        for (ITestNGMethod iTestNGMethod : list) {
            arrayList.add(new MethodInstance(iTestNGMethod));
        }
        return arrayList;
    }

    public static List<ITestNGMethod> methodInstancesToMethods(List<IMethodInstance> list) {
        List<ITestNGMethod> list2 = Lists.newArrayList();
        for (IMethodInstance iMethodInstance : list) {
            list2.add(iMethodInstance.getMethod());
        }
        return list2;
    }

    public static void dumpInvokedMethodsInfoToConsole(Collection<IInvokedMethod> collection, int n) {
        if (n < 3) {
            return;
        }
        System.out.println("===== Invoked methods");
        for (IInvokedMethod iInvokedMethod : collection) {
            if (iInvokedMethod.isTestMethod()) {
                System.out.print("    ");
            } else {
                if (!iInvokedMethod.isConfigurationMethod()) continue;
                System.out.print("  ");
            }
            System.out.println("" + iInvokedMethod);
        }
        System.out.println("=====");
    }

    protected static String calculateMethodCanonicalName(Class<?> clazz, String string) {
        Set<Method> set = ClassHelper.getAvailableMethods(clazz);
        Method method = null;
        for (Method method2 : set) {
            if (!string.equals(method2.getName())) continue;
            method = method2;
            break;
        }
        return method != null ? MethodHelper.calculateMethodCanonicalName(method) : null;
    }

    protected static long calculateTimeOut(ITestNGMethod iTestNGMethod) {
        long l = iTestNGMethod.getTimeOut() > 0L ? iTestNGMethod.getTimeOut() : iTestNGMethod.getInvocationTimeOut();
        return l;
    }

    private static MatchResults matchMethod(ITestNGMethod[] iTestNGMethodArray, String string) {
        MatchResults matchResults = new MatchResults();
        boolean bl = string.indexOf(46) != -1;
        Pattern pattern = Pattern.compile(string);
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            ConstructorOrMethod constructorOrMethod = iTestNGMethod.getConstructorOrMethod();
            String string2 = constructorOrMethod.getName();
            String string3 = bl ? MethodHelper.calculateMethodCanonicalName(iTestNGMethod) : string2;
            Pair<String, String> pair = Pair.create(string, string3);
            Boolean bl2 = MATCH_CACHE.get(pair);
            if (bl2 == null) {
                bl2 = pattern.matcher(string3).matches();
                MATCH_CACHE.put(pair, bl2);
            }
            if (!bl2.booleanValue()) continue;
            matchResults.matchedMethods.add(iTestNGMethod);
            matchResults.foundAtLeastAMethod = true;
        }
        return matchResults;
    }

    private static class MatchResults {
        private List<ITestNGMethod> matchedMethods = Lists.newArrayList();
        private boolean foundAtLeastAMethod = false;

        private MatchResults() {
        }
    }
}

