/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration;

import jakarta.validation.Configuration;
import jakarta.validation.Validator;
import jakarta.validation.metadata.BeanDescriptor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.Optional;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.Package;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.PrePosting;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.ValidPackage;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ConstraintDeclarationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ConstraintDeclarationTest.webArchiveBuilder().withTestClass(ConstraintDeclarationTest.class)).withClasses(Optional.class, Package.class, PrePosting.class, ValidPackage.class)).withValidationXml("validation-ConstraintDeclarationTest.xml")).withResource("package-constraints-ConstraintDeclarationTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="xml-mapping-constraintdeclarationinxml", id="d")
    public void testConstraintAnnotationsArePerDefaultIgnoredForXmlConfiguredEntities() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Package.class);
        Assert.assertFalse((boolean)beanDescriptor.isBeanConstrained(), (String)"With xml configuration there should be no constraint.");
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.ignoreXmlConfiguration();
        validator = config.buildValidatorFactory().getValidator();
        beanDescriptor = validator.getConstraintsForClass(Package.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"If xml configuration is ignored Package should have a single constraint.");
    }
}

