/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.Ignore;
import org.testng.internal.annotations.IAnnotationTransformer;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.util.Strings;

public class IgnoreListener
implements IAnnotationTransformer {
    @Override
    public void transform(ITestAnnotation iTestAnnotation, Class clazz, Constructor constructor, Method method) {
        if (!iTestAnnotation.getEnabled()) {
            return;
        }
        Class<?> clazz2 = clazz;
        if (method != null) {
            IgnoreListener.ignoreTest(iTestAnnotation, method.getAnnotation(Ignore.class));
            clazz2 = method.getDeclaringClass();
        }
        if (clazz2 != null) {
            IgnoreListener.ignoreTest(iTestAnnotation, ReflectionHelper.findAnnotation(clazz2, Ignore.class));
            Package package_ = clazz2.getPackage();
            if (package_ != null) {
                IgnoreListener.ignoreTest(iTestAnnotation, IgnoreListener.findAnnotation(package_));
            }
        }
    }

    private static void ignoreTest(ITestAnnotation iTestAnnotation, Ignore ignore) {
        if (ignore == null) {
            return;
        }
        iTestAnnotation.setEnabled(false);
        IgnoreListener.updateDescription(iTestAnnotation, ignore);
    }

    private static void updateDescription(ITestAnnotation iTestAnnotation, Ignore ignore) {
        if (ignore.value().isEmpty()) {
            return;
        }
        String string = iTestAnnotation.getDescription() == null || iTestAnnotation.getDescription().isEmpty() ? ignore.value() : ignore.value() + ": " + iTestAnnotation.getDescription();
        iTestAnnotation.setDescription(string);
    }

    private static Ignore findAnnotation(Package package_) {
        if (package_ == null) {
            return null;
        }
        Ignore ignore = package_.getAnnotation(Ignore.class);
        if (ignore != null) {
            return ignore;
        }
        String[] stringArray = package_.getName().split("\\.");
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length - 1);
        String string = Strings.join(".", stringArray2);
        if (string.isEmpty()) {
            return null;
        }
        return IgnoreListener.findAnnotation(Package.getPackage(string));
    }
}

