/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.delegation;

import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Instance;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="extractAndGroupAttribute", label="Extract and Group Attribute", description="In the metamodel, an attribute is extracted into a new class. This extracted class is contained by an existing container class and referenced from the context class. In the model, an instance of the extracted class is created for each different value of the extracted attribute.")
public class ExtractAndGroupAttribute
extends OperationImplementation {
    @EdaptParameter(main=true, description="The attribute to be extracted")
    public EAttribute extractedAttribute;
    @EdaptParameter(description="The package in which the extracted class is created")
    public EPackage contextPackage;
    @EdaptParameter(description="The name of the extracted class")
    public String extractedClassName;
    @EdaptParameter(description="The reference from the context class to the extracted class")
    public String referenceName;
    @EdaptParameter(description="The container class for the extracted class")
    public EClass containerClass;
    @EdaptParameter(description="The name of the containment reference from the container class to the extracted class")
    public String containerReferenceName;

    @EdaptConstraint(restricts="extractedAttribute", description="The extracted attribute must be single-valued")
    public boolean checkExtractedAttribute(EAttribute extractedAttribute) {
        return !extractedAttribute.isMany();
    }

    public void execute(Metamodel metamodel, Model model) {
        EClass contextClass = this.extractedAttribute.getEContainingClass();
        EClass extractedClass = MetamodelFactory.newEClass((EPackage)this.contextPackage, (String)this.extractedClassName);
        extractedClass.getEStructuralFeatures().add((Object)this.extractedAttribute);
        this.extractedAttribute.setLowerBound(1);
        EReference reference = MetamodelFactory.newEReference((EClass)contextClass, (String)this.referenceName, (EClass)extractedClass, (int)0, (int)1, (boolean)false);
        EReference containerReference = MetamodelFactory.newEReference((EClass)this.containerClass, (String)this.containerReferenceName, (EClass)extractedClass, (int)0, (int)-1, (boolean)true);
        for (Instance contextElement : model.getAllInstances(contextClass)) {
            Object value = contextElement.unset((EStructuralFeature)this.extractedAttribute);
            if (value == null) continue;
            Instance containerElement = contextElement;
            while (containerElement != null && !containerElement.instanceOf(this.containerClass)) {
                containerElement = containerElement.getContainer();
            }
            if (containerElement == null) continue;
            Instance extractedElement = this.getExtractedElement(containerElement, containerReference, this.extractedAttribute, value);
            if (extractedElement == null) {
                extractedElement = model.newInstance(extractedClass);
                extractedElement.set((EStructuralFeature)this.extractedAttribute, value);
                containerElement.add((EStructuralFeature)containerReference, (Object)extractedElement);
            }
            contextElement.set((EStructuralFeature)reference, (Object)extractedElement);
        }
    }

    private Instance getExtractedElement(Instance containerElement, EReference containerReference, EAttribute extractedAttribute, Object value) {
        List elements = (List)containerElement.get((EStructuralFeature)containerReference);
        for (Instance element : elements) {
            if (!value.equals(element.get((EStructuralFeature)extractedAttribute))) continue;
            return element;
        }
        return null;
    }
}

