/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.replacement;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="operationToVolatile", label="Operation to Volatile Feature", description="In the metamodel, an operation is transformed into a volatile feature. In the model, nothing needs to be done.")
public class OperationToVolatile
extends OperationImplementation {
    @EdaptParameter(main=true, description="The operation to be transformed")
    public EOperation operation;

    @EdaptConstraint(description="The operation must not have parameters")
    public boolean checkCustomPreconditions() {
        return this.operation.getEParameters().isEmpty();
    }

    public void execute(Metamodel metamodel, Model model) {
        EClass eClass = this.operation.getEContainingClass();
        EClassifier type = this.operation.getEType();
        String name = this.operation.getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
            name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
        }
        Object feature = null;
        feature = type instanceof EClass ? MetamodelFactory.newEReference((EClass)eClass, (String)name, (EClass)((EClass)type), (int)this.operation.getLowerBound(), (int)this.operation.getUpperBound()) : MetamodelFactory.newEAttribute((EClass)eClass, (String)name, (EDataType)((EDataType)type), (int)this.operation.getLowerBound(), (int)this.operation.getUpperBound());
        feature.setVolatile(true);
        feature.setTransient(true);
        feature.setDerived(true);
        feature.setChangeable(false);
        metamodel.delete((EModelElement)this.operation);
    }
}

