/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.java;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.eclipse.comma.java.JClassInfo;
import org.eclipse.comma.java.JClassInfos;
import org.eclipse.comma.java.JDependencyInfo;
import org.eclipse.comma.java.JDependencyInfos;
import org.eclipse.comma.java.JSourceInfo;
import org.eclipse.comma.java.JSourceInfos;
import org.eclipse.comma.java.impl.JClassInfoImpl;

public class JCompiler {
    private final List<JSourceInfo> sourceInfos;
    private final List<JDependencyInfo> dependencyInfos;
    private final List<String> options;
    private File targetDir;

    protected JCompiler(List<JSourceInfo> sourceInfos, List<JDependencyInfo> dependencyInfos, List<String> options) {
        this.sourceInfos = Objects.requireNonNull(sourceInfos, "sourceInfos must not be null");
        this.dependencyInfos = Objects.requireNonNull(dependencyInfos, "dependencyInfos must not be null");
        this.options = Objects.requireNonNull(options, "options must not be null");
    }

    public JCompiler(int sourceInfosSize, int dependencyInfosSize, int optionsSize) {
        this(new ArrayList<JSourceInfo>(sourceInfosSize), new ArrayList<JDependencyInfo>(dependencyInfosSize), new ArrayList<String>(optionsSize));
    }

    public JCompiler() {
        this(10, 5, 5);
    }

    public JCompiler withSourceInfos(JSourceInfo ... sourceInfos) {
        JSourceInfo[] jSourceInfoArray = sourceInfos;
        int n = sourceInfos.length;
        int n2 = 0;
        while (n2 < n) {
            JSourceInfo sInfo = jSourceInfoArray[n2];
            if (!JSourceInfos.isJavaSource(sInfo)) {
                throw new IllegalArgumentException("adding sourceInfo '" + sInfo.getLocation() + "' failed - is not a java source");
            }
            this.sourceInfos.add(sInfo);
            ++n2;
        }
        return this;
    }

    public JCompiler withSourceInfos(Collection<JSourceInfo> sourceInfos) {
        sourceInfos.forEach(s -> {
            JCompiler jCompiler = this.withSourceInfos((JSourceInfo)s);
        });
        return this;
    }

    public JCompiler withDependencyInfos(JDependencyInfo ... dependencyInfos) {
        JDependencyInfo[] jDependencyInfoArray = dependencyInfos;
        int n = dependencyInfos.length;
        int n2 = 0;
        while (n2 < n) {
            JDependencyInfo dInfo = jDependencyInfoArray[n2];
            Objects.requireNonNull(dInfo, "dependencyInfo must not be null");
            this.dependencyInfos.add(dInfo);
            ++n2;
        }
        return this;
    }

    public JCompiler withDependencyInfos(Collection<JDependencyInfo> dependencyInfos) {
        dependencyInfos.forEach(d -> {
            JCompiler jCompiler = this.withDependencyInfos((JDependencyInfo)d);
        });
        return this;
    }

    public JCompiler withOptions(String ... options) {
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            this.options.add(Objects.requireNonNull(o, "option must not be null"));
            ++n2;
        }
        return this;
    }

    public JCompiler withOptions(Collection<String> options) {
        options.forEach(o -> {
            JCompiler jCompiler = this.withOptions((String)o);
        });
        return this;
    }

    public List<JClassInfo> compile() throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new IOException("ToolProvider.getSystemJavaCompiler() returns null - Could not get java compiler, please make sure your application is running with a jdk and not jre.");
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        this.createTargetDir();
        List files = this.sourceInfos.stream().filter(s -> JSourceInfos.isJavaSource(s)).map(s -> s.getLocation()).collect(Collectors.toList());
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
        List<String> options = this.createOptions();
        boolean success = compiler.getTask(null, fileManager, null, options, null, compilationUnits).call();
        if (!success) {
            throw new IllegalArgumentException("compile failed");
        }
        ArrayList<JClassInfo> classInfos = new ArrayList<JClassInfo>(files.size());
        for (JavaFileObject jfo : fileManager.list(StandardLocation.CLASS_OUTPUT, "", Collections.singleton(JavaFileObject.Kind.CLASS), true)) {
            classInfos.add(new JClassInfoImpl(new File(jfo.getName()), JClassInfos.getName(this.targetDir, jfo.getName())));
        }
        return classInfos;
    }

    private void createTargetDir() throws IOException {
        this.targetDir = Files.createTempDirectory("comma-jcompiler-target-", new FileAttribute[0]).toFile();
    }

    private List<String> createOptions() {
        ArrayList<String> tOptions = new ArrayList<String>(this.dependencyInfos.size() + this.options.size() + 4);
        tOptions.add("-d");
        tOptions.add(this.targetDir.getAbsolutePath());
        if (!this.dependencyInfos.isEmpty()) {
            tOptions.add("-classpath");
            tOptions.add(JDependencyInfos.toClasspath(this.dependencyInfos));
        }
        tOptions.addAll(this.options);
        return tOptions;
    }
}

