/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.ui.handler;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.plantuml.SourceFileReader;
import org.eclipse.comma.java.JArtifactInfo;
import org.eclipse.comma.java.JArtifactInfoBuilder;
import org.eclipse.comma.java.JCmd;
import org.eclipse.comma.java.JCmdBuilder;
import org.eclipse.comma.java.JCmdExecutor;
import org.eclipse.comma.java.JCompiler;
import org.eclipse.comma.java.JDependencyInfo;
import org.eclipse.comma.java.JDependencyInfos;
import org.eclipse.comma.java.JProcessMonitor;
import org.eclipse.comma.java.JSourceInfos;
import org.eclipse.comma.java.impl.JArtifactInfoImpl;
import org.eclipse.comma.project.ui.handler.ProjectUIGenerator;
import org.eclipse.comma.project.ui.handler.ProjectUIGeneratorJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.validation.IResourceValidator;

abstract class LaunchShortcut
implements ILaunchShortcut {
    private static final Logger LOGGER = Logger.getLogger(LaunchShortcut.class.getName());
    private static final String COMMA_CONSOLE = "Comma Console";
    private static final String MONITORING_BUNDLE = "org.eclipse.comma.monitoring.lib";
    private static final String GSON_BUNDLE = "com.google.gson";
    private static final String DASHBOARD_BUNDLE = "org.eclipse.comma.monitoring.dashboard";
    private static final String MONITOR_MAIN_CLASS = "org.eclipse.comma.monitoring.generated.ScenarioPlayer";
    private static final String GENERATED_JAR_NAME = "/Player.jar";
    @Inject
    private IGenerator2 generator;
    @Inject
    private Provider<EclipseResourceFileSystemAccess2> fileAccessProvider;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    private EclipseOutputConfigurationProvider outputConfigurationProvider;
    @Inject
    private IResourceValidator validator;

    LaunchShortcut() {
    }

    @Inject
    public void setOutputConfigurationProvider(EclipseOutputConfigurationProvider outputConfigurationProvider) {
        this.outputConfigurationProvider = outputConfigurationProvider;
    }

    public void launch(ISelection selection, String mode) {
        LOGGER.info("launching from selection: " + selection + " in mode: " + mode);
        IStructuredSelection sel = (IStructuredSelection)selection;
        Object[] objectArray = sel.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            IFile f = (IFile)file;
            this.generateThenLaunch(f, mode);
            ++n2;
        }
    }

    public void launch(IEditorPart editor, String mode) {
        LOGGER.info("launching from editor: " + editor.getTitle() + " in mode: " + mode);
        this.generateThenLaunch(((IFileEditorInput)editor.getEditorInput()).getFile(), mode);
    }

    private void generateThenLaunch(IFile projectFile, String mode) {
        IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        boolean taskSelection = this.getLaunchFile() == ProjectUIGenerator.LaunchFile.GENERATORS_TASK_SELECTION;
        ProjectUIGeneratorJob job = new ProjectUIGeneratorJob(this.getMessage(), projectFile, this.generator, (EclipseResourceFileSystemAccess2)this.fileAccessProvider.get(), this.resourceSetProvider, this.outputConfigurationProvider, this.validator, workbench.getShell(), this, mode, this.getLaunchFile(), taskSelection);
        job.schedule();
    }

    abstract ProjectUIGenerator.LaunchFile getLaunchFile();

    abstract String getMessage();

    protected void launchMonitor(IFile file, String mode) {
        try {
            File projectAbsolutePath = new File(file.getLocation().removeLastSegments(8).toString());
            String javaSourcePath = file.getLocation().removeLastSegments(6).toString();
            MessageConsole console = this.findConsole(COMMA_CONSOLE);
            MessageConsoleStream out = console.newMessageStream();
            Runnable compileAndRunJava = () -> {
                try {
                    Set generatedSourceInfos = JSourceInfos.getJavaSourcesFromSrcDirectory((String)javaSourcePath);
                    JDependencyInfo runtimeLibDependency = JDependencyInfos.getDependencyFromBundleId((String)MONITORING_BUNDLE);
                    JDependencyInfo gsonDependency = JDependencyInfos.getDependencyFromBundleId((String)GSON_BUNDLE);
                    JDependencyInfo dashboardDependency = JDependencyInfos.getDependencyFromBundleId((String)DASHBOARD_BUNDLE);
                    File plantumlJar = new File(SourceFileReader.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    JDependencyInfo plantumlDependency = JDependencyInfos.create((File)plantumlJar);
                    JCompiler compiler = new JCompiler().withSourceInfos((Collection)generatedSourceInfos).withDependencyInfos(new JDependencyInfo[]{runtimeLibDependency}).withDependencyInfos(new JDependencyInfo[]{dashboardDependency}).withDependencyInfos(new JDependencyInfo[]{plantumlDependency}).withDependencyInfos(new JDependencyInfo[]{gsonDependency});
                    out.println("Compiling and building generated code ...");
                    List classInfos = compiler.compile();
                    JArtifactInfo artifactInfo = new JArtifactInfoBuilder().withArchiveFile(new File(String.valueOf(javaSourcePath) + GENERATED_JAR_NAME)).withClassInfos((Collection)classInfos).withDependencyInfos(new JDependencyInfo[]{runtimeLibDependency}).withDependencyInfos(new JDependencyInfo[]{gsonDependency}).withDependencyInfos(new JDependencyInfo[]{dashboardDependency}).withDependencyInfos(new JDependencyInfo[]{plantumlDependency}).withMainClass(MONITOR_MAIN_CLASS).build();
                    JCmd cmd = new JCmdBuilder().withArtifactInfo(artifactInfo).build();
                    out.println("Executing monitoring tasks...");
                    JProcessMonitor monitor = new JCmdExecutor(cmd).withWorkingDirectory(projectAbsolutePath).withOnStdOut(line -> out.print(line)).execute();
                    monitor.process.waitFor();
                    if (!monitor.getStdErr().isEmpty()) {
                        System.out.println("Error occurred during compilation and execution:");
                        System.out.print(monitor.getStdErr());
                    } else {
                        out.println("Finished executing monitoring tasks in " + monitor.getExecutionTime() + " secs");
                    }
                    file.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (IOException | IllegalArgumentException | InterruptedException | URISyntaxException | CoreException e) {
                    e.printStackTrace(new PrintStream((OutputStream)out));
                }
            };
            Thread executor = new Thread(compileAndRunJava);
            executor.start();
        }
        catch (PartInitException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }

    protected void launchSimulator(IFile file) {
        try {
            MessageConsole console = this.findConsole(COMMA_CONSOLE);
            MessageConsoleStream out = console.newMessageStream();
            MessageConsoleStream err = console.newMessageStream();
            err.setColor(new Color(255, 0, 0));
            Runnable runSimulator = () -> {
                try {
                    JArtifactInfoImpl artifactInfo = new JArtifactInfoImpl(null, file.getLocation().toFile(), null, "org.eclipse.comma.simulator.Window", false);
                    JCmd cmd = new JCmdBuilder().withArtifactInfo((JArtifactInfo)artifactInfo).build();
                    JProcessMonitor monitor = new JCmdExecutor(cmd).execute();
                    int code = monitor.process.waitFor();
                    if (code != 0) {
                        err.println("Simulator failed with exit code " + code);
                        err.print(monitor.getStdErr());
                    }
                }
                catch (IOException | IllegalArgumentException | InterruptedException e) {
                    e.printStackTrace(new PrintStream((OutputStream)out));
                }
            };
            Thread executor = new Thread(runSimulator);
            executor.start();
        }
        catch (PartInitException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private MessageConsole findConsole(String name) throws PartInitException {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager manager = plugin.getConsoleManager();
        IConsole[] existing = manager.getConsoles();
        MessageConsole myConsole = null;
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                myConsole = (MessageConsole)existing[i];
            }
            ++i;
        }
        if (myConsole == null) {
            myConsole = new MessageConsole(name, null);
            manager.addConsoles(new IConsole[]{myConsole});
        }
        IWorkbenchWindow workbench = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbench.getActivePage();
        String id = "org.eclipse.ui.console.ConsoleView";
        IConsoleView view = (IConsoleView)page.showView(id);
        view.display((IConsole)myConsole);
        myConsole.clearConsole();
        return myConsole;
    }
}

