/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.simulator;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.EClause;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.EComponentState;
import org.eclipse.comma.evaluator.EConnection;
import org.eclipse.comma.evaluator.EHelper;
import org.eclipse.comma.evaluator.EIConstraint;
import org.eclipse.comma.evaluator.EIState;
import org.eclipse.comma.evaluator.EInterfaceState;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.evaluator.ETransition;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.simulator.Action;
import org.eclipse.comma.simulator.Helper;
import org.eclipse.comma.simulator.Model;
import org.eclipse.comma.simulator.SimulatorState;
import org.eclipse.comma.simulator.Step;

public class Window {
    private List<Action> actions = new ArrayList<Action>();
    private List<Step> possibleStepsWithoutAction = new ArrayList<Step>();
    private String logSeparator = "---------------------------------------\n";
    private Stack<EIState> states = new Stack();
    private String log = "";
    private SimulatorState savedState = null;
    private Font defaultFont = new Font("Tahoma", 0, 12);
    private Font logFont = new Font("Courier New", 0, 12);
    private Font titlefont = new Font("Tahoma", 0, 14);
    private Dimension dimensionMaxWidth = new Dimension(Short.MAX_VALUE, 0);
    private JFrame frame;
    private Model model = Model.load();
    private JPanel panelClientActions;
    private JPanel panelServerActions;
    private JButton btnLogVariables;
    private JButton btnLogStates;
    private JButton btnStepBack;
    private JButton btnSaveState;
    private JButton btnRestoreState;
    private JButton btnReset;
    private JPanel panelAction;
    private JTextPane txtLog;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    Window window = new Window();
                    window.frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Window() {
        this.states.add(this.model.initialState);
        this.initializeUI();
        this.initializeActions();
        this.initializeButtonActionListeners();
        this.discoverPossibleSteps();
        this.updateUI();
    }

    private void initializeButtonActionListeners() {
        this.btnLogStates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.log = String.valueOf(Window.this.log) + "States:\n";
                BiConsumer<EInterfaceState, String> logInterfaceState = (s, prefix) -> {
                    for (State state : s.getStates()) {
                        Window.this.log = String.valueOf(Window.this.log) + String.format(" - %s%s: %s\n", prefix, Helper.stateMachineName(state), state.getName());
                    }
                };
                if (Window.this.states.lastElement() instanceof EInterfaceState) {
                    logInterfaceState.accept((EInterfaceState)Window.this.states.lastElement(), "");
                } else {
                    for (Map.Entry entry : ((EComponentState)Window.this.states.lastElement()).connections.entrySet()) {
                        logInterfaceState.accept((EInterfaceState)entry.getValue(), String.valueOf(EHelper.connectionToString((EConnection)((EConnection)entry.getKey()))) + ".");
                    }
                }
                Window.this.log = String.valueOf(Window.this.log) + Window.this.logSeparator;
                Window.this.updateUI();
            }
        });
        this.btnLogVariables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.log = String.valueOf(Window.this.log) + "Variables: \n";
                Consumer<EVariableCollection> logVariables = c -> {
                    if (c == null || c.allNamesSorted().isEmpty()) {
                        Window.this.log = String.valueOf(Window.this.log) + " (no variables)\n";
                    } else {
                        Window.this.log = String.valueOf(Window.this.log) + "\n";
                        for (String name : c.allNamesSorted()) {
                            Window.this.log = String.valueOf(Window.this.log) + "      " + name + ": " + EHelper.variableToString((EVariable)c.get(name)) + "\n";
                        }
                    }
                };
                Consumer<EInterfaceState> logInterfaceState = s -> {
                    Window.this.log = String.valueOf(Window.this.log) + "    Global variables";
                    logVariables.accept(s.globalVariables);
                    Window.this.log = String.valueOf(Window.this.log) + "    Local variables";
                    logVariables.accept(s.localVariables);
                };
                if (Window.this.states.lastElement() instanceof EInterfaceState) {
                    Window.this.log = String.valueOf(Window.this.log) + "  Interface: " + ((EInterfaceState)Window.this.states.lastElement()).interfaceName + "\n";
                    logInterfaceState.accept((EInterfaceState)Window.this.states.lastElement());
                } else {
                    for (Map.Entry entry : ((EComponentState)Window.this.states.lastElement()).connections.entrySet()) {
                        Window.this.log = String.valueOf(Window.this.log) + String.format("  Interface: %s.%s\n", ((EInterfaceState)entry.getValue()).interfaceName, EHelper.connectionToString((EConnection)((EConnection)entry.getKey())));
                        logInterfaceState.accept((EInterfaceState)entry.getValue());
                    }
                    for (EIConstraint eIConstraint : ((EComponentState)Window.this.states.lastElement()).constraints) {
                        Window.this.log = String.valueOf(Window.this.log) + "  Constraint: " + eIConstraint.getName();
                        logVariables.accept(eIConstraint.getVariables());
                    }
                }
                Window.this.log = String.valueOf(Window.this.log) + Window.this.logSeparator;
                Window.this.updateUI();
            }
        });
        this.btnStepBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.states.pop();
                Window.this.log = String.valueOf(Window.this.log) + "Stepped back to step #" + (Window.this.states.size() - 1) + "\n";
                Window.this.log = String.valueOf(Window.this.log) + Window.this.logSeparator;
                Window.this.discoverPossibleSteps();
                Window.this.updateUI();
            }
        });
        this.btnSaveState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.log = String.valueOf(Window.this.log) + "Saved state\n";
                Window.this.log = String.valueOf(Window.this.log) + Window.this.logSeparator;
                Window.this.savedState = new SimulatorState(Window.this.states, Window.this.log);
                Window.this.updateUI();
            }
        });
        this.btnRestoreState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.log = Window.this.savedState.log;
                Window.this.states = Window.this.savedState.getStates();
                Window.this.log = String.valueOf(Window.this.log) + "Restored state\n";
                Window.this.log = String.valueOf(Window.this.log) + Window.this.logSeparator;
                Window.this.discoverPossibleSteps();
                Window.this.updateUI();
            }
        });
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window.this.states.removeIf(s -> Window.this.states.indexOf(s) > 0);
                Window.this.log = "";
                Window.this.savedState = null;
                Window.this.discoverPossibleSteps();
                Window.this.updateUI();
            }
        });
    }

    private void discoverPossibleSteps() {
        this.possibleStepsWithoutAction.clear();
        this.actions.forEach(e -> {
            e.possibleSteps.clear();
            e.selected = false;
        });
        Consumer<Step> add = step -> {
            if (step.to.getActions().isEmpty()) {
                this.possibleStepsWithoutAction.add((Step)step);
            } else {
                for (Action action : this.actions) {
                    if (!step.to.getActions().stream().anyMatch(a -> action.isApplicable(a))) continue;
                    action.possibleSteps.add((Step)step);
                }
            }
        };
        EIState state = (EIState)this.states.lastElement();
        if (!state.inTransition()) {
            for (ETransition transition : state.possibleTransitions()) {
                if (transition.transition instanceof TriggeredTransition) {
                    for (EVariableCollection parameters : this.model.parameterCollection.getParameters(transition)) {
                        EIState nextState;
                        if (!state.isTransitionPossibleWithParameters(transition, parameters) || (nextState = state.takeTransition(transition, parameters)).possibleClauses().isEmpty()) continue;
                        add.accept(new Step(state, transition, nextState, parameters));
                    }
                    continue;
                }
                EIState nextState = state.takeTransition(transition, null);
                for (EClause clause : nextState.possibleClauses()) {
                    add.accept(new Step(nextState, clause, nextState.takeClause(clause), null));
                }
            }
        } else {
            for (EClause clause : state.possibleClauses()) {
                add.accept(new Step(state, clause, state.takeClause(clause), null));
            }
        }
    }

    private void updateUI() {
        this.btnStepBack.setEnabled(this.states.size() > 1);
        this.txtLog.setText(this.log);
        this.actions.forEach(e -> e.updateUI());
        this.btnRestoreState.setEnabled(this.savedState != null);
        Optional<Action> selectedEntry = this.actions.stream().filter(e -> e.selected).findFirst();
        this.panelAction.removeAll();
        this.panelAction.repaint();
        if (selectedEntry.isPresent() || !this.possibleStepsWithoutAction.isEmpty()) {
            List<Step> steps = selectedEntry.isPresent() ? selectedEntry.get().possibleSteps : this.possibleStepsWithoutAction;
            for (final Step step : steps) {
                JButton button = new JButton(step.getButtonText());
                button.setFont(this.defaultFont);
                button.setHorizontalAlignment(2);
                button.setMaximumSize(new Dimension(9999, button.getText().split("<br>").length * 13 + 13));
                this.panelAction.add(button);
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Window.this.takeStep(step);
                    }
                });
            }
        } else {
            JLabel field = new JLabel("Select an action..");
            field.setFont(this.defaultFont);
            field.setBackground(this.panelAction.getBackground());
            this.panelAction.add(field);
        }
        this.panelAction.validate();
    }

    private void takeStep(Step step) {
        this.states.add(step.to);
        String type = step.eTransitionOrClause.getClass().getSimpleName().toLowerCase().substring(1);
        this.log = String.valueOf(this.log) + String.format("Executed %s (step #%d):\n", type, this.states.size() - 1);
        for (EAction action : ((EIState)this.states.lastElement()).getActions()) {
            this.log = String.valueOf(this.log) + "- " + Helper.actionToSymbol(action) + ": " + Helper.actionToString(action, step.parameters) + "\n";
        }
        this.log = String.valueOf(this.log) + this.logSeparator;
        this.discoverPossibleSteps();
        this.updateUI();
    }

    private void initializeActions() {
        for (Map.Entry<EAction, String> entry : this.model.actions.entrySet()) {
            Action action = new Action(entry.getKey());
            String signature = this.model.isComponent ? String.valueOf(entry.getValue()) + "." : "";
            action.button.setText(String.format("%s: %s%s()", Helper.actionToSymbol(entry.getKey()), signature, Helper.getMethodName(entry.getKey())));
            if (entry.getKey() instanceof ECommand || entry.getKey() instanceof ESignal) {
                this.panelClientActions.add(action.button);
            } else {
                this.panelServerActions.add(action.button);
            }
            action.button.setMaximumSize(new Dimension(9999, 30));
            action.button.setFont(this.defaultFont);
            action.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Window.this.actions.forEach(ee -> {
                        boolean bl = ee.selected = ee.button == e.getSource() && !ee.selected;
                    });
                    Window.this.updateUI();
                }
            });
            this.actions.add(action);
        }
    }

    private void initializeUI() {
        this.frame = new JFrame();
        if (this.model != null) {
            this.frame.setTitle(String.format("%s simulator", this.model.name));
        }
        this.frame.setBounds(100, 100, 1032, 524);
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 0));
        JPanel panelClient = new JPanel();
        this.frame.getContentPane().add(panelClient);
        panelClient.setMinimumSize(new Dimension(200, Short.MAX_VALUE));
        panelClient.setPreferredSize(new Dimension(200, Short.MAX_VALUE));
        panelClient.setMaximumSize(new Dimension(200, Short.MAX_VALUE));
        panelClient.setLayout(new BoxLayout(panelClient, 1));
        JLabel lblClient = new JLabel("Client");
        lblClient.setFont(this.titlefont);
        lblClient.setAlignmentX(0.5f);
        panelClient.add(lblClient);
        JScrollPane scrollPaneClient = new JScrollPane();
        scrollPaneClient.setVerticalScrollBarPolicy(22);
        scrollPaneClient.setHorizontalScrollBarPolicy(31);
        panelClient.add(scrollPaneClient);
        this.panelClientActions = new JPanel();
        scrollPaneClient.setViewportView(this.panelClientActions);
        this.panelClientActions.setLayout(new BoxLayout(this.panelClientActions, 1));
        JPanel panelServer = new JPanel();
        this.frame.getContentPane().add(panelServer);
        panelServer.setMinimumSize(new Dimension(200, Short.MAX_VALUE));
        panelServer.setPreferredSize(new Dimension(200, Short.MAX_VALUE));
        panelServer.setMaximumSize(new Dimension(200, Short.MAX_VALUE));
        panelServer.setLayout(new BoxLayout(panelServer, 1));
        JLabel lblServer = new JLabel("Server");
        lblServer.setAlignmentX(0.5f);
        lblServer.setFont(this.titlefont);
        panelServer.add(lblServer);
        JScrollPane scrollPaneServer = new JScrollPane();
        scrollPaneServer.setVerticalScrollBarPolicy(22);
        scrollPaneServer.setHorizontalScrollBarPolicy(31);
        panelServer.add(scrollPaneServer);
        this.panelServerActions = new JPanel();
        scrollPaneServer.add(this.panelServerActions);
        scrollPaneServer.setViewportView(this.panelServerActions);
        this.panelServerActions.setLayout(new BoxLayout(this.panelServerActions, 1));
        JPanel panelActionControls = new JPanel();
        this.frame.getContentPane().add(panelActionControls);
        panelActionControls.setMinimumSize(new Dimension(300, Short.MAX_VALUE));
        panelActionControls.setPreferredSize(new Dimension(300, Short.MAX_VALUE));
        panelActionControls.setMaximumSize(new Dimension(300, Short.MAX_VALUE));
        panelActionControls.setLayout(new BoxLayout(panelActionControls, 1));
        JLabel lblAction = new JLabel("Action(s)");
        lblAction.setAlignmentX(0.5f);
        lblAction.setFont(this.titlefont);
        panelActionControls.add(lblAction);
        this.panelAction = new JPanel();
        this.panelAction.setLayout(new BoxLayout(this.panelAction, 1));
        JScrollPane scrollPaneAction = new JScrollPane(this.panelAction);
        scrollPaneAction.setVerticalScrollBarPolicy(22);
        panelActionControls.add(scrollPaneAction);
        JLabel lblControls = new JLabel("Controls");
        lblControls.setAlignmentX(0.5f);
        lblControls.setFont(this.titlefont);
        panelActionControls.add(lblControls);
        JPanel panelControls = new JPanel();
        panelActionControls.add(panelControls);
        panelControls.setLayout(new GridLayout(3, 2, 0, 0));
        panelControls.setMaximumSize(this.dimensionMaxWidth);
        this.btnLogStates = new JButton("Log states");
        this.btnLogStates.setFont(this.defaultFont);
        this.btnLogStates.setMaximumSize(this.dimensionMaxWidth);
        panelControls.add(this.btnLogStates);
        this.btnLogVariables = new JButton("Log variables");
        this.btnLogVariables.setFont(this.defaultFont);
        this.btnLogVariables.setMaximumSize(this.dimensionMaxWidth);
        panelControls.add(this.btnLogVariables);
        this.btnStepBack = new JButton("Step back");
        this.btnStepBack.setFont(this.defaultFont);
        this.btnStepBack.setMaximumSize(this.dimensionMaxWidth);
        panelControls.add(this.btnStepBack);
        this.btnReset = new JButton("Reset");
        this.btnReset.setFont(this.defaultFont);
        this.btnReset.setMaximumSize(this.dimensionMaxWidth);
        panelControls.add(this.btnReset);
        this.btnSaveState = new JButton("Save state");
        this.btnSaveState.setFont(this.defaultFont);
        this.btnSaveState.setMaximumSize(this.dimensionMaxWidth);
        panelControls.add(this.btnSaveState);
        this.btnRestoreState = new JButton("Restore state");
        this.btnRestoreState.setFont(this.defaultFont);
        this.btnRestoreState.setMaximumSize(this.dimensionMaxWidth);
        panelControls.add(this.btnRestoreState);
        JPanel panelLog = new JPanel();
        this.frame.getContentPane().add(panelLog);
        panelLog.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        panelLog.setLayout(new BoxLayout(panelLog, 1));
        JLabel lblLog = new JLabel("Log");
        lblLog.setFont(this.titlefont);
        lblLog.setAlignmentX(0.5f);
        panelLog.add(lblLog);
        this.txtLog = new JTextPane();
        this.txtLog.setEditable(false);
        this.txtLog.setFont(this.logFont);
        JScrollPane scrollPaneTxtLog = new JScrollPane(this.txtLog);
        scrollPaneTxtLog.setVerticalScrollBarPolicy(22);
        panelLog.add(scrollPaneTxtLog);
    }
}

