/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.reachabilitygraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.InAllStatesBlock;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.emf.ecore.EObject;

public class BuilderDebugLog {
    private List<Entry> entries = new ArrayList<Entry>();
    private List<Clause> clausesID = new ArrayList<Clause>();
    private Set<Clause> coveredClauses;

    public void add(int indent, String text) {
        this.entries.add(new Entry(indent, text));
    }

    public void appendToLast(String text) {
        this.entries.get((int)(this.entries.size() - 1)).text = String.valueOf(this.entries.get((int)(this.entries.size() - 1)).text) + text;
    }

    public void setCoveredClauses(Set<Clause> coveredClauses) {
        this.coveredClauses = coveredClauses;
    }

    public int clauseID(Clause clause) {
        if (!this.clausesID.contains(clause)) {
            this.clausesID.add(clause);
        }
        return this.clausesID.indexOf(clause);
    }

    public String toString() {
        String result = "";
        result = String.valueOf(result) + "Legend: S=State, T=Transition, C=Clause.\nThe number after C a unique ID, the lookup at the bottom shows the actions of the clause.\nWith each new S (State) the depth is increased by one.\nEdges are only added to the graph when a full sequence of S -> T -> C can be made (look for 'adding to graph').\nWhenever you see 'Done' in the line; traversal is stopped; the line will include the reason for it.\n\n\n";
        for (Entry entry : this.entries) {
            result = String.valueOf(result) + String.format("%s%s\n", "  ".repeat(entry.indent), entry.text);
        }
        List coveredClausesSorted = this.coveredClauses.stream().collect(Collectors.toList());
        Collections.sort(coveredClausesSorted, new Comparator<Clause>(){

            @Override
            public int compare(Clause c1, Clause c2) {
                return BuilderDebugLog.this.clauseID(c1) - BuilderDebugLog.this.clauseID(c2);
            }
        });
        result = String.valueOf(result) + "\n\n";
        for (Clause clause : coveredClausesSorted) {
            String trigger = clause.eContainer() instanceof TriggeredTransition ? ((TriggeredTransition)clause.eContainer()).getTrigger().getName() : "NonTriggered";
            EObject state = clause.eContainer().eContainer();
            String stateStr = state instanceof InAllStatesBlock ? "InAllStates" : ((State)state).getName();
            StateMachine machine = (StateMachine)state.eContainer();
            Interface itf = (Interface)machine.eContainer();
            String clauseStr = clause.getActions() == null ? "" : String.join((CharSequence)" - ", clause.getActions().getActions().stream().map(a -> {
                if (a instanceof CommandReply) {
                    return "Reply";
                }
                if (a instanceof EventCall) {
                    return ((EventCall)a).getEvent().getName();
                }
                return "";
            }).filter(e -> !e.isEmpty()).collect(Collectors.toList()));
            result = String.valueOf(result) + String.format("- %d: %s.%s.%s - %s\n", this.clauseID(clause), itf.getName(), stateStr, trigger, clauseStr);
        }
        return result.strip();
    }

    class Entry {
        int indent;
        String text;

        Entry(int indent, String text) {
            this.indent = indent;
            this.text = text;
        }
    }
}

