/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Paths;
import org.eclipse.comma.project.generatortasks.GeneratorTask;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.project.ComponentReference;
import org.eclipse.comma.project.project.ExecutableSource;
import org.eclipse.comma.project.project.TestGenerationTask;
import org.eclipse.comma.reachabilitygraph.ReachabilityGraph;
import org.eclipse.comma.testgeneration.JavaTestCases;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class TestGeneratorTask
extends GeneratorTask {
    protected final TestGenerationTask task;
    protected final IScopeProvider scopeProvider;
    protected final IFileSystemAccess2 fsa;
    protected CommaFileSystemAccess libFileSystemAccess;

    public TestGeneratorTask(TestGenerationTask task, IScopeProvider scopeProvider, OutputLocator outputLocator, IFileSystemAccess2 fsa) {
        super(task, scopeProvider, outputLocator, fsa);
        this.task = task;
        this.scopeProvider = scopeProvider;
        this.fsa = fsa;
    }

    @Override
    protected void doGenerate() {
        try {
            boolean _not;
            ExecutableSource target = this.task.getJsonReachabilityGraphTask().getTask().getTarget();
            String name = null;
            name = target instanceof ComponentReference ? ((ComponentReference)target).getComponent().getName() : this.getInterface(target).getName();
            String jsonPath = ReachabilityGraph.fsaOutputPath((String)name);
            boolean _isFile = this.fsa.isFile(jsonPath);
            boolean bl = _not = !_isFile;
            if (_not) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Input \"");
                _builder.append(jsonPath);
                _builder.append("\" does not exist");
                throw new Exception(_builder.toString());
            }
            String jsonText = this.fsa.readTextFile(jsonPath).toString();
            ReachabilityGraph graph = ReachabilityGraph.fromJSON((String)jsonText);
            boolean _isJava = this.task.isJava();
            if (_isJava) {
                boolean _tripleNotEquals;
                String testCases = JavaTestCases.generate((ReachabilityGraph)graph, (String)name);
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("test/");
                _builder_1.append(name);
                _builder_1.append("/TestCases.java");
                this.fsa.generateFile(_builder_1.toString(), (CharSequence)testCases);
                String _javaOutput = this.task.getJavaOutput();
                boolean bl2 = _tripleNotEquals = _javaOutput != null;
                if (_tripleNotEquals) {
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    String _platformString = this.fsa.getURI(".").toPlatformString(true);
                    Path root = new Path(_platformString);
                    String srcGenPath = wsRoot.getFile((IPath)root).getLocation().toFile().getPath();
                    File outputFile = Paths.get(srcGenPath, "..", this.task.getJavaOutput()).toFile();
                    PrintWriter writer = new PrintWriter(outputFile, "UTF-8");
                    writer.print(testCases);
                    writer.close();
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

