/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.comma.monitoring.lib.CComponentMonitor;
import org.eclipse.comma.monitoring.lib.CComponentMonitoringContext;
import org.eclipse.comma.monitoring.lib.CDispatcher;
import org.eclipse.comma.monitoring.lib.CDissectedMessage;
import org.eclipse.comma.monitoring.lib.CFactory;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitor;
import org.eclipse.comma.monitoring.lib.CMonitorResults;
import org.eclipse.comma.monitoring.lib.messages.CObservedCommand;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.messages.CObservedSignal;

public class CComponentDispatcher
extends CDispatcher {
    private CComponentMonitoringContext context;
    private CFactory factory;
    private Map<String, CComponentMonitor> componentMonitors = new HashMap<String, CComponentMonitor>();

    public CComponentDispatcher(CComponentMonitoringContext context, CFactory factory, int nrConnections) {
        super(nrConnections);
        this.context = context;
        this.factory = factory;
    }

    @Override
    public boolean consume(CObservedMessage message) throws Exception {
        CInterfaceMonitor interfaceMonitor;
        if (this.nrConnections >= 0 && this.nrErrorConnections == this.nrConnections) {
            return false;
        }
        CDissectedMessage dissectedMessage = this.dissectMessage(message);
        if (dissectedMessage == null) {
            return true;
        }
        String componentInstance = dissectedMessage.componentInstance;
        String connectionKey = dissectedMessage.connectionKey;
        CComponentMonitor componentMonitor = this.componentMonitors.get(componentInstance);
        if (componentMonitor == null) {
            componentMonitor = new CComponentMonitor(this.context.clone().setComponentInstanceName(componentInstance));
            this.componentMonitors.put(componentInstance, componentMonitor);
        }
        if ((interfaceMonitor = (CInterfaceMonitor)this.connection2monitor.get(connectionKey)) == null) {
            interfaceMonitor = new CInterfaceMonitor(this.context.createPortConnectionContext(message.getInterface(), dissectedMessage.port, componentInstance, connectionKey), this.factory, componentMonitor);
            this.connection2monitor.put(connectionKey, interfaceMonitor);
        }
        if (!interfaceMonitor.inErrorState() && !interfaceMonitor.consume(message)) {
            ++this.nrErrorConnections;
        }
        return this.nrConnections < 0 || this.nrErrorConnections < this.nrConnections;
    }

    private CDissectedMessage dissectMessage(CObservedMessage message) {
        String key;
        String port;
        String componentInstance;
        if (this.context.isComponentInstance(message.getSource())) {
            componentInstance = message.getSource();
            port = message.getSourcePort();
            key = this.context.isSingletonPort(port) ? this.makeSingletonConnectionKey(componentInstance, port, message.getInterface()) : (message instanceof CObservedCommand || message instanceof CObservedSignal ? this.makeMultitonConnectionKey(message.getDestination(), componentInstance, message.getInterface()) : this.makeMultitonConnectionKey(componentInstance, message.getDestination(), message.getInterface()));
        } else if (this.context.isComponentInstance(message.getDestination())) {
            componentInstance = message.getDestination();
            port = message.getDestinationPort();
            key = this.context.isSingletonPort(port) ? this.makeSingletonConnectionKey(componentInstance, port, message.getInterface()) : (message instanceof CObservedCommand || message instanceof CObservedSignal ? this.makeMultitonConnectionKey(componentInstance, message.getSource(), message.getInterface()) : this.makeMultitonConnectionKey(message.getSource(), componentInstance, message.getInterface()));
        } else {
            return null;
        }
        return new CDissectedMessage(componentInstance, port, key);
    }

    @Override
    public void traceEnded() throws Exception {
        for (CInterfaceMonitor cInterfaceMonitor : this.connection2monitor.values().stream().filter(h -> !h.inErrorState()).collect(Collectors.toList())) {
            cInterfaceMonitor.traceEnded();
        }
        for (CComponentMonitor cComponentMonitor : this.componentMonitors.values()) {
            cComponentMonitor.traceEnded();
        }
    }

    @Override
    public List<CMonitorResults> getResults() {
        return this.componentMonitors.values().stream().map(m -> m.getResults()).collect(Collectors.toList());
    }
}

