#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#
# Copyright 2006 Sun Microsystems, Inc. All rights reserved.
# Use is subject to license terms.
#
# @(#)cmn.Makefile 1.16 06/12/12
#

CC	= cc
LINT	= lint
LINTFLAGS =
AR	= ar
CCSBIN	= $(DESTDIR)/usr/ccs/bin
CCSLIB	= $(DESTDIR)/usr/lib

SGSBASE	= ../../../..
INCBASE	= ../../../hdr
INCLIST	= -I$(SGSBASE)/sgs/inc/common -I$(INCBASE)

SOURCES = abspath.c any.c cat.c dname.c fatal.c fdfopen.c \
          fmalloc.c had.c imatch.c index.c lockit.c patoi.c   \
	  repl.c satoi.c setsig.c  sname.c strend.c               \
          trnslat.c userexit.c xcreat.c xlink.c xopen.c xpipe.c   \
          xunlink.c xmsg.c zero.c
FILES	= $(SOURCES:%.c=%.o)
LFILES	= $(SOURCES:%.c=%.ln)
SRC_DIR_SOURCES = $(SOURCES:%=$(SRC_DIR)/%)

LIBRARY	= mpwlib.a
LLIBRARY = llib-lmpw.ln
PRODUCTS = $(LIBRARY)

all: $(PRODUCTS) messages.po
	@echo "Library $(PRODUCTS) is up to date\n"

install: $(PRODUCTS) messages.po

clean:
	-$(RM) *.o *.a
	-$(RM) lint.out
	-$(RM) *.ln
	-rm -f messages.po

clobber: clean
	-$(RM) $(PRODUCTS)

.SUFFIXES : .o .c .e .r .f .y .yr .ye .l .s .ln

$(LIBRARY): $(FILES)
	$(AR) crv $(LIBRARY) $(FILES)

%.o: $(SRC_DIR)/%.c
	$(CC) $(CPPFLAGS) $(CFLAGS) $(INCLIST) -c $< 

lintit: $(LLIBRARY)
	@echo "Library $(LLIBRARY) is up to date"

$(LLIBRARY): $(LFILES)
	$(RM) $(LLIBRARY)
	$(LINT) $(CFLAGS) $(LINTFLAGS) *.ln -o mpw >> lint.out

%.ln: $(SRC_DIR)/%.c
	echo "$<:" >> lint.out
	$(LINT) $(CFLAGS) $(LINTFLAGS) $(INCLIST) $< -c >> lint.out

abspath.o:	$(SRC_DIR)/abspath.c
any.o:		$(SRC_DIR)/any.c
cat.o:		$(SRC_DIR)/cat.c
clean.o:	$(SRC_DIR)/clean.c
dname.o:	$(SRC_DIR)/dname.c
fatal.o:	$(SRC_DIR)/fatal.c
fdfopen.o:	$(SRC_DIR)/fdfopen.c
fmalloc.o:	$(SRC_DIR)/fmalloc.c
imatch.o:	$(SRC_DIR)/imatch.c
index.o:	$(SRC_DIR)/index.c
lockit.o:	$(SRC_DIR)/lockit.c
logname.o:	$(SRC_DIR)/logname.c
patoi.o:	$(SRC_DIR)/patoi.c
repl.o:		$(SRC_DIR)/repl.c
satoi.o:	$(SRC_DIR)/satoi.c
setsig.o:	$(SRC_DIR)/setsig.c
sname.o:	$(SRC_DIR)/sname.c
strend.o:	$(SRC_DIR)/strend.c
trnslat.o:	$(SRC_DIR)/trnslat.c
userexit.o:	$(SRC_DIR)/userexit.c
xcreat.o:	$(SRC_DIR)/xcreat.c
xlink.o:	$(SRC_DIR)/xlink.c
xopen.o:	$(SRC_DIR)/xopen.c
xpipe.o:	$(SRC_DIR)/xpipe.c
xunlink.o:	$(SRC_DIR)/xunlink.c
xmsg.o:		$(SRC_DIR)/xmsg.c
zero.o:		$(SRC_DIR)/zero.c

abspath.ln:	$(SRC_DIR)/abspath.c
any.ln:		$(SRC_DIR)/any.c
cat.ln:		$(SRC_DIR)/cat.c
clean.ln:	$(SRC_DIR)/clean.c
dname.ln:	$(SRC_DIR)/dname.c
fatal.ln:	$(SRC_DIR)/fatal.c
fdfopen.ln:	$(SRC_DIR)/fdfopen.c
fmalloc.ln:	$(SRC_DIR)/fmalloc.c
imatch.ln:	$(SRC_DIR)/imatch.c
index.ln:	$(SRC_DIR)/index.c
lockit.ln:	$(SRC_DIR)/lockit.c
logname.ln:	$(SRC_DIR)/logname.c
patoi.ln:	$(SRC_DIR)/patoi.c
repl.ln:	$(SRC_DIR)/repl.c
satoi.ln:	$(SRC_DIR)/satoi.c
setsig.ln:	$(SRC_DIR)/setsig.c
sname.ln:	$(SRC_DIR)/sname.c
strend.ln:	$(SRC_DIR)/strend.c
trnslat.ln:	$(SRC_DIR)/trnslat.c
userexit.ln:	$(SRC_DIR)/userexit.c
xcreat.ln:	$(SRC_DIR)/xcreat.c
xlink.ln:	$(SRC_DIR)/xlink.c
xopen.ln:	$(SRC_DIR)/xopen.c
xpipe.ln:	$(SRC_DIR)/xpipe.c
xunlink.ln:	$(SRC_DIR)/xunlink.c
xmsg.ln:	$(SRC_DIR)/xmsg.c
zero.ln:	$(SRC_DIR)/zero.c

move.ln:	
	if vax; then	\
		$(CC) -c vax/move.s	; \
	elif u3b; then 	\
		$(CC) -c $(CFLAGS) u3b/move.c	; \
	elif u3b15 || u3b2; then	\
		$(CC) -c $(CFLAGS) u3b2/move.c	; \
	elif pdp11; then	\
		$(CC) -c $(CFLAGS) pdp11/move.c	; \
	else	\
		$(CC) -c $(CFLAGS) u370/move.c	; \
	fi

alloca.ln:
	if vax; then	\
		$(CC) -c vax/alloca.s	; \
	elif u3b; then 	\
		$(CC) -c u3b/alloca.s	; \
	elif u3b15 || u3b2; then	\
		$(CC)  -c u3b2/alloca.s	; \
	elif pdp11; then	\
		$(CC) -c pdp11/alloca.s	; \
	else	\
		$(CC) -c $(CFLAGS) u370/alloca.c	; \
	fi

move.o:	
	if vax; then	\
		$(CC) -c vax/move.s	; \
	elif u3b; then 	\
		$(CC) -c $(CFLAGS) u3b/move.c	; \
	elif u3b15 || u3b2; then	\
		$(CC) -c $(CFLAGS) u3b2/move.c	; \
	elif pdp11; then	\
		$(CC) -c $(CFLAGS) pdp11/move.c	; \
	else	\
		$(CC) -c $(CFLAGS) u370/move.c	; \
	fi

alloca.o:
	if vax; then	\
		$(CC) -c vax/alloca.s	; \
	elif u3b; then 	\
		$(CC) -c u3b/alloca.s	; \
	elif u3b15 || u3b2; then	\
		$(CC)  -c u3b2/alloca.s	; \
	elif pdp11; then	\
		$(CC) -c pdp11/alloca.s	; \
	else	\
		$(CC) -c $(CFLAGS) u370/alloca.c	; \
	fi

messages.po: $(SRC_DIR_SOURCES)
	$(RM) $@
	/bin/xgettext -s $(SRC_DIR_SOURCES)

