#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#
# Copyright 2001 Sun Microsystems, Inc. All rights reserved.
# Use is subject to license terms.
#
# @(#)cmn.Makefile 1.12 06/12/12
#

CC	= cc
LINT	= lint
LINTFLAGS = 
AR	= ar
CCSBIN	= $(DESTDIR)/usr/ccs/bin
CCSLIB	= $(DESTDIR)/usr/lib

SGSBASE	= ../../../..
INCBASE	= ../../../hdr
INCLIST	= -I$(SGSBASE)/sgs/inc/common -I$(INCBASE)
INC	=
INCSYS	=

SOURCES	= gf.c cmrcheck.c deltack.c error.c filehand.c
FILES	= $(SOURCES:%.c=%.o)
LFILES	= $(SOURCES:%.c=%.ln)
SRC_DIR_SOURCES = $(SOURCES:%=$(SRC_DIR)/%)

LIBRARY	= cassi.a
LLIBRARY = llib-lcassi.ln
PRODUCTS = $(LIBRARY) 

all: $(PRODUCTS) messages.po
	@echo "Library $(PRODUCTS) is up to date\n"

install: $(PRODUCTS) messages.po

clean:
	-$(RM) *.o *.a
	-$(RM) lint.out
	-$(RM) *.ln
	-rm -f messages.po

clobber: clean
	-$(RM) $(PRODUCTS)

.SUFFIXES : .o .c .e .r .f .y .yr .ye .l .s .ln

$(LIBRARY): $(FILES)
	$(AR) crv $(LIBRARY) $(FILES)

%.o: $(SRC_DIR)/%.c
	$(CC) $(CPPFLAGS) $(CFLAGS) $(INCLIST) -c $< 

lintit: $(LLIBRARY)
	@echo "Library $(LLIBRARY) is up to date"

$(LLIBRARY): $(LFILES)
	$(RM) $(LLIBRARY)
	$(LINT) $(CFLAGS) $(LINTFLAGS) *.ln -o cassi >> lint.out

%.ln: $(SRC_DIR)/%.c
	echo "$<:" >> lint.out
	$(LINT) $(CFLAGS) $(LINTFLAGS) $(INCLIST) $< -c >> lint.out

gf.o: $(SRC_DIR)/gf.c \
	$(INCBASE)/filehand.h
cmrcheck.o: $(SRC_DIR)/cmrcheck.c \
	$(INCBASE)/filehand.h
deltack.o: $(SRC_DIR)/deltack.c \
	$(INCBASE)/filehand.h \
	$(INCBASE)/had.h \
	$(INCBASE)/defines.h
filehand.o: $(SRC_DIR)/filehand.c \
	$(INCBASE)/filehand.h

gf.ln: $(SRC_DIR)/gf.c \
	$(INCBASE)/filehand.h
cmrcheck.ln: $(SRC_DIR)/cmrcheck.c \
	$(INCBASE)/filehand.h
deltack.ln: $(SRC_DIR)/deltack.c \
	$(INCBASE)/filehand.h \
	$(INCBASE)/had.h \
	$(INCBASE)/defines.h
filehand.ln: $(SRC_DIR)/filehand.c \
	$(INCBASE)/filehand.h
error.ln: $(SRC_DIR)/error.c

messages.po: $(SRC_DIR_SOURCES)
	$(RM) $@
	/bin/xgettext -s $(SRC_DIR_SOURCES)

