#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#
# Copyright 2006 Sun Microsystems, Inc. All rights reserved.
# Use is subject to license terms.
#
# @(#)master.Makefile 1.16 06/12/12
#

.KEEP_STATE:

include ${TOP}/global.macro.Makefile

#
# Choose the right i18n library
#
I18LIB-		=
I18LIB-4.x	= ${I18LIB-}
I18LIB-5.0	= -lintl
I18LIB    	+= ${I18LIB-${TARGET_RELEASE}}

#
# For 4.x builds need to set the SUN4_x #define.
# The TARGET_RELEASE variable is used to choose which
# of the CPPFLAGS-* variables to use.  If it is not set
# then 4.x is assumed.
#
CPPFLAGS-	= -DSUN4_x 
CPPFLAGS-4.x	= ${CPPFLAGS-}
CPPFLAGS-5.0	= -DSUN5_0
CPPFLAGS-5.0i86pc = -DSUN5_0 -Dx86
CPPFLAGS    	+= ${CPPFLAGS-${TARGET_RELEASE}${x86}}
LINTFLAGS   	+= -buxz

#
# This is needed in case some execs in bin need to be built with certain libs
#
LDLIB 		= ${MORE_LDLIB}

#
# Compile for optimization (-O) by default.  If debugging is desired
# (DBX=-g) then, for 5.0, also include the -xs option.  This causes all
# the debugging symbols to be included in the final executable.  Otherwise,
# the symbols are left in the .o files.  When making internal releases
# it is desireable for the debugging symbols to be in the actual executable.
#
OPTS       	= -O
OPTS-g-4.x	= 
OPTS-g-5.0	= -xs
OPTS-g     	= ${OPTS-g-${TARGET_RELEASE}}
FOBS		= "-D_FILE_OFFSET_BITS=64" 

CCFLAGS   	+= ${OPTS${DBX}} ${DBX} ${FOBS}
CFLAGS    	+= ${OPTS${DBX}} ${DBX} ${FOBS}

CC-		= acc
CC-4.x		= $(CC-)
CC-5.0		= cc
CC		= $(CC-$(TARGET_RELEASE))


CCFLAGS 	+= ${SB}
CCFLAGS 	+= ${QP_CCFLAGS-${TARGET_RELEASE}}

STRIPFLAG-	= -s
STRIPFLAG--g	=
STRIPFLAG	= ${STRIPFLAG-${DBX}}
LDFLAGS		+= ${STRIPFLAG}

#
# install is in different places
#

INSTALL         = $(INSTALL-4.x)
INSTALL-4.x     = /usr/bin/install
INSTALL-5.0     = /usr/sbin/install
INSTALL         = $(INSTALL-$(TARGET_RELEASE))

#
# Rules for compiling C++ and C files.
#
# Use .C extension for derrived source files (e.g., yacc output).
#

.C.o:
	$(COMPILE.cc) $(OUTPUT_OPTION) $<

%.o: $(SRC_DIR)/%.cc
	$(COMPILE.cc) $(OUTPUT_OPTION) $<

%.o: $(SRC_DIR)/%.c
	$(COMPILE.c) $(OUTPUT_OPTION) $<

%.o: $(SRC_DIR)/%.C
	$(COMPILE.cc) $(OUTPUT_OPTION) $<

