/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)atan2f.c	1.5	06/01/23 SMI"

#pragma weak atan2f = __atan2f

#include "libm.h"

#if defined(__i386) && !defined(__amd64)
extern int __swapRP(int);
#endif

/*
 * For i = 0, ..., 192, let x[i] be the double precision number whose
 * high order 32 bits are 0x3f900000 + (i << 16) and whose low order
 * 32 bits are zero.  Then TBL[i] := atan(x[i]) to double precision.
 */

static const double TBL[] = {
	1.56237286204768313e-02,
	1.66000375562312640e-02,
	1.75763148444955872e-02,
	1.85525586258889763e-02,
	1.95287670414137082e-02,
	2.05049382324763683e-02,
	2.14810703409090559e-02,
	2.24571615089905717e-02,
	2.34332098794675855e-02,
	2.44092135955758099e-02,
	2.53851708010611396e-02,
	2.63610796402007873e-02,
	2.73369382578244127e-02,
	2.83127447993351995e-02,
	2.92884974107309737e-02,
	3.02641942386252458e-02,
	3.12398334302682774e-02,
	3.31909314971115949e-02,
	3.51417768027967800e-02,
	3.70923545503918164e-02,
	3.90426499551669928e-02,
	4.09926482452637811e-02,
	4.29423346623621707e-02,
	4.48916944623464972e-02,
	4.68407129159696539e-02,
	4.87893753095156174e-02,
	5.07376669454602178e-02,
	5.26855731431300420e-02,
	5.46330792393594777e-02,
	5.65801705891457105e-02,
	5.85268325663017702e-02,
	6.04730505641073168e-02,
	6.24188099959573500e-02,
	6.63088949198234884e-02,
	7.01969710718705203e-02,
	7.40829225490337306e-02,
	7.79666338315423008e-02,
	8.18479898030765457e-02,
	8.57268757707448092e-02,
	8.96031774848717461e-02,
	9.34767811585894698e-02,
	9.73475734872236709e-02,
	1.01215441667466668e-01,
	1.05080273416329528e-01,
	1.08941956989865793e-01,
	1.12800381201659389e-01,
	1.16655435441069349e-01,
	1.20507009691224562e-01,
	1.24354994546761438e-01,
	1.32039761614638762e-01,
	1.39708874289163648e-01,
	1.47361481088651630e-01,
	1.54996741923940973e-01,
	1.62613828597948568e-01,
	1.70211925285474408e-01,
	1.77790228992676075e-01,
	1.85347949995694761e-01,
	1.92884312257974672e-01,
	2.00398553825878512e-01,
	2.07889927202262986e-01,
	2.15357699697738048e-01,
	2.22801153759394521e-01,
	2.30219587276843718e-01,
	2.37612313865471242e-01,
	2.44978663126864143e-01,
	2.59629629408257512e-01,
	2.74167451119658789e-01,
	2.88587361894077410e-01,
	3.02884868374971417e-01,
	3.17055753209147029e-01,
	3.31096076704132103e-01,
	3.45002177207105132e-01,
	3.58770670270572245e-01,
	3.72398446676754202e-01,
	3.85882669398073752e-01,
	3.99220769575252543e-01,
	4.12410441597387323e-01,
	4.25449637370042266e-01,
	4.38336559857957830e-01,
	4.51069655988523499e-01,
	4.63647609000806094e-01,
	4.88333951056405535e-01,
	5.12389460310737732e-01,
	5.35811237960463704e-01,
	5.58599315343562441e-01,
	5.80756353567670414e-01,
	6.02287346134964152e-01,
	6.23199329934065904e-01,
	6.43501108793284371e-01,
	6.63202992706093286e-01,
	6.82316554874748071e-01,
	7.00854407884450192e-01,
	7.18829999621624527e-01,
	7.36257428981428097e-01,
	7.53151280962194414e-01,
	7.69526480405658297e-01,
	7.85398163397448279e-01,
	8.15691923316223422e-01,
	8.44153986113171051e-01,
	8.70903457075652976e-01,
	8.96055384571343927e-01,
	9.19719605350416858e-01,
	9.42000040379463610e-01,
	9.62994330680936206e-01,
	9.82793723247329054e-01,
	1.00148313569423464e+00,
	1.01914134426634972e+00,
	1.03584125300880014e+00,
	1.05165021254837376e+00,
	1.06663036531574362e+00,
	1.08083900054116833e+00,
	1.09432890732118993e+00,
	1.10714871779409041e+00,
	1.13095374397916038e+00,
	1.15257199721566761e+00,
	1.17227388112847630e+00,
	1.19028994968253166e+00,
	1.20681737028525249e+00,
	1.22202532321098967e+00,
	1.23605948947808186e+00,
	1.24904577239825443e+00,
	1.26109338225244039e+00,
	1.27229739520871732e+00,
	1.28274087974427076e+00,
	1.29249666778978534e+00,
	1.30162883400919616e+00,
	1.31019393504755555e+00,
	1.31824205101683711e+00,
	1.32581766366803255e+00,
	1.33970565959899957e+00,
	1.35212738092095464e+00,
	1.36330010035969384e+00,
	1.37340076694501589e+00,
	1.38257482149012589e+00,
	1.39094282700241845e+00,
	1.39860551227195762e+00,
	1.40564764938026987e+00,
	1.41214106460849531e+00,
	1.41814699839963154e+00,
	1.42371797140649403e+00,
	1.42889927219073276e+00,
	1.43373015248470903e+00,
	1.43824479449822262e+00,
	1.44247309910910193e+00,
	1.44644133224813509e+00,
	1.45368758222803240e+00,
	1.46013910562100091e+00,
	1.46591938806466282e+00,
	1.47112767430373470e+00,
	1.47584462045214027e+00,
	1.48013643959415142e+00,
	1.48405798811891154e+00,
	1.48765509490645531e+00,
	1.49096634108265924e+00,
	1.49402443552511865e+00,
	1.49685728913695626e+00,
	1.49948886200960629e+00,
	1.50193983749385196e+00,
	1.50422816301907281e+00,
	1.50636948736934317e+00,
	1.50837751679893928e+00,
	1.51204050407917401e+00,
	1.51529782154917969e+00,
	1.51821326518395483e+00,
	1.52083793107295384e+00,
	1.52321322351791322e+00,
	1.52537304737331958e+00,
	1.52734543140336587e+00,
	1.52915374769630819e+00,
	1.53081763967160667e+00,
	1.53235373677370856e+00,
	1.53377621092096650e+00,
	1.53509721411557254e+00,
	1.53632722579538861e+00,
	1.53747533091664934e+00,
	1.53854944435964280e+00,
	1.53955649336462841e+00,
	1.54139303859089161e+00,
	1.54302569020147562e+00,
	1.54448660954197448e+00,
	1.54580153317597646e+00,
	1.54699130060982659e+00,
	1.54807296595325550e+00,
	1.54906061995310385e+00,
	1.54996600675867957e+00,
	1.55079899282174605e+00,
	1.55156792769518947e+00,
	1.55227992472688747e+00,
	1.55294108165534417e+00,
	1.55355665560036682e+00,
	1.55413120308095598e+00,
	1.55466869295126031e+00,
	1.55517259817441977e+00,
};

static const double
	pio4	=  7.8539816339744827900e-01,
	pio2	=  1.5707963267948965580e+00,
	negpi	= -3.1415926535897931160e+00,
	q1	= -3.3333333333296428046e-01,
	q2	=  1.9999999186853752618e-01,
	zero	=  0.0;

static const float two24 = 16777216.0;

float
atan2f(float fy, float fx)
{
	double	a, t, s, dbase;
	float	x, y, base;
	int	i, k, hx, hy, ix, iy, sign;
#if defined(__i386) && !defined(__amd64)
	int	rp;
#endif

	iy = *(int *)&fy;
	ix = *(int *)&fx;
	hy = iy & ~0x80000000;
	hx = ix & ~0x80000000;

	sign = 0;
	if (hy > hx) {
		x = fy;
		y = fx;
		i = hx;
		hx = hy;
		hy = i;
		if (iy < 0) {
			x = -x;
			sign = 1;
		}
		if (ix < 0) {
			y = -y;
			a = pio2;
		} else {
			a = -pio2;
			sign = 1 - sign;
		}
	} else {
		y = fy;
		x = fx;
		if (iy < 0) {
			y = -y;
			sign = 1;
		}
		if (ix < 0) {
			x = -x;
			a = negpi;
			sign = 1 - sign;
		} else {
			a = zero;
		}
	}

	if (hx >= 0x7f800000 || hx - hy >= 0x0c800000) {
		if (hx >= 0x7f800000) {
			if (hx > 0x7f800000) /* nan */
				return (x * y);
			else if (hy >= 0x7f800000)
				a += pio4;
		} else if ((int)a == 0) {
			a = (double)y / x;
		}
		return ((float)((sign)? -a : a));
	}

	if (hy < 0x00800000) {
		if (hy == 0)
			return ((float)((sign)? -a : a));
		/* scale subnormal y */
		y *= two24;
		x *= two24;
		hy = *(int *)&y;
		hx = *(int *)&x;
	}

#if defined(__i386) && !defined(__amd64)
	rp = __swapRP(fp_extended);
#endif
	k = (hy - hx + 0x3f800000) & 0xfff80000;
	if (k >= 0x3c800000) {	/* |y/x| >= 1/64 */
		*(int *)&base = k;
		k = (k - 0x3c800000) >> 19;
		a += TBL[k];
	} else {
		/*
		 * For some reason this is faster on USIII than just
		 * doing t = y/x in this case.
		 */
		*(int *)&base = 0;
	}
	dbase = (double)base;
	t = (y - x * dbase) / (x + y * dbase);
	s = t * t;
	a = (a + t) + t * s * (q1 + s * q2);
#if defined(__i386) && !defined(__amd64)
	if (rp != fp_extended)
		(void) __swapRP(rp);
#endif
	return ((float)((sign)? -a : a));
}
