/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)_TBL_cosl.c	1.9	06/01/31 SMI"

/*
 * table of cosl(x) where x is 0.15625 + i*0.03125, i=0,1,...,74.
 * {0x3ffc4000,0,0,0} --> (inc 0x800) -->  {0x3ffe9000,0,0,0}
 *    0.15625	           0.03125	     0.78125  (pi/4 = 0.785395663...)
 */

#include "libm.h"

const long double _TBL_cosl_hi[] = {
	+9.878177838164719441005030343632113165093e-0001L,
	+9.872023778548304903960885335116224443952e-0001L,
	+9.865719083994975887573374074953084086015e-0001L,
	+9.859263850706614357470592528694354441508e-0001L,
	+9.852658177182138162042947097595789939359e-0001L,
	+9.845902164215998060143951077820687364441e-0001L,
	+9.838995914896639721783093514164872453367e-0001L,
	+9.831939534604930725278757612989684275134e-0001L,
	+9.824733131012552574873276832436224950147e-0001L,
	+9.817376814080357763345961479047090031971e-0001L,
	+9.809870696056691904693298964353096645569e-0001L,
	+9.802214891475680962478518674217420182872e-0001L,
	+9.794409517155483599985309545029874933258e-0001L,
	+9.786454692196508678842676797432752842534e-0001L,
	+9.778350537979597933319715729444545493330e-0001L,
	+9.770097178164173848020456902145767884624e-0001L,
	+9.761694738686352767239890354351355336967e-0001L,
	+9.753143347757023264772798556222610938601e-0001L,
	+9.744443135859889803497110560454343440501e-0001L,
	+9.735594235749481714583125145098981012012e-0001L,
	+9.726596782449127526709130582675652597851e-0001L,
	+9.717450913248894676192664941325029643211e-0001L,
	+9.708156767703494629474905457850460270255e-0001L,
	+9.698714487630153449923440459169307761267e-0001L,
	+9.689124217106447841445954494941892053405e-0001L,
	+9.669500292306778220083416236105315034050e-0001L,
	+9.649286191047710095810746653157483714001e-0001L,
	+9.628483147093796998997010934802143646862e-0001L,
	+9.607092430155619030666593505813134717046e-0001L,
	+9.585115345812286273019694081549198217856e-0001L,
	+9.562553235431752969755999422630283611690e-0001L,
	+9.539407476088947339813247959876116228319e-0001L,
	+9.515679480481722021454882173642709621657e-0001L,
	+9.491370696844630276658474217621056230077e-0001L,
	+9.466482608860533218460995072955329761108e-0001L,
	+9.441016735570043456300176912531248599600e-0001L,
	+9.414974631278810686445112360536708146537e-0001L,
	+9.388357885462654886325783059847125541586e-0001L,
	+9.361168122670552902942374110195085880318e-0001L,
	+9.333407002425484356552992294699955265909e-0001L,
	+9.305076219123142911494767922295554806411e-0001L,
	+9.276177501928519096280307987999613501918e-0001L,
	+9.246712614670360985021130145601387709996e-0001L,
	+9.216683355733519181754113682027127142383e-0001L,
	+9.186091557949182678378249777185498625801e-0001L,
	+9.154939088483012285639177321802218816645e-0001L,
	+9.123227848721178464920295420473417337577e-0001L,
	+9.090959774154310516503817356844764174905e-0001L,
	+9.058136834259364207445166606527002577088e-0001L,
	+9.024761032379415049251832726758959994948e-0001L,
	+8.990834405601384562165449292093793065380e-0001L,
	+8.956359024631706989005700004462563503448e-0001L,
	+8.921336993669944047239002537237885750767e-0001L,
	+8.885770450280355433176090231160209800973e-0001L,
	+8.849661565261432916972965369666479264236e-0001L,
	+8.813012542513405991401619082981001728813e-0001L,
	+8.775825618903727161162815826038296809401e-0001L,
	+8.699847180584173888289155999014662429887e-0001L,
	+8.621744799348805043671625102533242741250e-0001L,
	+8.541537542773853851434517851051031764412e-0001L,
	+8.459244992310679544597230785974932624246e-0001L,
	+8.374887238505236853153533489172406171513e-0001L,
	+8.288484876093257348101717901191166381510e-0001L,
	+8.200058998972340082555506338765560425268e-0001L,
	+8.109631195052179021895348039410807243520e-0001L,
	+8.017223540984184506074926056529642078277e-0001L,
	+7.922858596771785431415013237817093985302e-0001L,
	+7.826559400262727969307874474281390259485e-0001L,
	+7.728349461524715448108518459134251775639e-0001L,
	+7.628252757105762505070987536254297918621e-0001L,
	+7.526293724180664760545413248471431159893e-0001L,
	+7.422497254585013069913472534496105367206e-0001L,
	+7.316888688738208863118387530000845290150e-0001L,
	+7.209493809456964180438127841484476879092e-0001L,
	+7.100338835660796749741216439594902194333e-0001L,
};

const long double _TBL_cosl_lo[] = {
	+4.742713078367058978924681076205264183648e-0035L,
	-3.400922580038153352909034207677181560093e-0035L,
	-2.473279499369853624762524012127207246323e-0035L,
	-3.902320877004518000716232064546238578734e-0035L,
	+2.265680295058180661415174977785279521173e-0035L,
	-2.254772246444203259170588302104662991085e-0036L,
	+2.734143189480662078104863307237612648780e-0035L,
	-3.701912560693446438656202168446355677822e-0035L,
	-1.649243588915575846254638680142303422320e-0035L,
	+2.725042655698714891044457001868653187367e-0035L,
	-1.908992594100964198869963315362783449712e-0036L,
	-1.465547554627127716918860559012698704471e-0035L,
	+4.428780565915607570668447972900679899952e-0035L,
	+1.439313657623768907227720140857454695843e-0035L,
	-3.792074229051804169372108537791927020038e-0035L,
	-2.610779485320152706286660129045188117210e-0036L,
	-2.877279742494815830479448606269854599891e-0035L,
	+3.991065835589256680020290949615723238476e-0035L,
	+3.099479059550534193045145385925483327991e-0035L,
	+1.146611686911982702287167679510021879695e-0035L,
	-3.917592318193149049660769585602527582231e-0035L,
	-1.951971321999985008371800682574139933978e-0035L,
	+2.974588209723938591252776820212028367960e-0035L,
	-2.038390756570426530537115267786908745116e-0036L,
	-5.536347061134619893988732877493263844943e-0036L,
	-4.389722144327924120620880599904805370946e-0035L,
	-3.666858326708207750024755456027611364938e-0035L,
	+4.889869663833434507994220130518213362272e-0036L,
	-5.870115582315839607120133516012219562069e-0036L,
	+2.507707793716364811457350893931543805685e-0035L,
	+3.216165721908659970511036451358372071749e-0035L,
	+2.880756890524786020083959729246571876109e-0035L,
	+6.368426285981156583087492887998846060579e-0036L,
	+6.844339659916371522503091904688601360028e-0037L,
	-4.329063396630008909415294204988246215817e-0035L,
	+1.038125352401202296098224611721455839121e-0035L,
	+3.207093666031656020715902410548849578474e-0036L,
	-3.987580687739740313485850727522454807713e-0035L,
	+3.404815912367106584354098624390321615909e-0035L,
	-4.752557072516798311248008988313821999362e-0035L,
	+2.745410885517329825733352856854160918801e-0035L,
	+7.585203719163457562812011671268547121453e-0036L,
	-4.141871248600318251086493472511758380472e-0035L,
	-1.835879954339576229487102635414793218992e-0035L,
	+2.976082827782744334600577457984098492775e-0035L,
	-3.507755179553069548150909011683056358498e-0035L,
	+7.869038865563736742679481321788455681309e-0036L,
	+1.208860140284441557337760250856779527931e-0035L,
	-3.609503076059411697756765630044671398302e-0035L,
	+2.262828995013444190183062956802106020046e-0035L,
	-2.067726154909043706666702751547519756391e-0035L,
	+3.735937416598668830886204955423117851511e-0035L,
	-1.107719376025673147326930792646924920884e-0035L,
	+4.123542789546647314438136551770221119198e-0036L,
	+4.533705702883256304420378263134621416396e-0035L,
	-1.434191923121166877839456190096294453634e-0035L,
	-2.894849601813639248551925385406988512004e-0035L,
	-4.681686383005756267827413197921838600437e-0035L,
	-3.715568183175335822345624718357717998947e-0035L,
	-1.687075340130951528732220617225731715663e-0035L,
	+1.980549471419898781791643429252740528544e-0035L,
	+2.727619978720845330457777186773261559081e-0035L,
	+1.430825081004965817190481755062397701422e-0035L,
	-1.720088119552308234167243322979912469421e-0035L,
	+1.104812928567944364260514024188043464704e-0035L,
	+6.094878513052330893256279394589637408556e-0036L,
	+2.475195582284731678792488916738076213891e-0035L,
	+1.693320456792379194278077712885062541662e-0035L,
	+3.949752293412116642372415347411469162440e-0035L,
	+4.220674118886015050047489393823250795070e-0035L,
	+3.713069586576631896654508643111045710544e-0035L,
	-3.789252700498009135399234738712875263543e-0035L,
	+1.482556375489316971849917102931986196306e-0035L,
	+4.786912857336733794995363260508118324272e-0035L,
	-4.096232247636924432208967529079024417475e-0035L,
};
