/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)_TBL_cosl.c	1.9	06/01/31 SMI"

/*
 * For i = 0L, ..., 75 let x(i) be the extended precision number
 * whose exponent is given by 0x3ffc + ((i + 8) >> 5) and whose
 * five most significant fraction bits are given by (i + 8) & 0x1f.
 * (The remaining fraction bits are zero and the integer bit is 1.)
 * Then _TBL_cosl_hi[i] := cos(x(i)) rounded to extended precisionL,
 * and _TBL_cosl_lo[i] ~ cos(x(i)) - _TBL_cosl_hi[i].
 */

#include "libm.h"

const long double _TBL_cosl_hi[] = {
	 9.8781778381647194407734133e-01L,
	 9.8720237785483049041453801e-01L,
	 9.8657190839949758873065125e-01L,
	 9.8592638507066143575569700e-01L,
	 9.8526581771821381618451860e-01L,
	 9.8459021642159980601798769e-01L,
	 9.8389959148966397219646454e-01L,
	 9.8319395346049307253706584e-01L,
	 9.8247331310125525749262290e-01L,
	 9.8173768140803577633441562e-01L,
	 9.8098706960566919046918752e-01L,
	 9.8022148914756809622147657e-01L,
	 9.7944095171554836000860772e-01L,
	 9.7864546921965086785991095e-01L,
	 9.7783505379795979334592304e-01L,
	 9.7700971781641738478493484e-01L,
	 9.7616947386863527671421389e-01L,
	 9.7531433477570232649326437e-01L,
	 9.7444431358598898037593275e-01L,
	 9.7355942357494817143660423e-01L,
	 9.7265967824491275265730642e-01L,
	 9.7174509132488946761517512e-01L,
	 9.7081567677034946294446077e-01L,
	 9.6987144876301534501253018e-01L,
	 9.6891242171064478417089050e-01L,
	 9.6695002923067782202260975e-01L,
	 9.6492861910477100957986285e-01L,
	 9.6284831470937969988364152e-01L,
	 9.6070924301556190306409372e-01L,
	 9.5851153458122862729886421e-01L,
	 9.5625532354317529696403552e-01L,
	 9.5394074760889473397129298e-01L,
	 9.5156794804817220216272555e-01L,
	 9.4913706968446302764510006e-01L,
	 9.4664826088605332182323443e-01L,
	 9.4410167355700434565568893e-01L,
	 9.4149746312788106861798448e-01L,
	 9.3883578854626548865214275e-01L,
	 9.3611681226705529027757452e-01L,
	 9.3334070024254843565662820e-01L,
	 9.3050762191231429116015580e-01L,
	 9.2761775019285190965094914e-01L,
	 9.2467126146703609851492875e-01L,
	 9.2166833557335191816090730e-01L,
	 9.1860915579491826785281383e-01L,
	 9.1549390884830122858606058e-01L,
	 9.1232278487211784648910212e-01L,
	 9.0909597741543105166956915e-01L,
	 9.0581368342593642076004609e-01L,
	 9.0247610323794150491687888e-01L,
	 8.9908344056013845619268129e-01L,
	 8.9563590246317069891836618e-01L,
	 8.9213369936699440471096142e-01L,
	 8.8857704502803554333020819e-01L,
	 8.8496615652614329169001889e-01L,
	 8.8130125425134059916022419e-01L,
	 8.7758256189037271613028607e-01L,
	 8.6998471805841738884335773e-01L,
	 8.6217447993488050434493855e-01L,
	 8.5415375427738538514389754e-01L,
	 8.4592449923106795446874767e-01L,
	 8.3748872385052368529220410e-01L,
	 8.2884848760932573481351876e-01L,
	 8.2000589989723400824016969e-01L,
	 8.1096311950521790220310775e-01L,
	 8.0172235409841845058843968e-01L,
	 7.9228585967717854313466241e-01L,
	 7.8265594002627279692635431e-01L,
	 7.7283494615247154478458735e-01L,
	 7.6282527571057625053081719e-01L,
	 7.5262937241806647606931838e-01L,
	 7.4224972545850130697074609e-01L,
	 7.3168886887382088632511210e-01L,
	 7.2094938094569641805946583e-01L,
	 7.1003388356607967499180972e-01L,
};

const long double _TBL_cosl_lo[] = {
	 2.3161701550475222913914987e-20L,
	-1.8449479910096732184579231e-20L,
	 2.6686158961121436032543157e-20L,
	-8.6377467693509323999412576e-21L,
	 1.9776110020628332806497627e-20L,
	-3.5925805070704800589322274e-21L,
	-1.8155190558460064943241466e-20L,
	-9.1900782344860461108346151e-21L,
	-5.2952188498928572418662889e-21L,
	 1.8052490350294447403358175e-22L,
	 1.4237809112451219388907461e-22L,
	 2.6375298402937478119012648e-20L,
	-1.0076765547845230197228052e-20L,
	 2.4356732099577389276048253e-20L,
	-1.3951467830437376437362152e-20L,
	 1.7110854885636746562043992e-20L,
	 9.7751412348794551526570426e-21L,
	-1.5984515732024779414075399e-20L,
	-2.6221693743524256098098490e-20L,
	 2.1708281645344702813143892e-20L,
	 1.3606643184793342931047312e-20L,
	 4.0913737251026449191179388e-21L,
	 3.0297735892921952471510043e-21L,
	-2.0186136916357220892889611e-20L,
	-2.6295048282251297741856903e-20L,
	-1.4268128384616571293099177e-20L,
	 1.2118148575499258442724515e-21L,
	 1.6059569963428104840244296e-20L,
	 2.5656322072743666174102425e-21L,
	 3.1051993049709377435678279e-21L,
	 1.1564422287617245178214769e-20L,
	 1.0031811944878086819339264e-20L,
	-1.7237335190163247756143591e-20L,
	 2.0747363423904458194504323e-20L,
	 2.2865077385189808827392339e-20L,
	-2.5671240384658541701793951e-20L,
	 2.6526752505060021072717663e-20L,
	-1.9564443985440576261207264e-20L,
	 1.6662891366649668957364366e-20L,
	-1.3289734577249155895809888e-21L,
	-1.0679012486769670465318810e-20L,
	-2.2918344926389240849631303e-20L,
	-1.2815734598986502345856155e-20L,
	 1.4504064768242345767590746e-20L,
	-1.4988853557132440148049946e-20L,
	-2.2142847270523120702212966e-20L,
	 2.9274200155749021994272015e-21L,
	-1.9187410072234352245854903e-20L,
	-1.5529430996486684056198058e-20L,
	 8.3043961792850937525987774e-21L,
	 2.3863634821654097616646090e-20L,
	-1.7796180005854437467836689e-20L,
	 1.2938828814644961764053094e-20L,
	-1.2599167110905505919738134e-20L,
	 7.2776486597245992496949283e-21L,
	-2.0062284600282808092832087e-20L,
	-1.4004485599673539406695080e-20L,
	-1.4442131618989703782137918e-20L,
	 2.2223959244287650022010583e-20L,
	-4.4575975223558432505505015e-22L,
	-9.0245930394257121787744934e-21L,
	 2.3149253152495269264191463e-20L,
	-3.3469699832521350974745777e-21L,
	 1.5380944635427999356502468e-20L,
	-1.3572945384913555811651506e-20L,
	 1.9052929123346841342486920e-20L,
	 6.8389097769442269862154625e-21L,
	 4.4331336879906155675581769e-21L,
	 2.6264491975559389159451170e-20L,
	-2.3718434730140290189643472e-20L,
	-1.4777051948748214572130603e-20L,
	 2.0601161465229389031848878e-20L,
	-1.3273342027649427778913402e-20L,
	-1.5653047869359238584973515e-20L,
	-1.7688078635602856653655125e-20L,
};
