/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)_TBL_sin.c	1.10	06/01/23 SMI"

#include "libm_protos.h"

/*
 * Table of constants for x[i],sin(x[i]),cos(x[i]), where
 * x[i] ~ (i+10.5)/64 chosen to make the value of sine and
 * cosine nearly representable in double (with error less
 * than 2**-8 ulp)
 * By K.C. Ng, May 5, 1995
 *
 * For each i, _TBL_sincosx[i] := x[i], _TBL_sincos[2*i] :=
 * sin(x[i]), and _TBL_sincos[2*i+1] := cos(x[i]).
 */

const double _TBL_sincos[] = {
	1.63327491736778435127e-01, 9.86571908399470176576e-01,
	1.78722113534634630128e-01, 9.83899591489758251761e-01,
	1.94073102892906523831e-01, 9.80987069605669836925e-01,
	2.09376712086097482857e-01, 9.77835053797937558961e-01,
	2.24629204957583178404e-01, 9.74444313586017130113e-01,
	2.39826857830661321902e-01, 9.70815676770349522684e-01,
	2.54965960415442560727e-01, 9.66950029230792762469e-01,
	2.70042816718758793559e-01, 9.62848314709330965755e-01,
	2.85053745940880454146e-01, 9.58511534581129587274e-01,
	2.99995083378835347698e-01, 9.53940747608846839611e-01,
	3.14863181320744367486e-01, 9.49137069684131584602e-01,
	3.29654409930721814526e-01, 9.44101673557052656349e-01,
	3.44365158144533722862e-01, 9.38835788546692695533e-01,
	3.58991834544317267586e-01, 9.33340700243220688925e-01,
	3.73530868238515501023e-01, 9.27617750192923362640e-01,
	3.87978709726743087316e-01, 9.21668335573470609567e-01,
	4.02331831777567594521e-01, 9.15493908848391546584e-01,
	4.16586730281922223984e-01, 9.09095977415485534401e-01,
	4.30739925110786514573e-01, 9.02476103237949467406e-01,
	4.44787960958008266044e-01, 8.95635902466408118094e-01,
	4.58727408216676513231e-01, 8.88577045028066558885e-01,
	4.72554863751536879946e-01, 8.81301254251215970825e-01,
	4.86266951795427115890e-01, 8.73810306411857196096e-01,
	4.99860324731856597857e-01, 8.66106030321324382726e-01,
	5.13331663943585647658e-01, 8.58190306862591900661e-01,
	5.26677680590333596733e-01, 8.50065068549453184410e-01,
	5.39895116435048061376e-01, 8.41732299041438647436e-01,
	5.52980744632255882820e-01, 8.33194032663434169805e-01,
	5.65931370507619768695e-01, 8.24452353914625679643e-01,
	5.78743832357296650315e-01, 8.15509396946711651033e-01,
	5.91415002201596706755e-01, 8.06367345054898265744e-01,
	6.03941786558566895415e-01, 7.97028430138126520177e-01,
	6.16321127179607297641e-01, 7.87494932169127248578e-01,
	6.28550001844884853597e-01, 7.77769178600434929471e-01,
	6.40625425044079821468e-01, 7.67853543839638774671e-01,
	6.52544448725672743272e-01, 7.57750448655299613243e-01,
	6.64304163044103668234e-01, 7.47462359562187539375e-01,
	6.75901697026429104653e-01, 7.36991788256011193248e-01,
	6.87334219302880855551e-01, 7.26341290975047959577e-01,
	6.98598938789923074033e-01, 7.15513467882745946014e-01,
	7.09693105361432152733e-01, 7.04510962443060329008e-01,
	7.20614010544995853280e-01, 6.93336460750663685637e-01,
	7.31358988151144640000e-01, 6.81992690906972898190e-01,
	7.41925414945620254059e-01, 6.70482422333180339002e-01,
	7.52310711296420575600e-01, 6.58808465085774175307e-01,
	7.62512341773335489137e-01, 6.46973669204044199432e-01,
	7.72527815799416095466e-01, 6.34980923978180178402e-01,
	7.82354688238184881044e-01, 6.22833157267443926486e-01,
	7.91990560000511156780e-01, 6.10533334773848967991e-01,
	8.01433078627164507957e-01, 5.98084459321745920413e-01,
	8.10679938859144910701e-01, 5.85489570130274028514e-01,
	8.19728883213368231253e-01, 5.72751742053888568407e-01,
	8.28577702516849257108e-01, 5.59874084854710574177e-01,
	8.37224236455711978699e-01, 5.46859742430497508536e-01,
	8.45666374107491569667e-01, 5.33711892039036461810e-01,
	8.53902054441761149128e-01, 5.20433743544881588505e-01,
	8.61929266833302509809e-01, 5.07028538621057900393e-01,
	8.69746051561515076678e-01, 4.93499549942200410602e-01,
	8.77350500260862697921e-01, 4.79850080433476600117e-01,
	8.84740756420631879742e-01, 4.66083462405874393575e-01,
	8.91915015812867362222e-01, 4.52203056787028545571e-01,
	8.98871526946913745881e-01, 4.38212252275223035358e-01,
	9.05608591487805036913e-01, 4.24114464529888268718e-01,
	9.12124564678846838639e-01, 4.09913135321892496687e-01,
	9.18417855741508804002e-01, 3.95611731695571844369e-01,
	9.24486928255549345046e-01, 3.81213745141251114656e-01,
	9.30330300545781363475e-01, 3.66722690716563270996e-01,
	9.35946546034209125864e-01, 3.52142106210879102246e-01,
	9.41334293596668869597e-01, 3.37475551260917883134e-01,
	9.46492227896101323559e-01, 3.22726606483374089951e-01,
	9.51419089686698082886e-01, 3.07898872650964328113e-01,
	9.56113676155394554002e-01, 2.92995969713948978264e-01,
	9.60574841181938254842e-01, 2.78021536015277237475e-01,
	9.64801495637480077683e-01, 2.62979227346346711158e-01,
	9.68792607644664016675e-01, 2.47872716072285947941e-01,
	9.72547202831614887586e-01, 2.32705690227810568782e-01,
	9.76064364566613607010e-01, 2.17481852629530458820e-01,
	9.79343234187565414572e-01, 2.02204919947659544910e-01,
	9.82383011202836109454e-01, 1.86878621837941599759e-01,
	9.85182953494231017366e-01, 1.71506699998524386741e-01,
	9.87742377497998091940e-01, 1.56092907252707135957e-01,
	9.90060658366647028394e-01, 1.40641006660935985462e-01,
	9.92137230124395808062e-01, 1.25154770588626285122e-01,
	9.93971585806359803072e-01, 1.09637979777038541140e-01,
	9.95563277581850036846e-01, 9.40944224196323536491e-02,
	9.96911916861350277941e-01, 7.85278932598362233719e-02,
	9.98017174394052908326e-01, 6.29421926414276133865e-02,
	9.98878780347215333713e-01, 4.73411255892753485286e-02,
	9.99496524372108563483e-01, 3.17285008797294557081e-02,
	9.99870255655346151791e-01, 1.61081301122361006395e-02,
	9.99999882955821872699e-01, 4.83826769160181427432e-04,
	9.99885374626887313276e-01, -1.51405946795101862407e-02,
	9.99526758624139421983e-01, -3.07613197753498594789e-02,
	9.98924122498464628350e-01, -4.63745349375326090802e-02,
	9.98077613374894423437e-01, -6.19764284214149308028e-02,
	9.96987437916807328619e-01, -7.75631912448182664344e-02,
	9.95653862273598311283e-01, -9.31310181393209396417e-02,
	9.94077212020575529117e-01, -1.08676108420387079745e-01,
	9.92257872072439317535e-01, -1.24194666996109981394e-01,
	9.90196286596708996619e-01, -1.39682905217811598186e-01,
	9.87892958898728967831e-01, -1.55137041864005509328e-01,
	9.85348451302295424981e-01, -1.70553304031812708041e-01,
	9.82563385014030843401e-01, -1.85927928052160545969e-01,
	9.79538439968065888230e-01, -2.01257160431443482551e-01,
	9.76274354660002341433e-01, -2.16537258764389006771e-01,
	9.72771925969731610095e-01, -2.31764492632368090952e-01,
	9.69032008956924317822e-01, -2.46935144556029828600e-01,
	9.65055516693764658953e-01, -2.62045510739892129060e-01,
	9.60843419958733790942e-01, -2.77091902303196746526e-01,
	9.56396747083171572257e-01, -2.92070645852553878452e-01,
	9.51716583658057113659e-01, -3.06978084543891138747e-01,
	9.46804072278775166183e-01, -3.21810578937871294425e-01,
	9.41660412264228252610e-01, -3.36564507894643705210e-01,
	9.36286859366077139910e-01, -3.51236269451786098372e-01,
	9.30684725460523609719e-01, -3.65822281708577445869e-01,
	9.24855378224429758305e-01, -3.80318983708869018390e-01,
	9.18800240811794344253e-01, -3.94722836284130795814e-01,
	9.12520791499566663596e-01, -4.09030322935848345001e-01,
	9.06018563323250702979e-01, -4.23237950701107090712e-01,
	8.99295143708603639254e-01, -4.37342250991282488481e-01,
	8.92352174084417359978e-01, -4.51339780439098559039e-01,
	8.85191349474114597129e-01, -4.65227121754735961634e-01,
	8.77814418087698666859e-01, -4.79000884547570504601e-01,
	8.70223180902864101860e-01, -4.92657706140177065190e-01,
	8.62419491209962973954e-01, -5.06194252418129098103e-01,
	8.54405254167239447405e-01, -5.19607218629047684644e-01,
	8.46182426332270809510e-01, -5.32893330195106762481e-01,
	8.37753015193838712626e-01, -5.46049343497116423940e-01,
	8.29119078677651999421e-01, -5.59072046674417011403e-01,
	8.20282724626069215113e-01, -5.71958260435175724901e-01,
	8.11246110312714763246e-01, -5.84704838788333125521e-01,
	8.02011441899084687179e-01, -5.97308669837422590021e-01,
	7.92580973890125495274e-01, -6.09766676547169317324e-01,
	7.82957008603788473522e-01, -6.22075817467780289860e-01,
	7.73141895594474215514e-01, -6.34233087497477643346e-01,
	7.63138031079152456826e-01, -6.46235518615801973752e-01,
	7.52947857359473227135e-01, -6.58080180599429964694e-01,
	7.42573862219235825144e-01, -6.69764181745192588302e-01,
	7.32018578314804879703e-01, -6.81284669577975954269e-01,
	7.21284582577006005977e-01, -6.92638831525286491342e-01,
	7.10374495555637031075e-01, -7.03823895633044149811e-01,
	6.99290980797484418297e-01, -7.14837131223114541356e-01,
	6.88036744157449198234e-01, -7.25675849597612554476e-01,
	6.76614533221899572268e-01, -7.36337404613476742554e-01,
	6.65027136549188546688e-01, -7.46819193415104276568e-01,
	6.53277383052505156158e-01, -7.57118657009633100330e-01,
	6.41368141233487065733e-01, -7.67233280958732777322e-01,
	6.29302318589868403542e-01, -7.77160595898567008177e-01,
	6.17082860810903133242e-01, -7.86898178224750721732e-01,
	6.04712751105658807838e-01, -7.96443650643424705393e-01,
	5.92195009450509846083e-01, -8.05794682770934245220e-01,
	5.79532691867931770702e-01, -8.14948991689853463605e-01,
	5.66728889706594629594e-01, -8.23904342488817387213e-01,
	5.53786728799491090314e-01, -8.32658548869558479133e-01,
	5.40709368819720759269e-01, -8.41209473597735457595e-01,
	5.27500002380493770993e-01, -8.49555029111463189118e-01,
	5.14161854409658891640e-01, -8.57693177931374672873e-01,
	5.00698181184736190730e-01, -8.65621933270118271153e-01,
	4.87112269682015319727e-01, -8.73339359427499739574e-01,
	4.73407436683839610847e-01, -8.80843572317148937323e-01,
	4.59587028080454429446e-01, -8.88132739865035936155e-01,
	4.45654417892204612883e-01, -8.95205082544307417791e-01,
	4.31613007576607476956e-01, -9.02058873738668665077e-01,
	4.17466225094956511210e-01, -9.08692440215591923369e-01,
	4.03217524247773739798e-01, -9.15104162453376668296e-01,
	3.88870383625079307777e-01, -9.21292475134407928827e-01,
	3.74428305866518040812e-01, -9.27255867474522488259e-01,
	3.59894816812003803808e-01, -9.32992883591217014860e-01,
	3.45273464602750546071e-01, -9.38502122875176647554e-01,
	3.30567818825136694461e-01, -9.43782240327286303661e-01,
	3.15781469657649860316e-01, -9.48831946880402399280e-01,
	3.00918026974915431282e-01, -9.53650009721346392233e-01,
	2.85981119468962208252e-01, -9.58235252590552089025e-01,
	2.70974393771316324209e-01, -9.62586556066657106356e-01,
	2.55901513568614069616e-01, -9.66702857838587559236e-01,
	2.40766158683884484715e-01, -9.70583152971761897732e-01,
	2.25572024178931879179e-01, -9.74226494152062860721e-01,
	2.10322819513115238932e-01, -9.77631991902911057224e-01,
	1.95022267545207572681e-01, -9.80798814824694553671e-01,
	1.79674103687683967001e-01, -9.83726189782516358129e-01,
	1.64282074965636487596e-01, -9.86413402101261493904e-01,
	1.48849939140241666058e-01, -9.88859795733422641817e-01,
	1.33381463740289751829e-01, -9.91064773428305123559e-01,
	1.17880425165185737102e-01, -9.93027796873216961338e-01,
	1.02350607771443738447e-01, -9.94748386823932517764e-01,
	8.67958029390951818494e-02, -9.96226123223115322958e-01,
	7.12198081674702832000e-02, -9.97460645301151083153e-01,
	5.56264261071372570489e-02, -9.98451651667994988237e-01,
	4.00194636390110436430e-02, -9.99198900384726140800e-01,
	2.44027309972172715136e-02, -9.99702209020204901613e-01,
	8.78004077991816241078e-03, -9.99961454699081375708e-01,
	-6.84479296391702837776e-03, -9.99976574130254869388e-01,
	-2.24679556394218951643e-02, -9.99747563622630175395e-01,
	-3.80856331006515710924e-02, -9.99274479085362488107e-01,
	-5.36940124898220294547e-02, -9.98557436015947375019e-01,
	-6.92892832575160572128e-02, -9.97596609469809547655e-01,
	-8.48676380386628043118e-02, -9.96392234019183087312e-01,
	-1.00425273601341916163e-01, -9.94944603695148255262e-01,
	-1.15958391781735684067e-01, -9.93254071914831615508e-01,
	-1.31463200384306394541e-01, -9.91321051397939245753e-01,
	-1.46935914119801724897e-01, -9.89146014065556578032e-01,
	-1.62372755568482129984e-01, -9.86729490918913376696e-01,
	-1.77769956039573850948e-01, -9.84072071918356994225e-01,
	-1.93123756521520834051e-01, -9.81174405835688490107e-01,
	-2.08430408606563005725e-01, -9.78037200094199477007e-01,
	-2.23686175400125447643e-01, -9.74661220596605204491e-01,
	-2.38887332428331961021e-01, -9.71047291539024692852e-01,
	-2.54030168529570332669e-01, -9.67196295214595047618e-01,
	-2.69110986809851404633e-01, -9.63109171785954898404e-01,
	-2.84126105504238113397e-01, -9.58786919065437892584e-01,
	-2.99071858881536201125e-01, -9.54230592270622235418e-01,
	-3.13944598143160502612e-01, -9.49441303765919730751e-01,
	-3.28740692363219233485e-01, -9.44420222774031481450e-01,
	-3.43456529243486463621e-01, -9.39168575134420757777e-01,
	-3.58088516132365641820e-01, -9.33687642958886176991e-01,
	-3.72633080853157161449e-01, -9.27978764333475703019e-01,
	-3.87086672547184373894e-01, -9.22043333003578990947e-01,
	-4.01445762590873223008e-01, -9.15882798013933796533e-01,
	-4.15706845395529489551e-01, -9.09498663380709615467e-01,
	-4.29866439353555507275e-01, -9.02892487684716527063e-01,
	-4.43921087571260808424e-01, -8.96065883743795366101e-01,
	-4.57867358817895864220e-01, -8.89020518171051099543e-01,
	-4.71701848327647499381e-01, -8.81758110982984399939e-01,
	-4.85421178579811707365e-01, -8.74280435207254624785e-01,
	-4.99022000232008211551e-01, -8.66589316391822128693e-01,
	-5.12500992809901023683e-01, -8.58686632229048840692e-01,
	-5.25854865641323332426e-01, -8.50574312027670975667e-01,
	-5.39080358520030999969e-01, -8.42254336324791408330e-01,
	-5.52174242663304060130e-01, -8.33728736304085060738e-01,
	-5.65133321393192722404e-01, -8.24999593364201810886e-01,
	-5.77954430931352902689e-01, -8.16069038603239760299e-01,
	-5.90634441175508673183e-01, -8.06939252296785092256e-01,
	-6.03170256463835929850e-01, -7.97612463366358381833e-01,
	-6.15558816459891189332e-01, -7.88090948735295393490e-01,
	-6.27797096543907584554e-01, -7.78377033044423516372e-01,
	-6.39882108993420795073e-01, -7.68473087746169514212e-01,
	-6.51810903392718188343e-01, -7.58381530773507561705e-01,
	-6.63580567511655061708e-01, -7.48104825823834529430e-01,
	-6.75188227925781481176e-01, -7.37645481834222960238e-01,
	-6.86631050850229573967e-01, -7.27006052250123602221e-01,
	-6.97906242654146802273e-01, -7.16189134561793783185e-01,
	-7.09011050643817641870e-01, -7.05197369581700761465e-01,
	-7.19942763756367454242e-01, -6.94033440775618015728e-01,
	-7.30698713155769064009e-01, -6.82700073672548479742e-01,
	-7.41276272975477157345e-01, -6.71200035103981407225e-01,
	-7.51672860805046583188e-01, -6.59536132694151233657e-01,
	-7.61885938516202787518e-01, -6.47711213961349341339e-01,
	-7.71913012640803364306e-01, -6.35728165897814334606e-01,
	-7.81751635309322678857e-01, -6.23589913878664137137e-01,
	-7.91399404523052685256e-01, -6.11299421331770620469e-01,
	-8.00853964899717496451e-01, -5.98859688829029512824e-01,
	-8.10113008319712335492e-01, -5.86273753251146056975e-01,
	-8.19174274236826760465e-01, -5.73544687385881157837e-01,
	-8.28035550507897455397e-01, -5.60675598804766250893e-01,
	-8.36694673776658404130e-01, -5.47669629314764150330e-01,
	-8.45149530028187490061e-01, -5.34529954158916909002e-01,
	-8.53398055161871504914e-01, -5.21259781151332757254e-01,
	-8.61438235389631601358e-01, -5.07862350060326539491e-01,
	-8.69268107829002323328e-01, -4.94340931656873816546e-01,
	-8.76885760925650292741e-01, -4.80698827006935058836e-01,
	-8.84289334936661730602e-01, -4.66939366639049280305e-01,
	-8.91477022398163843064e-01, -4.53065909704210345588e-01,
	-8.98447068525225711610e-01, -4.39081843234753188554e-01,
	-9.05197771673453388530e-01, -4.24990581257296273776e-01,
	-9.11727483791179293959e-01, -4.10795563875518132679e-01,
	-9.18034610707084031134e-01, -3.96500256675695827990e-01,
	-9.24117612643078456536e-01, -3.82108149615860981374e-01,
	-9.29975004511545022545e-01, -3.67622756346437040698e-01,
	-9.35605356329172521690e-01, -3.53047613231079804308e-01,
	-9.41007293511755382731e-01, -3.38386278619096869669e-01,
	-9.46179497257704227309e-01, -3.23642331855951870256e-01,
	-9.51120704853153031699e-01, -3.08819372448752571536e-01,
	-9.55829709968717189383e-01, -2.93921019223052470970e-01,
	-9.60305362967905695726e-01, -2.78950909399985458315e-01,
	-9.64546571183209522360e-01, -2.63912697721639999404e-01,
	-9.68552299193694232748e-01, -2.48810055517474232323e-01,
	-9.72321569045517364316e-01, -2.33646669928897571245e-01,
	-9.75853460530087812863e-01, -2.18426242863471758993e-01,
	-9.79147111396304836717e-01, -2.03152490125698942380e-01,
	-9.82201717531947959827e-01, -1.87829140649930864670e-01,
	-9.85016533205280153673e-01, -1.72459935382833828843e-01,
	-9.87590871221861066331e-01, -1.57048626479970948600e-01,
	-9.89924103089018792012e-01, -1.41598976420741456961e-01,
	-9.92015659185421450061e-01, -1.26114756991058563074e-01,
	-9.93865028889118318212e-01, -1.10599748423005059261e-01,
	-9.95471760691319929037e-01, -9.50577385914659067634e-02,
	-9.96835462344218936614e-01, -7.94925217425341834598e-02,
	-9.97955800916290658442e-01, -6.39078979276023889655e-02,
	-9.98832502892746831868e-01, -4.83076719063431220258e-02,
	-9.99465354238023406808e-01, -3.26956522776712110723e-02,
	-9.99854200451614993916e-01, -1.70756504784357332483e-02,
	-9.99998946602528415717e-01, -1.45147987706449187358e-03,
	-9.99899557352339485305e-01, 1.41730450713867285606e-02,
	-9.99556056965451689145e-01, 2.97941098823021957576e-02,
	-9.98968529303411734155e-01, 4.54079008695470534573e-02,
	-9.98137117802025963798e-01, 6.10106061751933687054e-02,
	-9.97062025438244736719e-01, 7.65984166219185330649e-02,
	-9.95743514682696617690e-01, 9.21675266422526118237e-02,
	-9.94181907425219280050e-01, 1.07714135322866152999e-01,
	-9.92377584917212285376e-01, 1.23234447107459038628e-01,
	-9.90330987653228356216e-01, 1.38724672981345553691e-01,
	-9.88042615281836456020e-01, 1.54181031216647779214e-01,
	-9.85513026476385278762e-01, 1.69599748364658631239e-01,
	-9.82742838804682716791e-01, 1.84977060140206039929e-01,
	-9.79732728555263054915e-01, 2.00309212463279484595e-01,
	-9.76483430616286174342e-01, 2.15592462140605983789e-01,
	-9.72995738247511954278e-01, 2.30823078032026951512e-01,
	-9.69270502929450938900e-01, 2.45997341755737758406e-01,
	-9.65308634114379171542e-01, 2.61111548776057855736e-01,
	-9.61111099038787108917e-01, 2.76162009162112587202e-01,
	-9.56678922485658334018e-01, 2.91145048509638459944e-01,
	-9.52013186489632401432e-01, 3.06057008986653333871e-01,
	-9.47115030121562395671e-01, 3.20894250054175877995e-01,
	-9.41985649202698782645e-01, 3.35653149391108962529e-01,
	-9.36626296000886870985e-01, 3.50330103815899684960e-01,
	-9.31038278925287121623e-01, 3.64921530162087393023e-01,
	-9.25222962204842236389e-01, 3.79423866156172462372e-01,
	-9.19181765559584973424e-01, 3.93833571274420646269e-01,
	-9.12916163872961705650e-01, 4.08147127564896294860e-01,
	-9.06427686803489396361e-01, 4.22361040575566504263e-01,
	-8.99717918410242289973e-01, 4.36471840204543548580e-01,
	-8.92788496793018526709e-01, 4.50476081489419755144e-01,
	-8.85641113671704172106e-01, 4.64370345494136360642e-01,
	-8.78277513965914136129e-01, 4.78151240155093082418e-01,
	-8.70699495405757306621e-01, 4.91815401040023969514e-01,
	-8.62908908048144129843e-01, 5.05359492253939501794e-01,
	-8.54907653871092576559e-01, 5.18780207171229856833e-01,
	-8.46697686222891654495e-01, 5.32074269388026044325e-01,
	-8.38281009508205721126e-01, 5.45238433254574883513e-01,
	-8.29659678498936070667e-01, 5.58269484991829045839e-01,
	-8.20835797971514846694e-01, 5.71164243250981584765e-01,
	-8.11811522157973475267e-01, 5.83919559949445554636e-01,
	-8.02589054191142126093e-01, 5.96532321079560556853e-01,
	-7.93170645644559635379e-01, 6.08999447362468804279e-01,
	-7.83558595847759331576e-01, 6.21317895181756174594e-01,
	-7.73755251444074421130e-01, 6.33484657164415598807e-01,
	-7.63763005819449558587e-01, 6.45496762921116018497e-01,
	-7.53584298396099971917e-01, 6.57351279918779618505e-01,
	-7.43221614171602262822e-01, 6.69045314031985416392e-01,
	-7.32677483058112311021e-01, 6.80576010317458623966e-01,
	-7.21954479231692536345e-01, 6.91940553745258979390e-01,
	-7.11055220593523329420e-01, 7.03136169789818077369e-01,
	-6.99982367997418419847e-01, 7.14160125246941168697e-01,
	-6.88738624756222161949e-01, 7.25009728740868553132e-01,
	-6.77326735865867002317e-01, 7.35682331500009611958e-01,
	-6.65749487360529190738e-01, 7.46175327975397872926e-01,
	-6.54009705667427665432e-01, 7.56486156444917789976e-01,
	-6.42110256878597240870e-01, 7.66612299673897656938e-01,
	-6.30054046069779882799e-01, 7.76551285512489308793e-01,
	-6.17844016641709514737e-01, 7.86300687459981162419e-01,
	-6.05483149427811451204e-01, 7.95858125396090021475e-01,
	-5.92974462184078454641e-01, 8.05221265986873269149e-01,
	-5.80321008740226185196e-01, 8.14387823346301220617e-01,
	-5.67525878248187232167e-01, 8.23355559596596009442e-01,
	-5.54592194460652221366e-01, 8.32122285390385463266e-01,
	-5.41523114921985349035e-01, 8.40685860476545809838e-01,
	-5.28321830279222970361e-01, 8.49044194168013799384e-01,
	-5.14991563445484024086e-01, 8.57195245892075630145e-01,
	-5.01535568812419785267e-01, 8.65137025687840122146e-01,
	-4.87957131464199334037e-01, 8.72867594686175807261e-01,
	-4.74259566375507701785e-01, 8.80385065582847903265e-01,
	-4.60446217616484521074e-01, 8.87687603091691812551e-01,
	-4.46520457522199765155e-01, 8.94773424400929218159e-01,
	-4.32485685857187662773e-01, 9.01640799614035870491e-01,
	-4.18345329015600841949e-01, 9.08288052156819181171e-01,
	-4.04102839158860249746e-01, 9.14713559199681003342e-01,
	-3.89761693387688290535e-01, 9.20915752046603697245e-01,
	-3.75325392887144893006e-01, 9.26893116521052995438e-01,
	-3.60797462091837162212e-01, 9.32644193327814230443e-01,
	-3.46181447754430826613e-01, 9.38167578437160809557e-01,
	-3.31480918189186846146e-01, 9.43461923384538936332e-01,
	-3.16699462305234713533e-01, 9.48525935636751693636e-01,
	-3.01840688808588275549e-01, 9.53358378879399670502e-01,
	-2.86908225223433177575e-01, 9.57958073351407035645e-01,
	-2.71905717092672694069e-01, 9.62323896103759568454e-01,
	-2.56836827106365517270e-01, 9.66454781271185447977e-01,
	-2.41705234084330145006e-01, 9.70349720366960877271e-01,
	-2.26514632188532627488e-01, 9.74007762497041795768e-01,
	-2.11268729991721526673e-01, 9.77428014601425809715e-01,
	-1.95971249573089145724e-01, 9.80609641672343546048e-01,
	-1.80625925602857506647e-01, 9.83551866959801457391e-01,
	-1.65236504388101917984e-01, 9.86253972168224413153e-01,
	-1.49806743037279310737e-01, 9.88715297616337362996e-01,
	-1.34340408538235145386e-01, 9.90935242401732363504e-01,
	-1.18841276732320783038e-01, 9.92913264562737096774e-01,
	-1.03313131549733094872e-01, 9.94648881188425981748e-01,
	-8.77597639605576101962e-02, 9.96141668554020087711e-01,
	-7.21849710624100776579e-02, 9.97391262219956997725e-01,
	-5.65925552406322598942e-02, 9.98397357113557260000e-01,
	-4.09863231473179684405e-02, 9.99159707611782965664e-01,
	-2.53700848500082870585e-02, 9.99678127596429599855e-01,
	-9.74765281333290004029e-03, 9.99952490503739244154e-01,
	5.87715899658624793545e-03, 9.99982729351926780126e-01,
	2.15005359577336609134e-02, 9.99768836758543000265e-01,
	3.71186638844091532086e-02, 9.99310864942154153390e-01,
	5.27277298119544560184e-02, 9.98608925710599448777e-01,
	6.83239230305028866219e-02, 9.97663190431380964007e-01,
	8.39034359259593492952e-02, 9.96473889994022088423e-01,
	9.94624650198910192911e-02, 9.95041314746361149624e-01,
	1.14997211772979862632e-01, 9.93365814433152527485e-01,
	1.30503883601530007441e-01, 9.91447798103822663940e-01,
	1.45978694798140268274e-01, 9.89287734011208397256e-01,
	1.61417867390196478894e-01, 9.86886149506213783411e-01,
	1.76817632086965909055e-01, 9.84243630908099076393e-01,
	1.92174229316510819521e-01, 9.81360823340021615202e-01,
	2.07483909972419000578e-01, 9.78238430599900898876e-01,
	2.22742936384479617296e-01, 9.74877214981876405453e-01,
	2.37947583337762752498e-01, 9.71277997065576714775e-01,
	2.53094138761417730699e-01, 9.67441655566172231673e-01,
	2.68178904913313143066e-01, 9.63369127053330553956e-01,
	2.83198199008898365836e-01, 9.59061405791160170864e-01,
	2.98148354355895761625e-01, 9.54519543432648220893e-01,
	3.13025720984674848957e-01, 9.49744648840952665481e-01,
	3.27826666953088208256e-01, 9.44737887688658850571e-01,
	3.42547578723123691269e-01, 9.39500482336717790410e-01,
	3.57184862422095295020e-01, 9.34033711413302714099e-01,
	3.71734944552921997563e-01, 9.28338909557407276907e-01,
	3.86194272922183889918e-01, 9.22417467073399333088e-01,
	4.00559317492650446280e-01, 9.16270829596698477282e-01,
	4.14826571255144882500e-01, 9.09900497736263580428e-01,
	4.28992551069135752417e-01, 9.03308026714694345394e-01,
	4.43053798493044215245e-01, 8.96495025998965022751e-01,
	4.57006880688855809947e-01, 8.89463158879018389591e-01,
	4.70848391227359996947e-01, 8.82214142075838037016e-01,
	4.84574950851524355322e-01, 8.74749745359918784438e-01,
	4.98183208470846405902e-01, 8.67071791028685923131e-01,
	5.11669841801385194557e-01, 8.59182153557058847504e-01,
	5.25031558273095666500e-01, 8.51082759088283347104e-01,
	5.38265095838926344030e-01, 8.42775584958125989488e-01,
	5.51367223674840811753e-01, 8.34262659272904327779e-01,
	5.64334743129053073574e-01, 8.25546060312485341370e-01,
	5.77164488339731551747e-01, 8.16627916127985353789e-01,
	5.89853327114563730227e-01, 8.07510403952716560028e-01,
	6.02398161667909270989e-01, 7.98195749687458211419e-01,
	6.14795929310800737255e-01, 7.88686227407876638829e-01,
	6.27043603440996633047e-01, 7.78984158621810585110e-01,
	6.39138193783907904155e-01, 7.69091912092854990135e-01,
	6.51076747732772576072e-01, 7.59011902779999636515e-01,
	6.62856350634406732425e-01, 7.48746591594002808279e-01,
	6.74474126652610750376e-01, 7.38298484676894073431e-01,
	6.85927239488512419108e-01, 7.27670132771483846312e-01,
	6.97212893028884672653e-01, 7.16864130637244967303e-01,
	7.08328332056515685977e-01, 7.05883116391116449684e-01,
	7.19270842858181325141e-01, 6.94729770928295131682e-01,
	7.30037753982098469585e-01, 6.83406817174640912604e-01,
	7.40626436901593243611e-01, 6.71917019402284765306e-01,
	7.51034306483622016160e-01, 6.60263182742052423535e-01,
	7.61258821807797358971e-01, 6.48448152298858992992e-01,
	7.71297486713702129535e-01, 6.36474812533164180373e-01,
	7.81147850424134593261e-01, 6.24346086539952493943e-01,
	7.90807508031525441261e-01, 6.12064935477412253029e-01,
	8.00274101326324149852e-01, 5.99634357543281759639e-01,
	8.09545319236430693799e-01, 5.87057387401253572001e-01,
	8.18618898249645288168e-01, 5.74337095640301553701e-01,
	8.27492623168671781464e-01, 5.61476587758947043305e-01,
	8.36164327654276950952e-01, 5.48479003388890884452e-01,
	8.44631894603476873762e-01, 5.35347515748920921297e-01,
	8.52893256793554432882e-01, 5.22085330684634363330e-01,
	8.60946397328884449607e-01, 5.08695685971892852528e-01,
	8.68789350153792105935e-01, 4.95181850494696151888e-01,
	8.76420200509378299891e-01, 4.81547123487516159912e-01,
	8.83837085454141080376e-01, 4.67794833635354845303e-01,
	8.91038194240763248288e-01, 4.53928338401734798868e-01,
	8.98021768869999070795e-01, 4.39951022996421692302e-01,
	9.04786104293555437650e-01, 4.25866300001880193626e-01,
	9.11329549200603827863e-01, 4.11677607787725330368e-01,
	9.17650506064666360295e-01, 3.97388410398770597354e-01,
	9.23747431723077494503e-01, 3.83002196318791732210e-01,
	9.29618837697029576361e-01, 3.68522477738907783262e-01,
	9.35263290560562010612e-01, 3.53952789690701208336e-01,
	9.40679412304837647696e-01, 3.39296689146571628370e-01,
	9.45865880661811875285e-01, 3.24557754182295044032e-01,
	9.50821429431150111355e-01, 3.09739583092804637854e-01,
	9.55544848784945832776e-01, 2.94845793526980815003e-01,
	9.60034985637467253028e-01, 2.79880021352128749434e-01,
	9.64290743580318188144e-01, 2.64845920952762714506e-01,
	9.68311083831862262628e-01, 2.49747162002622591359e-01,
	9.72095024823529496594e-01, 2.34587430851146777622e-01,
	9.75641642748477533331e-01, 2.19370428579268944569e-01,
	9.78950071770562035844e-01, 2.04099870113656461923e-01,
	9.82019504170923540620e-01, 1.88779483598969205493e-01,
	9.84849190595408208182e-01, 1.73413009268535894813e-01,
	9.87438440210647860873e-01, 1.58004198660550820854e-01,
	9.89786620894844482166e-01, 1.42556813578185059832e-01,
	9.91893159367450705233e-01, 1.27074625319365142051e-01,
	9.93757541353338824663e-01, 1.11561413595234956708e-01,
	9.95379311685924861308e-01, 9.60209657713066710993e-02,
	9.96758074438687136087e-01, 8.04570757688883031467e-02,
	9.97893492999770703733e-01, 6.48735433648924275651e-02,
	9.98785290176304019205e-01, 4.92741730264058125366e-02,
	9.99433248251151762354e-01, 3.36627730609296640929e-02,
	9.99837209032161888800e-01, 1.80431547900308138221e-02,
	9.99997073896832011641e-01, 2.41913161566219324719e-03,
	9.99912803818512774257e-01, -1.32054821873487954892e-02,
	9.99584419370001642235e-01, -2.88268720595330242562e-02,
	9.99012000721555049054e-01, -4.44412242666163900817e-02,
	9.98195687620527460915e-01, -6.00447267941353959864e-02,
	9.97135679355775073063e-01, -7.56335702958476074897e-02,
	9.95832234722008102779e-01, -9.12039488650100010902e-02,
	9.94285671925894676271e-01, -1.06752061351864019345e-01,
	9.92496368545773943737e-01, -1.22274111828511194977e-01,
	9.90464761404806215417e-01, -1.37766310886661608182e-01
};

const double _TBL_sincosx[] = {
	1.64062500000167837966e-01, 1.79687499999472477530e-01,
	1.95312499999996669331e-01, 2.10937500000106192832e-01,
	2.26562499999874683576e-01, 2.42187499999999750200e-01,
	2.57812499999549193941e-01, 2.73437500000180466753e-01,
	2.89062500000347444296e-01, 3.04687500000159650071e-01,
	3.20312500001052657961e-01, 3.35937499999853450561e-01,
	3.51562499998759436792e-01, 3.67187499998127386824e-01,
	3.82812499999808708573e-01, 3.98437499999694078046e-01,
	4.14062499999775512904e-01, 4.29687499999869215728e-01,
	4.45312499999981514787e-01, 4.60937499992721433362e-01,
	4.76562499999932387418e-01, 4.92187500000263733479e-01,
	5.07812500002462252624e-01, 5.23437499998664290679e-01,
	5.39062500000133337785e-01, 5.54687499999937494444e-01,
	5.70312499999814259688e-01, 5.85937500002074562744e-01,
	6.01562499999652833260e-01, 6.17187499999419131314e-01,
	6.32812500000347721851e-01, 6.48437500005533351555e-01,
	6.64062499997531863194e-01, 6.79687499999813815599e-01,
	6.95312500005013212068e-01, 7.10937499999876987289e-01,
	7.26562500001548428052e-01, 7.42187500000339617223e-01,
	7.57812499998633315457e-01, 7.73437500000337285755e-01,
	7.89062499996497468402e-01, 8.04687500000179967152e-01,
	8.20312500001350475287e-01, 8.35937499996779354028e-01,
	8.51562500000668243239e-01, 8.67187499999485522650e-01,
	8.82812500000538014078e-01, 8.98437500000525690602e-01,
	9.14062500000757727214e-01, 9.29687500002357114504e-01,
	9.45312499999430455588e-01, 9.60937500000796696042e-01,
	9.76562500001389000026e-01, 9.92187499998313238159e-01,
	1.00781250000027000624e+00, 1.02343750000073119288e+00,
	1.03906249999567279474e+00, 1.05468750000121480603e+00,
	1.07031249999813948826e+00, 1.08593749999936250994e+00,
	1.10156249999885291757e+00, 1.11718750000074029671e+00,
	1.13281249999926680871e+00, 1.14843749999650057703e+00,
	1.16406249999956079577e+00, 1.17968749999995736744e+00,
	1.19531250000235189646e+00, 1.21093750000001554312e+00,
	1.22656249999714606069e+00, 1.24218750000679789558e+00,
	1.25781249999789324079e+00, 1.27343750000030864200e+00,
	1.28906250000041366910e+00, 1.30468750000013344881e+00,
	1.32031249999823008245e+00, 1.33593749999817146268e+00,
	1.35156249999504352033e+00, 1.36718750000051336713e+00,
	1.38281250000255573340e+00, 1.39843749999889488400e+00,
	1.41406250000066702199e+00, 1.42968750000377853304e+00,
	1.44531250000268074452e+00, 1.46093749999857935862e+00,
	1.47656250000000177636e+00, 1.49218750000007549517e+00,
	1.50781249999986965982e+00, 1.52343749999979238829e+00,
	1.53906250000026356695e+00, 1.55468750000024247271e+00,
	1.57031250000686006807e+00, 1.58593749999970379250e+00,
	1.60156249999876076906e+00, 1.61718749999920530236e+00,
	1.63281249999894950697e+00, 1.64843749999433342168e+00,
	1.66406250000158717484e+00, 1.67968749999775224246e+00,
	1.69531250000185917948e+00, 1.71093749999863442568e+00,
	1.72656249999789279670e+00, 1.74218750000263478128e+00,
	1.75781250000296740410e+00, 1.77343749999920641258e+00,
	1.78906249999844191301e+00, 1.80468749999888578017e+00,
	1.82031250003296385387e+00, 1.83593749999912847493e+00,
	1.85156249999896371783e+00, 1.86718749999873900869e+00,
	1.88281249999986122212e+00, 1.89843750000025601743e+00,
	1.91406250000089750429e+00, 1.92968749999936717288e+00,
	1.94531249999502553472e+00, 1.96093749999814637164e+00,
	1.97656250000163713487e+00, 1.99218750000058819616e+00,
	2.00781250000015099033e+00, 2.02343750000025890401e+00,
	2.03906249999571986820e+00, 2.05468749999347455315e+00,
	2.07031249999880184731e+00, 2.08593749999950617280e+00,
	2.10156249999859534583e+00, 2.11718749999749178414e+00,
	2.13281250000269562150e+00, 2.14843750000770983277e+00,
	2.16406250000204325445e+00, 2.17968750000288169488e+00,
	2.19531250000207567297e+00, 2.21093749999685940111e+00,
	2.22656249999882449586e+00, 2.24218750000040500936e+00,
	2.25781249999956967756e+00, 2.27343749999970867748e+00,
	2.28906249999833111275e+00, 2.30468749999696020936e+00,
	2.32031250000405675493e+00, 2.33593750000527755617e+00,
	2.35156250000277511347e+00, 2.36718749998901101250e+00,
	2.38281250000068833828e+00, 2.39843750000151390012e+00,
	2.41406250000618571860e+00, 2.42968749999278221807e+00,
	2.44531250000394617672e+00, 2.46093750000379341003e+00,
	2.47656250000329514194e+00, 2.49218749999781508109e+00,
	2.50781249999807354101e+00, 2.52343750000954214485e+00,
	2.53906250000098099306e+00, 2.55468750001107025582e+00,
	2.57031250000341415785e+00, 2.58593750002171240965e+00,
	2.60156250000635891340e+00, 2.61718750000451771953e+00,
	2.63281250000028421709e+00, 2.64843750001994493459e+00,
	2.66406250000455235849e+00, 2.67968749999316235844e+00,
	2.69531249997396704643e+00, 2.71093749999957500663e+00,
	2.72656249999638511383e+00, 2.74218749999314947985e+00,
	2.75781249999954258811e+00, 2.77343750000063726802e+00,
	2.78906249999834177089e+00, 2.80468750000019895197e+00,
	2.82031249999983835153e+00, 2.83593749999777511306e+00,
	2.85156249999855315735e+00, 2.86718750000235678144e+00,
	2.88281249999902611236e+00, 2.89843749999328359479e+00,
	2.91406250000365130148e+00, 2.92968749999994892974e+00,
	2.94531249999847322130e+00, 2.96093749999701350006e+00,
	2.97656250000468292072e+00, 2.99218750000308997272e+00,
	3.00781249999819877416e+00, 3.02343749999709299203e+00,
	3.03906249999948618878e+00, 3.05468750000752597984e+00,
	3.07031250000433075797e+00, 3.08593749999511279825e+00,
	3.10156249999957589480e+00, 3.11718749999961186603e+00,
	3.13281249999836441944e+00, 3.14843750000262057043e+00,
	3.16406249999657873673e+00, 3.17968750000540190115e+00,
	3.19531250000325739435e+00, 3.21093750000270583556e+00,
	3.22656250000035882408e+00, 3.24218749999618305324e+00,
	3.25781250000001199041e+00, 3.27343750000431255032e+00,
	3.28906249999634914261e+00, 3.30468749999773381276e+00,
	3.32031250000108801856e+00, 3.33593750000042854609e+00,
	3.35156249999819699781e+00, 3.36718749999951061369e+00,
	3.38281250000727817806e+00, 3.39843750000385558252e+00,
	3.41406250000184297022e+00, 3.42968750000183808524e+00,
	3.44531249999830135877e+00, 3.46093749998354383024e+00,
	3.47656249999984101606e+00, 3.49218750000081934459e+00,
	3.50781249999577759979e+00, 3.52343749999866640010e+00,
	3.53906249999683852892e+00, 3.55468750000498978636e+00,
	3.57031249999826005848e+00, 3.58593750001092637092e+00,
	3.60156250000782085507e+00, 3.61718749999987299049e+00,
	3.63281250000544186918e+00, 3.64843749999226352188e+00,
	3.66406250000062438943e+00, 3.67968749999757616109e+00,
	3.69531250001872235700e+00, 3.71093750000574784664e+00,
	3.72656249999563016218e+00, 3.74218749999581179466e+00,
	3.75781250000033528735e+00, 3.77343749999415045693e+00,
	3.78906249995283994636e+00, 3.80468750000592104143e+00,
	3.82031249998920063859e+00, 3.83593750000164934733e+00,
	3.85156250000057731597e+00, 3.86718750000405053768e+00,
	3.88281249997192157153e+00, 3.89843749998371702503e+00,
	3.91406249999986277643e+00, 3.92968749999597033451e+00,
	3.94531249999519229021e+00, 3.96093749997563104870e+00,
	3.97656250000223510099e+00, 3.99218750000022870594e+00,
	4.00781250004454392410e+00, 4.02343749999355093649e+00,
	4.03906249999698196973e+00, 4.05468749999250022142e+00,
	4.07031249994990851349e+00, 4.08593749999590372113e+00,
	4.10156249999066258027e+00, 4.11718749999303490483e+00,
	4.13281249999853184107e+00, 4.14843749998088373587e+00,
	4.16406249999834177089e+00, 4.17968749999662758654e+00,
	4.19531249999891109326e+00, 4.21093749999872102308e+00,
	4.22656249999120881000e+00, 4.24218750000338129524e+00,
	4.25781250000494537744e+00, 4.27343749997698019172e+00,
	4.28906250000330668826e+00, 4.30468749999959232611e+00,
	4.32031250000562039304e+00, 4.33593749999550670537e+00,
	4.35156250000948219281e+00, 4.36718750000763922259e+00,
	4.38281249999987476684e+00, 4.39843750000314237525e+00,
	4.41406250000408473255e+00, 4.42968750000079314333e+00,
	4.44531249998868371875e+00, 4.46093750000322319949e+00,
	4.47656249999480770896e+00, 4.49218749997964028609e+00,
	4.50781250000320810045e+00, 4.52343749999724753508e+00,
	4.53906249999181721222e+00, 4.55468750000258193467e+00,
	4.57031249999976196818e+00, 4.58593750000821920310e+00,
	4.60156250004601385939e+00, 4.61718750000444977388e+00,
	4.63281249999695177166e+00, 4.64843749999638600201e+00,
	4.66406250000544897460e+00, 4.67968749999663469197e+00,
	4.69531249998381028377e+00, 4.71093749999796340688e+00,
	4.72656250000119992905e+00, 4.74218750001258992910e+00,
	4.75781250000492050845e+00, 4.77343750000340971695e+00,
	4.78906250000747402140e+00, 4.80468749998990762862e+00,
	4.82031250001256594828e+00, 4.83593750000031530334e+00,
	4.85156250000026023628e+00, 4.86718750000094679820e+00,
	4.88281250000185362836e+00, 4.89843749997600141910e+00,
	4.91406249999471889112e+00, 4.92968749998860822359e+00,
	4.94531250000475353090e+00, 4.96093749999659205940e+00,
	4.97656250000856825721e+00, 4.99218750002637179364e+00,
	5.00781249999760014191e+00, 5.02343749998691091463e+00,
	5.03906249999699618058e+00, 5.05468750000537525580e+00,
	5.07031250000353406193e+00, 5.08593749999286881547e+00,
	5.10156249998831601289e+00, 5.11718750000479172257e+00,
	5.13281250001085087575e+00, 5.14843750000346744855e+00,
	5.16406250000581845683e+00, 5.17968750000350119933e+00,
	5.19531249999482636071e+00, 5.21093750000432454073e+00,
	5.22656250000434585701e+00, 5.24218750001077093970e+00,
	5.25781249998869881779e+00, 5.27343750002139977084e+00,
	5.28906249999702104958e+00, 5.30468749998945909851e+00,
	5.32031249999385913441e+00, 5.33593749999546851370e+00,
	5.35156250001908162517e+00, 5.36718749999724487054e+00,
	5.38281249999679634044e+00, 5.39843750001770139590e+00,
	5.41406249999678212959e+00, 5.42968749999906563630e+00,
	5.44531250000517097476e+00, 5.46093749999811794993e+00,
	5.47656250001082511858e+00, 5.49218749999457500621e+00,
	5.50781250001214406353e+00, 5.52343750001415045858e+00,
	5.53906250000498356911e+00, 5.55468750000498889818e+00,
	5.57031250000316013882e+00, 5.58593750000908428888e+00,
	5.60156250002763478335e+00, 5.61718749999503863535e+00,
	5.63281250000129496414e+00, 5.64843750001081890133e+00,
	5.66406250000738609174e+00, 5.67968750000023270275e+00,
	5.69531249998335997731e+00, 5.71093749999160404940e+00,
	5.72656250000217958984e+00, 5.74218750000474997819e+00,
	5.75781250000163868918e+00, 5.77343749999750688318e+00,
	5.78906249999925304195e+00, 5.80468749999988631316e+00,
	5.82031249999487254598e+00, 5.83593749999551025809e+00,
	5.85156249999513455862e+00, 5.86718749999803179662e+00,
	5.88281250000295141689e+00, 5.89843750000985433957e+00,
	5.91406249999845634591e+00, 5.92968750000455990801e+00,
	5.94531250000243982612e+00, 5.96093750000733901828e+00,
	5.97656249999234212567e+00, 5.99218749999141753193e+00,
	6.00781250000843591863e+00, 6.02343749999880984092e+00,
	6.03906249999745359247e+00, 6.05468750000370548037e+00,
	6.07031250001220445967e+00, 6.08593750001188915633e+00,
	6.10156249999290700714e+00, 6.11718749998957456171e+00,
	6.13281249999975663911e+00, 6.14843749999015098950e+00,
	6.16406250000358646446e+00, 6.17968750000026467717e+00,
	6.19531249998414246249e+00, 6.21093749998937294521e+00,
	6.22656249999281197205e+00, 6.24218750000707967018e+00,
	6.25781250000234834374e+00, 6.27343749999462829692e+00,
	6.28906250001052136156e+00, 6.30468750000171862524e+00,
	6.32031250000594013727e+00, 6.33593750000045385917e+00,
	6.35156250000499689179e+00, 6.36718749999230215764e+00,
	6.38281249999868105505e+00, 6.39843749999853628196e+00,
	6.41406249999377564563e+00, 6.42968750000876010375e+00,
	6.44531250002396838283e+00, 6.46093750000062527761e+00,
	6.47656249999929212180e+00, 6.49218750000642064180e+00,
	6.50781249999003996720e+00, 6.52343750000912248055e+00,
	6.53906249998720845440e+00, 6.55468749999868371958e+00,
	6.57031249998638067211e+00, 6.58593750000546407364e+00,
	6.60156249994729282804e+00, 6.61718749997319211076e+00,
	6.63281249997879296387e+00, 6.64843749999244426618e+00,
	6.66406249999900524017e+00, 6.67968749999884092716e+00,
	6.69531249999227373593e+00, 6.71093749999063504674e+00,
	6.72656249999940136775e+00, 6.74218749999563193853e+00,
	6.75781249999463895506e+00, 6.77343750001427569174e+00,
	6.78906249999704858311e+00, 6.80468750000215738538e+00,
	6.82031250000341859874e+00, 6.83593749999844302323e+00,
	6.85156250001598987609e+00, 6.86718750000203925765e+00,
	6.88281250000989430760e+00, 6.89843750000604671868e+00,
	6.91406249999750777135e+00, 6.92968749999960120789e+00,
	6.94531249995244071016e+00, 6.96093750002739852789e+00,
	6.97656249999430233544e+00, 6.99218749999911892701e+00,
	7.00781250000804245559e+00, 7.02343750000080380147e+00,
	7.03906249999665778461e+00, 7.05468749999575539533e+00,
	7.07031250001700328767e+00, 7.08593750000647215614e+00,
	7.10156249997034372257e+00, 7.11718749999698641062e+00,
	7.13281250000188915550e+00, 7.14843750000192734717e+00,
	7.16406250000996358551e+00, 7.17968750005667022407e+00,
	7.19531250000950883816e+00, 7.21093749995827248966e+00,
	7.22656250000638511466e+00, 7.24218750002578115499e+00,
	7.25781249999116351290e+00, 7.27343749999614619384e+00,
	7.28906249998626343256e+00, 7.30468749998397015588e+00,
	7.32031249998488320330e+00, 7.33593749999550048813e+00,
	7.35156249998663557932e+00, 7.36718750000183675297e+00,
	7.38281249999652722238e+00, 7.39843750007829115134e+00,
	7.41406250000048494542e+00, 7.42968750000089794838e+00,
	7.44531249999165467557e+00, 7.46093749999333422096e+00,
	7.47656250000219557705e+00, 7.49218750000104360964e+00,
	7.50781249999853983468e+00, 7.52343749999573585541e+00,
	7.53906249999752819946e+00, 7.55468749999868549594e+00,
	7.57031250024692781153e+00, 7.58593750000690736357e+00,
	7.60156249999365662973e+00, 7.61718749999451283372e+00,
	7.63281249995806998498e+00, 7.64843749997276400876e+00,
	7.66406249998022381931e+00, 7.67968750000013145041e+00,
	7.69531249999808597551e+00, 7.71093750001158539931e+00,
	7.72656249999979038989e+00, 7.74218750000620037355e+00,
	7.75781249999318234245e+00, 7.77343750001715427800e+00,
	7.78906250000142730272e+00, 7.80468749997501465288e+00,
	7.82031249999300381859e+00, 7.83593750003314948316e+00,
	7.85156249999927524641e+00, 7.86718749999776001403e+00,
	7.88281249999449951105e+00, 7.89843749999351540936e+00,
	7.91406250000050803806e+00, 7.92968750004068656523e+00,
	7.94531249999952127183e+00, 7.96093750001230571200e+00,
	7.97656249999947331020e+00, 7.99218750003934363946e+00
};
