# Copyright, 2012, by Samuel G. D. Williams. <http://www.codeotaku.com>
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

module Build
	class Environment
		class Evaluator
			def initialize(environment)
				@environment = environment
				@cache = {}
			end
			
			def initialize_dup(other)
				@environment = other.instance_variable_get(:@environment)
				@cache = other.instance_variable_get(:@cache).dup
				
				super
			end
			
			def respond_to?(name, include_private = false)
				@environment.include?(name) || super
			end
			
			def method_missing(name)
				@cache[name] ||= object_value(@environment[name])
			end
			
			# Compute the literal object value for a given key:
			def object_value(value)
				case value
				when Array
					value.collect{|item| object_value(item)}.flatten
				when Symbol
					object_value(@environment[value])
				when Proc
					object_value(instance_exec(&value))
				when Default
					object_value(value.value)
				when Replace
					object_value(value.value)
				else
					value
				end
			end
		end
	end
end
