/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.french;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.international.french.FrenchTreebankLanguagePack;
import edu.stanford.nlp.util.Filter;
import java.util.Collections;

public class FrenchTreeNormalizer
extends BobChrisTreeNormalizer {
    private static final long serialVersionUID = 7868735300308066991L;
    private final String rootLabel;

    public FrenchTreeNormalizer() {
        super(new FrenchTreebankLanguagePack());
        this.rootLabel = this.tlp.startSymbol();
        this.aOverAFilter = new FrenchAOverAFilter();
        this.emptyFilter = new Filter<Tree>(){
            private static final long serialVersionUID = -22673346831392110L;

            @Override
            public boolean accept(Tree tree) {
                return !tree.isPreTerminal() || !tree.firstChild().value().equals("") && !tree.firstChild().value().equals("-NONE-");
            }
        };
    }

    public String normalizeTerminal(String terminal) {
        if (terminal == null) {
            return terminal;
        }
        if (terminal.equals(")")) {
            return "-RRB-";
        }
        if (terminal.equals("(")) {
            return "-LRB-";
        }
        return super.normalizeTerminal(terminal).intern();
    }

    public String normalizeNonterminal(String category) {
        return super.normalizeNonterminal(category).intern();
    }

    private String normalizePreterminal(Tree t) {
        if (this.tlp.isPunctuationWord(t.firstChild().value())) {
            return this.tlp.punctuationTags()[0].intern();
        }
        return t.value();
    }

    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        tree = tree.prune(this.emptyFilter, tf).spliceOut(this.aOverAFilter, tf);
        for (Tree t : tree) {
            if (t.isPreTerminal()) {
                String posStr = this.normalizePreterminal(t);
                t.setValue(posStr);
                if (!(t.label() instanceof HasTag)) continue;
                ((HasTag)((Object)t.label())).setTag(posStr);
                continue;
            }
            if (!t.isLeaf() || !t.value().contains("~#")) continue;
            String[] toks = t.value().split("~#");
            if (toks.length != 2) {
                System.err.printf("%s: Word contains malformed morph annotation: %s%n", this.getClass().getName(), t.value());
                continue;
            }
            if (t.label() instanceof CoreLabel) {
                ((CoreLabel)t.label()).setValue(toks[0].trim().intern());
                ((CoreLabel)t.label()).setWord(toks[0].trim().intern());
                ((CoreLabel)t.label()).setCurrent(toks[1].trim().intern());
                continue;
            }
            System.err.printf("%s: Cannot store morph analysis in non-CoreLabel: %s%n", this.getClass().getName(), t.label().getClass().getName());
        }
        while (tree != null && (tree.value() == null || tree.value().equals("")) && tree.numChildren() <= 1) {
            tree = tree.firstChild();
        }
        if (tree != null && !tree.value().equals(this.rootLabel)) {
            tree = tf.newTreeNode(this.rootLabel, Collections.singletonList(tree));
        }
        return tree;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FrenchAOverAFilter
    implements Filter<Tree> {
        private static final long serialVersionUID = 793800623099852951L;

        @Override
        public boolean accept(Tree t) {
            if (t.value() != null && t.value().equals("w")) {
                return false;
            }
            if (t.isLeaf() || t.isPreTerminal()) {
                return true;
            }
            return t.label() == null || t.label().value() == null || !t.label().value().equals(t.getChild(0).label().value());
        }
    }
}

