/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.AbstractThreadLocalTransaction;
import org.apache.tinkerpop.gremlin.structure.util.TransactionException;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElementContainer;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerTransactionGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerTransactionalIndex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertex;

final class TinkerTransaction
extends AbstractThreadLocalTransaction {
    private static final String TX_CONFLICT = "Conflict: element modified in another transaction";
    private static final long NOT_STARTED = -1L;
    private static final AtomicLong openedTx = new AtomicLong(0L);
    private final ThreadLocal<Long> txNumber = ThreadLocal.withInitial(() -> -1L);
    private final ThreadLocal<Set<TinkerElementContainer<TinkerVertex>>> txChangedVertices = new ThreadLocal();
    private final ThreadLocal<Set<TinkerElementContainer<TinkerEdge>>> txChangedEdges = new ThreadLocal();
    private final ThreadLocal<Set<TinkerElementContainer>> txReadElements = new ThreadLocal();
    private final TinkerTransactionGraph graph;

    public TinkerTransaction(TinkerTransactionGraph g) {
        super((Graph)g);
        this.graph = g;
    }

    public boolean isOpen() {
        return this.txNumber.get() != -1L;
    }

    public <T extends TraversalSource> T begin() {
        this.doOpen();
        return (T)super.begin();
    }

    protected void doOpen() {
        this.txNumber.set(openedTx.getAndIncrement());
    }

    protected long getTxNumber() {
        if (!this.isOpen()) {
            this.txNumber.set(openedTx.getAndIncrement());
        }
        return this.txNumber.get();
    }

    protected <T extends TinkerElement> void markChanged(TinkerElementContainer<T> container) {
        T element;
        if (!this.isOpen()) {
            this.txNumber.set(openedTx.getAndIncrement());
        }
        if (null == (element = container.getUnmodified())) {
            element = container.getModified();
        }
        if (element instanceof TinkerVertex) {
            if (null == this.txChangedVertices.get()) {
                this.txChangedVertices.set(new HashSet());
            }
            this.txChangedVertices.get().add(container);
        } else {
            if (null == this.txChangedEdges.get()) {
                this.txChangedEdges.set(new HashSet());
            }
            this.txChangedEdges.get().add(container);
        }
    }

    protected <T extends TinkerElement> void markRead(TinkerElementContainer container) {
        if (!this.isOpen()) {
            this.txNumber.set(openedTx.getAndIncrement());
        }
        if (null == this.txReadElements.get()) {
            this.txReadElements.set(new HashSet());
        }
        this.txReadElements.get().add(container);
    }

    protected void doCommit() throws TransactionException {
        Set<TinkerElementContainer<TinkerElementContainer>> changedEdges;
        long txVersion = this.txNumber.get();
        Set<TinkerElementContainer<TinkerVertex>> changedVertices = this.txChangedVertices.get();
        if (null == changedVertices) {
            changedVertices = Collections.emptySet();
        }
        if (null == (changedEdges = this.txChangedEdges.get())) {
            changedEdges = Collections.emptySet();
        }
        try {
            TinkerTransactionalIndex edgeIndex;
            if (changedVertices.stream().anyMatch(v -> v.updatedOutsideTransaction()) || changedEdges.stream().anyMatch(v -> v.updatedOutsideTransaction())) {
                throw new TransactionException(TX_CONFLICT);
            }
            changedVertices.forEach(v -> {
                if (!v.tryLock()) {
                    throw new TransactionException(TX_CONFLICT);
                }
            });
            changedEdges.forEach(e -> {
                if (!e.tryLock()) {
                    throw new TransactionException(TX_CONFLICT);
                }
            });
            if (changedVertices.stream().anyMatch(v -> v.updatedOutsideTransaction()) || changedEdges.stream().anyMatch(e -> e.updatedOutsideTransaction())) {
                throw new TransactionException(TX_CONFLICT);
            }
            TinkerTransactionalIndex vertexIndex = (TinkerTransactionalIndex)this.graph.vertexIndex;
            if (vertexIndex != null) {
                vertexIndex.commit(changedVertices);
            }
            if ((edgeIndex = (TinkerTransactionalIndex)this.graph.edgeIndex) != null) {
                edgeIndex.commit(changedEdges);
            }
            changedVertices.forEach(v -> v.commit(txVersion));
            changedEdges.forEach(e -> e.commit(txVersion));
        }
        catch (TransactionException ex) {
            TinkerTransactionalIndex edgeIndex;
            changedVertices.forEach(v -> v.rollback());
            changedEdges.forEach(e -> e.rollback());
            TinkerTransactionalIndex vertexIndex = (TinkerTransactionalIndex)this.graph.vertexIndex;
            if (vertexIndex != null) {
                vertexIndex.rollback();
            }
            if ((edgeIndex = (TinkerTransactionalIndex)this.graph.edgeIndex) != null) {
                edgeIndex.rollback();
            }
            throw ex;
        }
        finally {
            changedVertices.stream().filter(v -> v.canBeRemoved()).forEach(v -> this.graph.getVertices().remove(v.getElementId()));
            changedEdges.stream().filter(e -> e.canBeRemoved()).forEach(e -> this.graph.getEdges().remove(e.getElementId()));
            Set<TinkerElementContainer> readElements = this.txReadElements.get();
            if (readElements != null) {
                readElements.stream().forEach(e -> e.commit(txVersion));
            }
            this.txChangedVertices.remove();
            this.txChangedEdges.remove();
            this.txReadElements.remove();
            changedVertices.forEach(v -> v.releaseLock());
            changedEdges.forEach(e -> e.releaseLock());
            this.txNumber.set(-1L);
        }
    }

    protected void doRollback() throws TransactionException {
        Set<TinkerElementContainer> readElements;
        TinkerTransactionalIndex vertexIndex;
        Set<TinkerElementContainer<TinkerEdge>> changedEdges;
        Set<TinkerElementContainer<TinkerVertex>> changedVertices = this.txChangedVertices.get();
        if (null != changedVertices) {
            changedVertices.forEach(v -> v.rollback());
        }
        if (null != (changedEdges = this.txChangedEdges.get())) {
            changedEdges.forEach(e -> e.rollback());
        }
        if ((vertexIndex = (TinkerTransactionalIndex)this.graph.vertexIndex) != null) {
            vertexIndex.rollback();
        }
        TinkerTransactionalIndex edgeIndex = (TinkerTransactionalIndex)this.graph.edgeIndex;
        if (vertexIndex != null) {
            edgeIndex.rollback();
        }
        if (null != changedVertices) {
            changedVertices.stream().filter(v -> v.canBeRemoved()).forEach(v -> this.graph.getVertices().remove(v.getElementId()));
        }
        if (null != changedEdges) {
            changedEdges.stream().filter(e -> e.canBeRemoved()).forEach(e -> this.graph.getEdges().remove(e.getElementId()));
        }
        if ((readElements = this.txReadElements.get()) != null) {
            readElements.stream().forEach(e -> e.reset());
        }
        this.txChangedVertices.remove();
        this.txChangedEdges.remove();
        this.txReadElements.remove();
        this.txNumber.set(-1L);
    }
}

