/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.AbstractExplanation;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.util.ImmutableExplanation;
import org.javatuples.Pair;
import org.javatuples.Triplet;

public class TraversalExplanation
extends AbstractExplanation
implements Serializable {
    protected Traversal.Admin<?, ?> traversal;
    protected List<Pair<TraversalStrategy, Traversal.Admin<?, ?>>> strategyTraversals = new ArrayList();

    protected TraversalExplanation() {
    }

    public TraversalExplanation(Traversal.Admin<?, ?> traversal) {
        this.traversal = traversal.clone();
        DefaultTraversalStrategies mutatingStrategies = new DefaultTraversalStrategies();
        for (TraversalStrategy<?> strategy : this.traversal.getStrategies()) {
            Traversal.Admin<?, ?> mutatingTraversal = this.traversal.clone();
            mutatingStrategies.addStrategies(strategy);
            mutatingTraversal.setStrategies(mutatingStrategies);
            mutatingTraversal.applyStrategies();
            this.strategyTraversals.add(Pair.with(strategy, mutatingTraversal));
        }
    }

    public List<Pair<TraversalStrategy, Traversal.Admin<?, ?>>> getStrategyTraversals() {
        return Collections.unmodifiableList(this.strategyTraversals);
    }

    public Traversal.Admin<?, ?> getOriginalTraversal() {
        return this.traversal;
    }

    public ImmutableExplanation asImmutable() {
        return new ImmutableExplanation(this.getOriginalTraversalAsString(), this.getIntermediates().collect(Collectors.toList()));
    }

    @Override
    protected Stream<String> getStrategyTraversalsAsString() {
        return this.strategyTraversals.stream().map(Pair::getValue0).map(Object::toString);
    }

    @Override
    protected String getOriginalTraversalAsString() {
        return this.getOriginalTraversal().toString();
    }

    @Override
    protected Stream<Triplet<String, String, String>> getIntermediates() {
        return this.strategyTraversals.stream().map(p -> Triplet.with((Object)((TraversalStrategy)p.getValue0()).toString(), (Object)((TraversalStrategy)p.getValue0()).getTraversalCategory().getSimpleName(), (Object)((Traversal.Admin)p.getValue1()).toString()));
    }
}

