/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer;

import java.util.concurrent.Future;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public interface GraphComputer {
    public GraphComputer result(ResultGraph var1);

    public GraphComputer persist(Persist var1);

    public GraphComputer program(VertexProgram var1);

    public GraphComputer mapReduce(MapReduce var1);

    public GraphComputer workers(int var1);

    public GraphComputer vertices(Traversal<Vertex, Vertex> var1) throws IllegalArgumentException;

    public GraphComputer edges(Traversal<Vertex, Edge> var1) throws IllegalArgumentException;

    public GraphComputer vertexProperties(Traversal<Vertex, ? extends Property<?>> var1);

    default public GraphComputer configure(String key, Object value) {
        return this;
    }

    public Future<ComputerResult> submit();

    default public Features features() {
        return new Features(){};
    }

    public static class Exceptions {
        private Exceptions() {
        }

        public static UnsupportedOperationException adjacentVertexLabelsCanNotBeRead() {
            return new UnsupportedOperationException("The label of an adjacent vertex can not be read");
        }

        public static UnsupportedOperationException adjacentVertexPropertiesCanNotBeReadOrUpdated() {
            return new UnsupportedOperationException("The properties of an adjacent vertex can not be read or updated");
        }

        public static UnsupportedOperationException adjacentVertexEdgesAndVerticesCanNotBeReadOrUpdated() {
            return new UnsupportedOperationException("The edges and vertices of an adjacent vertex can not be read or updated");
        }

        public static UnsupportedOperationException graphFilterNotSupported() {
            return new UnsupportedOperationException("The computer does not support graph filter");
        }

        public static IllegalArgumentException providedKeyIsNotAnElementComputeKey(String key) {
            return new IllegalArgumentException("The provided key is not an element compute key: " + key);
        }

        public static IllegalArgumentException providedKeyIsNotAMemoryComputeKey(String key) {
            return new IllegalArgumentException("The provided key is not a memory compute key: " + key);
        }

        public static IllegalArgumentException resultGraphPersistCombinationNotSupported(ResultGraph resultGraph, Persist persist) {
            return new IllegalArgumentException("The computer does not support the following result graph and persist combination: " + (Object)((Object)resultGraph) + ":" + (Object)((Object)persist));
        }

        public static IllegalStateException computerHasAlreadyBeenSubmittedAVertexProgram() {
            return new IllegalStateException("This computer has already had a vertex program submitted to it");
        }

        public static IllegalStateException computerHasNoVertexProgramNorMapReducers() {
            return new IllegalStateException("The computer has no vertex program or map reducers to execute");
        }

        public static UnsupportedOperationException incidentAndAdjacentElementsCanNotBeAccessedInMapReduce() {
            return new UnsupportedOperationException("The computer is in MapReduce mode and a vertex's incident and adjacent elements can not be accessed");
        }

        public static UnsupportedOperationException vertexPropertiesCanNotBeUpdatedInMapReduce() {
            return new UnsupportedOperationException("The computer is in MapReduce mode and a vertex's properties can not be updated");
        }

        public static IllegalArgumentException computerRequiresMoreWorkersThanSupported(int workers, int maxWorkers) {
            return new IllegalArgumentException("The computer requires more workers than supported: " + workers + " [max:" + maxWorkers + "]");
        }

        public static IllegalArgumentException vertexFilterAccessesIncidentEdges(Traversal<Vertex, Vertex> vertexFilter) {
            return new IllegalArgumentException("The provided vertex filter traversal accesses incident edges: " + vertexFilter);
        }

        public static IllegalArgumentException edgeFilterAccessesAdjacentVertices(Traversal<Vertex, Edge> edgeFilter) {
            return new IllegalArgumentException("The provided edge filter traversal accesses data on adjacent vertices: " + edgeFilter);
        }
    }

    public static interface Features {
        default public int getMaxWorkers() {
            return Integer.MAX_VALUE;
        }

        default public boolean supportsGlobalMessageScopes() {
            return true;
        }

        default public boolean supportsLocalMessageScopes() {
            return true;
        }

        default public boolean supportsVertexAddition() {
            return true;
        }

        default public boolean supportsVertexRemoval() {
            return true;
        }

        default public boolean supportsVertexPropertyAddition() {
            return true;
        }

        default public boolean supportsVertexPropertyRemoval() {
            return true;
        }

        default public boolean supportsEdgeAddition() {
            return true;
        }

        default public boolean supportsEdgeRemoval() {
            return true;
        }

        default public boolean supportsEdgePropertyAddition() {
            return true;
        }

        default public boolean supportsEdgePropertyRemoval() {
            return true;
        }

        default public boolean supportsResultGraphPersistCombination(ResultGraph resultGraph, Persist persist) {
            return true;
        }

        default public boolean supportsGraphFilter() {
            return true;
        }

        default public boolean supportsDirectObjects() {
            return true;
        }
    }

    public static enum Persist {
        NOTHING,
        VERTEX_PROPERTIES,
        EDGES;

    }

    public static enum ResultGraph {
        ORIGINAL,
        NEW;

    }
}

