/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;

public class OidcRegisteredServiceJsonWebKeystoreCacheLoader
implements CacheLoader<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcRegisteredServiceJsonWebKeystoreCacheLoader.class);
    private final ApplicationContext applicationContext;

    public Optional<JsonWebKeySet> load(OidcJsonWebKeyCacheKey cacheKey) {
        OAuthRegisteredService service = cacheKey.getRegisteredService();
        if (service instanceof OidcRegisteredService) {
            OidcRegisteredService oidcService = (OidcRegisteredService)service;
            Optional<JsonWebKeySet> jwks = OidcJsonWebKeyStoreUtils.getJsonWebKeySet(oidcService, (ResourceLoader)this.applicationContext, Optional.of(cacheKey.getUsage()));
            if (jwks.isEmpty() || jwks.get().getJsonWebKeys().isEmpty()) {
                LOGGER.debug("Could not determine JSON web keys for service [{}]", (Object)oidcService);
                return Optional.empty();
            }
            Optional<String> requestedKid = Optional.ofNullable(oidcService.getJwksKeyId());
            LOGGER.debug("Locating requested key [{}] for service [{}]", requestedKid, (Object)oidcService);
            Optional<JsonWebKeySet> keyset = OidcJsonWebKeyStoreUtils.getJsonWebKeyFromJsonWebKeySet(jwks.get(), requestedKid, Optional.of(cacheKey.getUsage()));
            keyset.ifPresent(k -> LOGGER.debug("Located requested key [{}] for service [{}]", k, (Object)oidcService));
            return keyset;
        }
        return Optional.empty();
    }

    @Generated
    public OidcRegisteredServiceJsonWebKeystoreCacheLoader(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

