/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.session;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apereo.cas.client.configuration.ConfigurationKeys;
import org.apereo.cas.client.session.SessionMappingStorage;
import org.apereo.cas.client.session.SingleSignOutHandler;
import org.apereo.cas.client.util.AbstractConfigurationFilter;

public final class SingleSignOutFilter
extends AbstractConfigurationFilter {
    private static final SingleSignOutHandler HANDLER = new SingleSignOutHandler();
    private final AtomicBoolean handlerInitialized = new AtomicBoolean(false);

    static SingleSignOutHandler getSingleSignOutHandler() {
        return HANDLER;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (!this.isIgnoreInitConfiguration()) {
            SingleSignOutFilter.setArtifactParameterName(this.getString(ConfigurationKeys.ARTIFACT_PARAMETER_NAME));
            SingleSignOutFilter.setLogoutParameterName(this.getString(ConfigurationKeys.LOGOUT_PARAMETER_NAME));
            SingleSignOutFilter.setRelayStateParameterName(this.getString(ConfigurationKeys.RELAY_STATE_PARAMETER_NAME));
            SingleSignOutFilter.setLogoutCallbackPath(this.getString(ConfigurationKeys.LOGOUT_CALLBACK_PATH));
            HANDLER.setArtifactParameterOverPost(this.getBoolean(ConfigurationKeys.ARTIFACT_PARAMETER_OVER_POST));
            HANDLER.setEagerlyCreateSessions(this.getBoolean(ConfigurationKeys.EAGERLY_CREATE_SESSIONS));
        }
        HANDLER.init();
        this.handlerInitialized.set(true);
    }

    public static void setArtifactParameterName(String name) {
        HANDLER.setArtifactParameterName(name);
    }

    public static void setLogoutParameterName(String name) {
        HANDLER.setLogoutParameterName(name);
    }

    public static void setRelayStateParameterName(String name) {
        HANDLER.setRelayStateParameterName(name);
    }

    public static void setLogoutCallbackPath(String logoutCallbackPath) {
        HANDLER.setLogoutCallbackPath(logoutCallbackPath);
    }

    public static void setSessionMappingStorage(SessionMappingStorage storage) {
        HANDLER.setSessionMappingStorage(storage);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.handlerInitialized.getAndSet(true)) {
            HANDLER.init();
        }
        if (HANDLER.process(request, response)) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

