/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.router.AbstractMappingMessageRouter;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

class AbstractMessageProcessingRouter
extends AbstractMappingMessageRouter
implements ManageableLifecycle {
    private final MessageProcessor<?> messageProcessor;

    AbstractMessageProcessingRouter(MessageProcessor<?> messageProcessor) {
        Assert.notNull(messageProcessor, (String)"messageProcessor must not be null");
        this.messageProcessor = messageProcessor;
    }

    @Override
    public final void onInit() {
        MessageProcessor<?> messageProcessor;
        ConversionService conversionService;
        super.onInit();
        if (this.messageProcessor instanceof AbstractMessageProcessor && (conversionService = this.getConversionService()) != null) {
            ((AbstractMessageProcessor)this.messageProcessor).setConversionService(conversionService);
        }
        if ((messageProcessor = this.messageProcessor) instanceof BeanFactoryAware) {
            BeanFactoryAware beanFactoryAware = (BeanFactoryAware)messageProcessor;
            if (this.getBeanFactory() != null) {
                beanFactoryAware.setBeanFactory(this.getBeanFactory());
            }
        }
    }

    @Override
    public void start() {
        MessageProcessor<?> messageProcessor = this.messageProcessor;
        if (messageProcessor instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)messageProcessor;
            lifecycle.start();
        }
    }

    @Override
    public void stop() {
        MessageProcessor<?> messageProcessor = this.messageProcessor;
        if (messageProcessor instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)messageProcessor;
            lifecycle.stop();
        }
    }

    @Override
    public boolean isRunning() {
        Lifecycle lifecycle;
        MessageProcessor<?> messageProcessor = this.messageProcessor;
        return !(messageProcessor instanceof Lifecycle) || (lifecycle = (Lifecycle)messageProcessor).isRunning();
    }

    @Override
    protected List<Object> getChannelKeys(Message<?> message) {
        Object result = this.messageProcessor.processMessage(message);
        return Collections.singletonList(result);
    }
}

