/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication})
@Configuration(value="CasWebApplicationServiceFactoryConfiguration", proxyBeanMethods=false)
class CasWebApplicationServiceFactoryConfiguration {
    CasWebApplicationServiceFactoryConfiguration() {
    }

    @Configuration(value="CasWebApplicationServiceFactoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasWebApplicationServiceFactoryPlanConfiguration {
        CasWebApplicationServiceFactoryPlanConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"casWebApplicationServiceFactoryConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceFactoryConfigurer casWebApplicationServiceFactoryConfigurer(@Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
            return () -> CollectionUtils.wrap((Object)webApplicationServiceFactory);
        }
    }

    @Configuration(value="CasWebApplicationServiceFactoryBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasWebApplicationServiceFactoryBaseConfiguration {
        CasWebApplicationServiceFactoryBaseConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"webApplicationServiceFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceFactory<WebApplicationService> webApplicationServiceFactory(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor) {
            return new WebApplicationServiceFactory(tenantExtractor);
        }
    }
}

